/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.query;

import fr.gael.drb.query.Environment;
import fr.gael.drb.query.GrammarContext;
import fr.gael.drb.query.ParseException;
import fr.gael.drb.query.QueryParser;
import fr.gael.drb.query.StaticContext;
import fr.gael.drb.query.StaticException;
import fr.gael.drb.query.Token;
import fr.gael.drb.query.TokenMgrError;
import fr.gael.drb.query.TypeException;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.StringReader;
import java.util.Vector;
import javax.swing.Timer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.log4j.Logger;

public class XQueryDocument
extends DefaultStyledDocument {
    private Logger logger = Logger.getLogger(XQueryDocument.class);
    protected MutableAttributeSet commentStyle = null;
    protected MutableAttributeSet typeExceptionStyle = null;
    protected MutableAttributeSet staticExceptionStyle = null;
    protected MutableAttributeSet baseStyle = null;
    private GrammarContext context = new GrammarContext();
    private String commentText = null;
    protected Timer timer = null;
    protected DocumentUpdater updater = new DocumentUpdater();

    public XQueryDocument() {
        this.initFont();
    }

    public void initFont() {
        this.baseStyle = new SimpleAttributeSet();
        Color darkBlue = new Color(0, 0, 139);
        Color darkGreen = new Color(0, 115, 0);
        Color darkRed = new Color(139, 0, 0);
        StyleConstants.setFontFamily(this.baseStyle, this.context.getDefaultFont().getFamily());
        StyleConstants.setFontSize(this.baseStyle, this.context.getDefaultFont().getSize());
        this.commentStyle = new SimpleAttributeSet(this.baseStyle);
        StyleConstants.setForeground(this.commentStyle, darkGreen);
        SimpleAttributeSet typeStyle = new SimpleAttributeSet();
        StyleConstants.setUnderline(typeStyle, true);
        this.typeExceptionStyle = new SimpleAttributeSet(typeStyle);
        SimpleAttributeSet staticStyle = new SimpleAttributeSet();
        StyleConstants.setItalic(staticStyle, true);
        StyleConstants.setUnderline(staticStyle, true);
        this.staticExceptionStyle = new SimpleAttributeSet(staticStyle);
    }

    public MutableAttributeSet getBaseStyle() {
        return this.baseStyle;
    }

    public void setDefaultFontSize(float font_size) {
        this.context.setDefaultFontSize(font_size);
        this.initFont();
    }

    @Override
    public void insertString(int offs, String str, AttributeSet attr) throws BadLocationException {
        super.insertString(offs, str, this.commentStyle);
        try {
            if (this.timer != null) {
                this.timer.restart();
            } else {
                this.timer = new Timer(2000, this.updater);
                this.timer.setRepeats(false);
                this.timer.start();
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        super.remove(offs, len);
        try {
            if (this.timer != null) {
                this.timer.restart();
            } else {
                this.timer = new Timer(2000, this.updater);
                this.timer.setRepeats(false);
                this.timer.start();
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    protected void parseUpdate(int offs, int len) {
        String text = "";
        int text_length = this.getLength();
        try {
            text = this.getText(0, text_length);
        }
        catch (BadLocationException bad_loc) {
            this.logger.warn("Cannot retrieve the text.");
            return;
        }
        QueryParser parser = new QueryParser(new StringReader(text));
        Token current_token = null;
        try {
            current_token = parser.getNextToken();
        }
        catch (TokenMgrError tokenMgrError) {
            // empty catch block
        }
        int i_token = 0;
        int stop = 0;
        while (current_token != null) {
            if (current_token.toString() != null) {
                this.setCharacterAttributes(stop, current_token.beginOffset, this.commentStyle, true);
                if (this.context.getStyleForScanValue(current_token.kind) != null) {
                    this.setCharacterAttributes(current_token.beginOffset, current_token.endOffset + 1, this.context.getStyleForScanValue(current_token.kind), true);
                    stop = current_token.endOffset + 1;
                }
            }
            try {
                current_token = parser.getNextToken();
            }
            catch (TokenMgrError token_manager_error) {
                break;
            }
            if (current_token.toString() != null && current_token.toString().equals("")) {
                current_token = null;
            }
            ++i_token;
        }
        this.setCharacterAttributes(stop, text_length, this.commentStyle, true);
        boolean has_static_exception = false;
        boolean has_type_exception = false;
        int exception_start = 0;
        int exception_stop = 0;
        this.commentText = null;
        try {
            try {
                StringReader query_reader = new StringReader(text);
                parser.parse(query_reader, new StaticContext(new Environment()));
            }
            catch (StaticException static_exception) {
                has_static_exception = true;
                if (static_exception.getBeginLine() == 0 || static_exception.getBeginColumn() == 0 || static_exception.getEndLine() == 0 || static_exception.getEndColumn() == 0) {
                    exception_start = 0;
                    exception_stop = text_length - 1;
                } else {
                    Element root = this.getDefaultRootElement();
                    exception_start = root.getElement(static_exception.getBeginLine() - 1).getStartOffset() + static_exception.getBeginColumn() - 1;
                    exception_stop = root.getElement(static_exception.getEndLine() - 1).getStartOffset() + static_exception.getEndColumn() - 1;
                }
                this.commentText = static_exception.getMessage();
            }
            catch (TypeException type_exception) {
                has_type_exception = true;
                Element root = this.getDefaultRootElement();
                exception_start = root.getElement(type_exception.getBeginLine() - 1).getStartOffset() + type_exception.getBeginColumn() - 1;
                exception_stop = root.getElement(type_exception.getEndLine() - 1).getStartOffset() + type_exception.getEndColumn() - 1;
                this.commentText = type_exception.getMessage();
            }
            catch (TokenMgrError type_exception) {}
        }
        catch (Throwable throwable) {
            return;
        }
        if (has_static_exception) {
            this.setCharacterAttributes(exception_start, exception_stop, this.staticExceptionStyle, false);
        } else if (has_type_exception) {
            this.setCharacterAttributes(exception_start, exception_stop, this.typeExceptionStyle, false);
        }
    }

    protected void parseUpdateOld(int offs, int len) {
        String text = "";
        try {
            text = this.getText(0, this.getLength());
        }
        catch (BadLocationException bad_loc) {
            this.logger.warn("Cannot retrieve the text.");
            return;
        }
        Element root = this.getDefaultRootElement();
        QueryParser parser = new QueryParser(new StringReader(text));
        Token current_token = null;
        try {
            current_token = parser.getNextToken();
        }
        catch (TokenMgrError token_manager_error) {
            this.setCharacterAttributes(0, this.getLength(), this.commentStyle, true);
        }
        int i_token = 0;
        int start = 0;
        int stop = 0;
        while (current_token != null) {
            if (current_token.toString() != null) {
                start = stop;
                stop = root.getElement(current_token.endLine - 1).getStartOffset() + current_token.endColumn - 1;
                this.setCharacterAttributes(start, stop, this.commentStyle, true);
                start = root.getElement(current_token.beginLine - 1).getStartOffset() + current_token.beginColumn - 1;
                stop = root.getElement(current_token.endLine - 1).getStartOffset() + current_token.endColumn;
                if (this.context.getStyleForScanValue(current_token.kind) != null) {
                    this.setCharacterAttributes(start, stop, this.context.getStyleForScanValue(current_token.kind), true);
                } else {
                    this.setCharacterAttributes(start, stop, this.commentStyle, true);
                }
            }
            try {
                current_token = parser.getNextToken();
            }
            catch (TokenMgrError token_manager_error) {
                break;
            }
            if (current_token.toString() != null && current_token.toString().equals("")) {
                current_token = null;
            }
            ++i_token;
        }
        this.setCharacterAttributes(stop + 1, this.getLength(), this.commentStyle, true);
        boolean has_static_exception = false;
        boolean has_type_exception = false;
        int exception_start = 0;
        int exception_stop = 0;
        this.commentText = null;
        try {
            try {
                StringReader query_reader = new StringReader(text);
                parser.parse(query_reader, new StaticContext(new Environment()));
            }
            catch (StaticException static_exception) {
                has_static_exception = true;
                if (static_exception.getBeginLine() == 0 || static_exception.getBeginColumn() == 0 || static_exception.getEndLine() == 0 || static_exception.getEndColumn() == 0) {
                    exception_start = 0;
                    exception_stop = this.getLength() - 1;
                } else {
                    exception_start = root.getElement(static_exception.getBeginLine() - 1).getStartOffset() + static_exception.getBeginColumn() - 1;
                    exception_stop = root.getElement(static_exception.getEndLine() - 1).getStartOffset() + static_exception.getEndColumn() - 1;
                }
                this.commentText = static_exception.getMessage();
            }
            catch (TypeException type_exception) {
                has_type_exception = true;
                exception_start = root.getElement(type_exception.getBeginLine() - 1).getStartOffset() + type_exception.getBeginColumn() - 1;
                exception_stop = root.getElement(type_exception.getEndLine() - 1).getStartOffset() + type_exception.getEndColumn() - 1;
                this.commentText = type_exception.getMessage();
            }
            catch (TokenMgrError type_exception) {}
        }
        catch (Throwable throwable) {
            return;
        }
        if (has_static_exception) {
            this.setCharacterAttributes(exception_start, exception_stop, this.staticExceptionStyle, false);
        } else if (has_type_exception) {
            this.setCharacterAttributes(exception_start, exception_stop, this.typeExceptionStyle, false);
        }
    }

    public String getComment() {
        return this.commentText;
    }

    public Vector getCompletion(int offset) {
        String text = "";
        Vector<Object[]> items = null;
        try {
            text = this.getText(0, offset);
        }
        catch (BadLocationException exception) {
            return items;
        }
        try {
            QueryParser parser = new QueryParser(new StringReader(text));
            items = new Vector<Object[]>();
            try {
                StringReader query_reader = new StringReader(text);
                parser.parse(query_reader, new StaticContext(new Environment()));
            }
            catch (StaticException static_exception) {
                ParseException parse_exception = static_exception.getParseException();
                if (parse_exception == null) {
                    return null;
                }
                Token token = parse_exception.currentToken.next;
                if (token == null) {
                    return null;
                }
                if (token.kind == 0) {
                    for (int i = 0; i < parse_exception.expectedTokenSequences.length; ++i) {
                        if (parse_exception.expectedTokenSequences[i].length != 1) continue;
                        String current = parse_exception.tokenImage[parse_exception.expectedTokenSequences[i][0]];
                        current = current.replaceAll("\"", "");
                        boolean enabled = true;
                        if (current.startsWith("<")) {
                            if (current.equals("<Slash>")) {
                                current = "/";
                            } else if (current.equals("<Variable>")) {
                                current = "$";
                            } else {
                                enabled = false;
                            }
                        }
                        if (current.equals("")) continue;
                        items.add(new Object[]{current, enabled});
                    }
                } else {
                    int maxSize = 0;
                    for (int i = 0; i < parse_exception.expectedTokenSequences.length; ++i) {
                        String expected = "";
                        if (maxSize < parse_exception.expectedTokenSequences[i].length) {
                            maxSize = parse_exception.expectedTokenSequences[i].length;
                        }
                        for (int j = 0; j < parse_exception.expectedTokenSequences[i].length; ++j) {
                            expected = expected + parse_exception.tokenImage[parse_exception.expectedTokenSequences[i][j]] + " ";
                        }
                        if (parse_exception.expectedTokenSequences[i][parse_exception.expectedTokenSequences[i].length - 1] != 0) {
                            expected = expected + "...";
                        }
                        expected = expected.replaceAll("\"", " ");
                        items.add(new Object[]{expected, false});
                    }
                }
            }
            catch (TypeException typeException) {
            }
            catch (TokenMgrError tokenMgrError) {
            }
        }
        catch (Throwable throwable) {
            return null;
        }
        return items;
    }

    private class DocumentUpdater
    implements ActionListener {
        private DocumentUpdater() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            XQueryDocument.this.parseUpdate(0, XQueryDocument.this.getLength());
        }
    }
}

