/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.value;

import fr.gael.drb.value.AbstractNumeric;
import fr.gael.drb.value.Comparison;
import fr.gael.drb.value.FloatArray;
import fr.gael.drb.value.Numeric;
import fr.gael.drb.value.Value;
import fr.gael.drb.value.ValueFormat;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;

public class Float
extends AbstractNumeric
implements ValueFormat {
    static final int PRIORITY = 6;
    float value;

    public Float(float v) {
        this.value = v;
    }

    public String toString() {
        return java.lang.Float.toString(this.value);
    }

    @Override
    public String getFormattedString(int length) {
        return Float.getFormattedString(length, this.value);
    }

    @Override
    public byte[] getFormattedBuffer() {
        byte[] buffer = new byte[4];
        int int_value = java.lang.Float.floatToRawIntBits(this.value);
        buffer[0] = (byte)(int_value >>> 24);
        buffer[1] = (byte)(int_value >>> 16);
        buffer[2] = (byte)(int_value >>> 8);
        buffer[3] = (byte)int_value;
        return buffer;
    }

    public static String getFormattedString(int length, float value) {
        return new String(new DecimalFormat("+0.00000000E00;-0.00000000E00").format(value));
    }

    @Override
    public final int getType() {
        return 5;
    }

    @Override
    public final int getPriority() {
        return 6;
    }

    @Override
    public final Value convertTo(int type) {
        switch (type) {
            case 5: {
                return this;
            }
            case 10: {
                FloatArray floatArray = new FloatArray(1);
                floatArray.assign(0, this.floatValue());
                return floatArray;
            }
        }
        return super.convertTo(type);
    }

    @Override
    public void assign(Value v) {
        Float vf = (Float)v.convertTo(5);
        this.value = vf.floatValue();
    }

    @Override
    public Value unaryMinus() {
        return new Float(-this.value);
    }

    @Override
    public Value add(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).add(x);
        }
        return new Float(this.floatValue() + ((Numeric)x).floatValue());
    }

    @Override
    public Value sub(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).sub(x);
        }
        return new Float(this.floatValue() - ((Numeric)x).floatValue());
    }

    @Override
    public Value multiply(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).multiply(x);
        }
        return new Float(this.floatValue() * ((Numeric)x).floatValue());
    }

    @Override
    public final Value divide(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).divide(x);
        }
        return new Float(this.floatValue() / ((Numeric)x).floatValue());
    }

    @Override
    public Value modulus(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).modulus(x);
        }
        return new Float(this.floatValue() % ((Numeric)x).floatValue());
    }

    @Override
    public int compareTo(Value x) {
        if (this.getPriority() >= x.getPriority()) {
            float cmp = this.floatValue() - ((Numeric)x).floatValue();
            if (cmp == 0.0f) {
                return 0;
            }
            if (cmp < 0.0f) {
                return -1;
            }
            return 1;
        }
        return -((Comparison)((Object)x)).compareTo(this);
    }

    @Override
    public final boolean booleanValue() {
        return !java.lang.Float.isNaN(this.value) && this.value != 0.0f;
    }

    @Override
    public final byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public final short shortValue() {
        return (short)this.value;
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final long longValue() {
        return (long)this.value;
    }

    @Override
    public final float floatValue() {
        return this.value;
    }

    @Override
    public final double doubleValue() {
        return this.value;
    }

    @Override
    protected BigInteger integerValue() {
        return new BigDecimal(this.toString()).toBigInteger();
    }

    @Override
    protected BigDecimal decimalValue() {
        return new BigDecimal(this.toString());
    }

    @Override
    public final void assign(boolean value) {
        this.value = value ? 1.0f : 0.0f;
    }

    @Override
    public final void assign(byte value) {
        this.value = value;
    }

    @Override
    public final void assign(int value) {
        this.value = value;
    }

    @Override
    public final void assign(short value) {
        this.value = value;
    }

    @Override
    public final void assign(long value) {
        this.value = value;
    }

    @Override
    public final void assign(float value) {
        this.value = value;
    }

    @Override
    public final void assign(double value) {
        this.value = (float)value;
    }

    public static void main(String[] args) {
        System.out.println(" 123456.78 toString() : [" + new Float(123456.78f) + "]");
        System.out.println("-1234.5678 toString() : [" + new Float(-1234.5677f) + "]");
        System.out.println(" 0.0012345 toString() : [" + new Float(0.0012345f) + "]");
        System.out.println("-0.0012345 toString() : [" + new Float(-0.0012345f) + "]");
    }
}

