/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.value;

import fr.gael.drb.value.AbstractNumeric;
import fr.gael.drb.value.Comparison;
import fr.gael.drb.value.Int;
import fr.gael.drb.value.Numeric;
import fr.gael.drb.value.Short;
import fr.gael.drb.value.Value;
import fr.gael.drb.value.ValueFormat;

public class UnsignedShort
extends AbstractNumeric
implements ValueFormat {
    static final int PRIORITY = 2;
    short value;

    public UnsignedShort(short value) {
        this.value = value;
    }

    public UnsignedShort(int value) {
        this.value = (short)value;
    }

    public String toString() {
        return Integer.toString(this.value & 0xFFFF);
    }

    @Override
    public String getFormattedString(int length) {
        return Short.getFormattedString(length, this.value, false);
    }

    @Override
    public byte[] getFormattedBuffer() {
        return Short.getFormattedBuffer(this.value);
    }

    @Override
    public final int getType() {
        return 13;
    }

    @Override
    public final int getPriority() {
        return 2;
    }

    @Override
    public final Value convertTo(int type) throws ClassCastException {
        switch (type) {
            case 9: 
            case 13: {
                return this;
            }
        }
        return super.convertTo(type);
    }

    @Override
    public void assign(Value v) {
        Numeric vs = (Numeric)v.convertTo(9);
        this.value = vs.shortValue();
    }

    @Override
    public Value unaryMinus() {
        return new Short((int)(-this.value));
    }

    @Override
    public final Value add(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).add(x);
        }
        Numeric num = (Numeric)x.convertTo(9);
        int sum = num.intValue() + this.intValue();
        if (sum < java.lang.Short.MIN_VALUE || sum > 65535) {
            return new Int(sum);
        }
        if (sum < 32768) {
            return new Short((short)sum);
        }
        return new UnsignedShort((short)sum);
    }

    @Override
    public Value sub(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).sub(x);
        }
        Numeric num = (Numeric)x.convertTo(9);
        int dif = this.intValue() - num.intValue();
        if (dif < java.lang.Short.MIN_VALUE || dif > 65535) {
            return new Int(dif);
        }
        if ((long)dif < 32768L) {
            return new Short((short)dif);
        }
        return new UnsignedShort((short)dif);
    }

    @Override
    public Value multiply(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).multiply(x);
        }
        Numeric num = (Numeric)x.convertTo(9);
        int prod = this.intValue() * num.intValue();
        if (prod < java.lang.Short.MIN_VALUE || prod > 65535) {
            return new Int(prod);
        }
        if ((long)prod < 32768L) {
            return new Short((short)prod);
        }
        return new UnsignedShort((short)prod);
    }

    @Override
    public final Value divide(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).divide(x);
        }
        Numeric num = (Numeric)x.convertTo(9);
        int div = this.intValue() / num.intValue();
        if (div < java.lang.Short.MIN_VALUE || div > 65535) {
            return new Int(div);
        }
        if (div < 32768) {
            return new Short((short)div);
        }
        return new UnsignedShort((short)div);
    }

    @Override
    public Value modulus(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).modulus(x);
        }
        Numeric num = (Numeric)x.convertTo(9);
        int mod = this.intValue() % num.intValue();
        if (mod < java.lang.Short.MIN_VALUE || mod > 65535) {
            return new Int(mod);
        }
        if (mod < 32768) {
            return new Short((short)mod);
        }
        return new UnsignedShort((short)mod);
    }

    @Override
    public int compareTo(Value x) {
        if (this.getPriority() >= x.getPriority()) {
            return this.intValue() - ((Numeric)x).intValue();
        }
        return -((Comparison)((Object)x)).compareTo(this);
    }

    @Override
    public final boolean booleanValue() {
        return this.value != 0;
    }

    @Override
    public final byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public final int intValue() {
        return this.value & 0xFFFF;
    }

    @Override
    public final long longValue() {
        return (long)this.value & 0xFFFFL;
    }

    @Override
    public final short shortValue() {
        return this.value;
    }

    @Override
    public final float floatValue() {
        return this.value & 0xFFFF;
    }

    @Override
    public final double doubleValue() {
        return this.value & 0xFFFF;
    }

    @Override
    public final void assign(boolean value) {
        this.value = value ? (short)1 : 0;
    }

    @Override
    public final void assign(byte value) {
        this.value = value;
    }

    @Override
    public final void assign(int value) {
        this.value = (short)value;
    }

    @Override
    public final void assign(short value) {
        this.value = value;
    }

    @Override
    public final void assign(long value) {
        this.value = (short)value;
    }

    @Override
    public final void assign(float value) {
        this.value = (short)value;
    }

    @Override
    public final void assign(double value) {
        this.value = (short)value;
    }
}

