/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.xsd;

import fr.gael.drb.value.Int;
import fr.gael.drb.value.Numeric;
import fr.gael.drb.value.Value;
import fr.gael.drb.xsd.XsdFacet;
import org.apache.log4j.Logger;

public class XsdFractionDigitsFacet
extends XsdFacet {
    private static Logger logger = Logger.getLogger(XsdFractionDigitsFacet.class);
    static final String TAG = "fractionDigits";
    private int value;

    XsdFractionDigitsFacet(Value value) {
        this.value = ((Int)value.convertTo(3)).intValue();
    }

    @Override
    public final int getId() {
        return 12;
    }

    @Override
    public final Value getValue() {
        return new Int(this.value);
    }

    @Override
    public final String getName() {
        return TAG;
    }

    @Override
    public boolean isValid(Value v) {
        if (v == null) {
            return false;
        }
        try {
            switch (v.getType()) {
                case 5: {
                    logger.error("fractionDigits facet is not allowed for xs:float datatype");
                    return false;
                }
                case 6: {
                    logger.error("fractionDigits facet is not allowed for xs:double datatype");
                    return false;
                }
                case 10: {
                    logger.error("fractionDigits facet is not allowed for list datatype");
                    return false;
                }
            }
            Numeric num = (Numeric)v.convertTo(26);
            return true;
        }
        catch (ClassCastException e) {
            logger.warn("fractionDigitsFacet: Cannot convert '" + v + "' to xs:decimal.");
            return false;
        }
    }
}

