/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drbx.cortex;

import fr.gael.drb.DrbItem;
import fr.gael.drb.DrbSequence;
import fr.gael.drb.meta.DrbDefaultMetadata;
import fr.gael.drb.meta.DrbMetadata;
import fr.gael.drb.meta.DrbMetadataResolver;
import fr.gael.drb.value.String;
import fr.gael.drb.value.Value;
import fr.gael.drbx.cortex.DrbCortexItemClass;
import fr.gael.drbx.cortex.DrbCortexModel;
import java.io.IOException;
import org.apache.log4j.Logger;

public class DrbCortexMetadataResolver
implements DrbMetadataResolver {
    private static Logger logger = Logger.getLogger(DrbCortexMetadataResolver.class);
    private DrbCortexModel model = null;

    public DrbCortexMetadataResolver() throws IOException {
    }

    public DrbCortexMetadataResolver(DrbCortexModel model) {
        if (model == null) {
            throw new NullPointerException("Cannot create a metadata resolver from a null model.");
        }
        this.model = model;
    }

    public DrbMetadata resolveMetadata(java.lang.String name) {
        return null;
    }

    public DrbMetadata resolveMetadata(DrbItem item) {
        DrbCortexItemClass item_class;
        if (this.model == null) {
            try {
                this.model = DrbCortexModel.getDefaultModel();
            }
            catch (IOException exception) {
                logger.error("Cannot load default model.", exception);
                return null;
            }
        }
        if ((item_class = this.model.getClassOf(item)) == null) {
            return null;
        }
        java.lang.String implementation_identifier = item_class.getPropertyString(DrbCortexModel.getUriPrefix() + "implementationIdentifier", false);
        java.lang.String schema_location = item_class.getSchemaLocation();
        if (implementation_identifier == null && schema_location == null) {
            return null;
        }
        DrbDefaultMetadata metadata = new DrbDefaultMetadata("", "");
        if (implementation_identifier != null) {
            metadata.setProperty("implementationIdentifier", (Value)new String(implementation_identifier));
        }
        if (schema_location != null) {
            metadata.setProperty("schemaLocation", (Value)new String(schema_location));
        }
        return metadata;
    }

    public DrbMetadata resolveMetadata(DrbSequence sequence) {
        if (sequence == null || sequence.getLength() < 1) {
            return null;
        }
        DrbItem item = sequence.getItem(0);
        if (item == null) {
            return null;
        }
        return this.resolveMetadata(item);
    }
}

