/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.binding;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingBase;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.util.ALog;
import java.util.Iterator;

public class BindingUtils {
    public static Triple substituteIntoTriple(Triple t, Binding binding) {
        Node subject = BindingUtils.substituteNode(t.getSubject(), binding);
        Node predicate = BindingUtils.substituteNode(t.getPredicate(), binding);
        Node object = BindingUtils.substituteNode(t.getObject(), binding);
        if (subject == t.getSubject() && predicate == t.getPredicate() && object == t.getObject()) {
            return t;
        }
        return new Triple(subject, predicate, object);
    }

    public static Node substituteNode(Node n, Binding binding) {
        if (!n.isVariable()) {
            return n;
        }
        if (!(n instanceof Var)) {
            ALog.fatal(BindingUtils.class, "Node_Variable, not a Var");
        }
        Var var = Var.alloc(n);
        Node obj = null;
        if (binding != null) {
            obj = binding.get(var);
        }
        if (obj == null) {
            return n;
        }
        if (obj instanceof Node) {
            return obj;
        }
        ALog.warn(BindingUtils.class, "Unknown object in binding: ignored: " + obj.getClass().getName());
        return n;
    }

    public static Binding asBinding(QuerySolution qSolution) {
        BindingMap binding = new BindingMap(null);
        BindingUtils.addToBinding(binding, qSolution);
        return binding;
    }

    public static void addToBinding(Binding binding, QuerySolution qSolution) {
        Iterator iter = qSolution.varNames();
        while (iter.hasNext()) {
            String n = (String)iter.next();
            RDFNode x = qSolution.get(n);
            binding.add(Var.alloc(n), x.asNode());
        }
    }

    public static boolean equals(Binding b1, Binding b2) {
        return BindingBase.equals(b1, b2);
    }
}

