/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.cortex;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;

public class PathClassLoader
extends URLClassLoader {
    public PathClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public PathClassLoader(URL[] urls) {
        super(urls);
    }

    public void addPath(String path) {
        this.addURL(PathClassLoader.getUrlOf(path));
    }

    public static URL getUrlOf(String path) {
        URL url = null;
        try {
            File file = new File(path);
            if (file.exists()) {
                path = file.toURL().toExternalForm();
            }
        }
        catch (Exception file) {
            // empty catch block
        }
        String encoded_url = path.replaceAll(" ", "%20");
        encoded_url = encoded_url.replace('\\', '/');
        try {
            URI uri = encoded_url.toLowerCase().endsWith(".jar") ? new URI("jar:" + encoded_url + "!/") : new URI(encoded_url);
            url = uri.toURL();
        }
        catch (Exception e1) {
            throw new UnsupportedOperationException("Cannot build URL " + encoded_url, e1);
        }
        return url;
    }

    public static void main(String[] args) {
        try {
            System.out.println("First attempt...");
            Class.forName("org.apache.maven.project.MavenProject");
        }
        catch (Exception ex) {
            System.out.println("Failed.");
        }
        try {
            URL[] urls = new URL[]{};
            PathClassLoader cl = new PathClassLoader(urls);
            cl.addPath("/home/pidancier/.m2/repository/org/apache/maven/maven-project/2.0/maven-project-2.0.jar");
            System.out.println("Second attempt...");
            cl.loadClass("org.apache.maven.project.MavenProject");
            System.out.println("Success!");
        }
        catch (Exception ex) {
            System.out.println("Failed.");
            ex.printStackTrace();
        }
    }
}

