xquery version "1.0";

(: The script caller have to setup the function pattern to be search :)
declare variable $func_pattern as xs:string? external;


(: The finding will be strict if the user specify a namespace :)
let $strictMatches := fn:matches($func_pattern, ".*:.*")
      
let $result_func_list :=
      if ($strictMatches)
      then
         QueryFunctions/QueryFunction[fn:matches(fn:substring-before(fn:data(signature[1]),'('), $func_pattern)]
      else
         QueryFunctions/QueryFunction[fn:matches(fn:substring-before(fn:data(signature[1]),'('), fn:concat('.*:.*', $func_pattern, '.*'))]
         
return

for $fnt in $result_func_list
   return
      fn:concat(fn:string-join(fn:data($fnt/signature), xs:string('\n')),
             '\n      ',
             fn:data($fnt/doc),
             if (fn:count($fnt/conformance) != 0) then fn:concat('\n      [Conformance] ',
             fn:data($fnt/conformance)) else '',
             if (fn:count($fnt/specificity) != 0) then fn:concat('\n      [!] ',
             fn:data($fnt/specificity)) else '',
             if (fn:count($fnt/deprecated) != 0) then fn:concat('\n      [DEPRECATED] ',
             fn:data($fnt/deprecated)) else '',
             if ($fnt/@supported = 'false') then xs:string('\n      [NOT SUPPORTED] This function is not supported!') else '',
             if (fn:count($fnt/example) != 0) then fn:concat('\n\n[Example]\n',
             fn:data($fnt/example[1])) else '')
