/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drbx.cortex;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import fr.gael.drb.DrbItem;
import fr.gael.drbx.cortex.DrbCortexItemSignature;
import fr.gael.drbx.cortex.DrbCortexModel;
import java.io.IOException;
import java.util.Collection;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrbCortexItemClass {
    private static Logger logger = Logger.getLogger(DrbCortexItemClass.class);
    private DrbCortexModel model = null;
    private OntClass ontClass = null;
    private Collection<DrbCortexItemClass> subClasses = new Vector<DrbCortexItemClass>();
    private DrbCortexItemSignature signature = null;
    private String schemaLocation = null;

    protected DrbCortexItemClass(OntClass ont_class) {
        if (ont_class == null) {
            throw new NullPointerException("Specified reference to Ontology class is null.");
        }
        this.setOntClass(ont_class);
    }

    protected DrbCortexItemClass(DrbCortexModel model, OntClass ont_class) {
        this(ont_class);
        this.setModel(model);
    }

    public static DrbCortexItemClass getCortexItemClassByName(String name) {
        DrbCortexItemClass cl = null;
        try {
            DrbCortexModel model = DrbCortexModel.getDefaultModel();
            cl = new DrbCortexItemClass(model.getCortexModel().getOntModel().getOntClass(name));
            cl.setModel(model);
        }
        catch (IOException e) {
            logger.error("Cannot create instance of \"" + name + "\" class.", e);
        }
        return cl;
    }

    public DrbCortexModel getModel() {
        return this.model;
    }

    public void setModel(DrbCortexModel model) {
        this.model = model;
    }

    public String getLabel() {
        String label = this.getOntClass().getLabel(null);
        if (label != null) {
            return label.trim();
        }
        return null;
    }

    public String getComment() {
        String comment = this.getOntClass().getComment(null);
        if (comment != null) {
            return comment.trim();
        }
        return null;
    }

    public OntClass getOntClass() {
        return this.ontClass;
    }

    private void setOntClass(OntClass ont_class) {
        if (ont_class != this.ontClass) {
            this.ontClass = ont_class;
            this.setSubClasses(null);
            this.setSignature(null);
        }
    }

    protected Collection<DrbCortexItemClass> getSubClasses() {
        if (this.subClasses == null) {
            if (this.getOntClass() == null) {
                throw new NullPointerException("Cannot retreive subclasses from a null class ontology.");
            }
            Vector<DrbCortexItemClass> new_classes = new Vector<DrbCortexItemClass>();
            ExtendedIterator sub_classes = this.getOntClass().listSubClasses(true);
            while (sub_classes.hasNext()) {
                OntClass sub_class = (OntClass)sub_classes.next();
                new_classes.add(new DrbCortexItemClass(this.getModel(), sub_class));
            }
            this.setSubClasses(new_classes);
        }
        return this.subClasses;
    }

    private void setSubClasses(Collection<DrbCortexItemClass> subclasses) {
        this.subClasses = subclasses;
    }

    public boolean includes(DrbItem item) {
        return this.includes(item, false);
    }

    public boolean includes(DrbItem item, boolean direct) {
        DrbCortexItemClass cl = this.getModel().getClassOf(item);
        if (cl == null) {
            cl = DrbCortexItemClass.getCortexItemClassByName(DrbCortexModel.getUriPrefix() + "item");
        }
        if (direct) {
            return this.equals(cl);
        }
        return this.isSubClassOf(cl);
    }

    public boolean isSubClassOf(DrbCortexItemClass cl) {
        if (cl == null) {
            return false;
        }
        if (this.equals(cl)) {
            return true;
        }
        ExtendedIterator iterator = cl.getOntClass().listSuperClasses();
        while (iterator.hasNext()) {
            DrbCortexItemClass superclass = new DrbCortexItemClass((OntClass)iterator.next());
            if (!this.isSubClassOf(superclass)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj.getClass().isAssignableFrom(DrbCortexItemClass.class)) {
            DrbCortexItemClass other = (DrbCortexItemClass)obj;
            return this.getOntClass().equals(other.getOntClass());
        }
        return false;
    }

    public int hashCode() {
        if (this.model == null || this.ontClass == null) {
            return super.hashCode();
        }
        return this.model.hashCode() + this.ontClass.hashCode();
    }

    public DrbCortexItemClass getClassOf(DrbItem item) {
        DrbCortexItemClass current_best_fitting_class = null;
        if (logger.isDebugEnabled()) {
            logger.debug("[CTX CLASS SEARCH] Searching class of item \"" + item.getName() + "\" from class \"" + this.getLabel() + "\"...");
        }
        if (this.getSignature().matches(item)) {
            current_best_fitting_class = this;
            if (logger.isDebugEnabled()) {
                logger.debug("   [CTX OK] Class \"" + this.getLabel() + "\" includes item \"" + item.getName() + "\".");
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("   [CTX NOK] Class \"" + this.getLabel() + "\" does not include item \"" + item.getName() + "\" (search aborted).");
            }
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Searching class of item \"" + item.getName() + "\" from subclasses of \"" + this.getLabel() + "\"...");
        }
        for (DrbCortexItemClass subclass : this.getSubClasses()) {
            DrbCortexItemClass best_fitting_class = subclass.getClassOf(item);
            if (best_fitting_class == null) continue;
            return best_fitting_class;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Class \"" + this.getLabel() + "\" includes \"" + item.getName() + "\".");
        }
        return current_best_fitting_class;
    }

    private String getPropertyString(OntClass ont_class, String property_uri) throws NullPointerException {
        Statement statement;
        Property property = ont_class.getOntModel().getProperty(property_uri);
        if (property != null && (statement = ont_class.getProperty(property)) != null) {
            return statement.getString().trim();
        }
        return null;
    }

    private String getPropertyString(OntClass ont_class, String property_uri, boolean monotonic) throws NullPointerException, RuntimeException {
        String property = this.getPropertyString(ont_class, property_uri);
        if (property == null && !monotonic) {
            ExtendedIterator super_class_iterator = ont_class.listSuperClasses(true);
            while (super_class_iterator.hasNext()) {
                String new_property = this.getPropertyString((OntClass)super_class_iterator.next(), property_uri, monotonic);
                if (new_property != null && property != null && !new_property.equals(property)) {
                    throw new RuntimeException("Ontology Class \"" + this.getLabel() + "\" inherit two different values (\"" + property + "\", \"" + new_property + "\") from its direct super classes.");
                }
                if (property != null) continue;
                property = new_property;
            }
        }
        return property;
    }

    public String getPropertyString(String property_uri) throws NullPointerException {
        if (this.getOntClass() == null) {
            throw new NullPointerException("Cannot get property string from a class that does not refer to an Ontology");
        }
        return this.getPropertyString(this.getOntClass(), property_uri);
    }

    public String getPropertyString(String property_uri, boolean monotonic) throws NullPointerException {
        return this.getPropertyString(this.getOntClass(), property_uri, monotonic);
    }

    private Vector<String> listPropertyStrings(OntClass ont_class, String property_uri) throws NullPointerException {
        StmtIterator statements;
        Property property = ont_class.getOntModel().getProperty(property_uri);
        if (property != null && (statements = ont_class.listProperties(property)) != null) {
            Vector<String> properties = null;
            while (statements.hasNext()) {
                Statement statement = statements.nextStatement();
                if (statement == null) continue;
                if (properties == null) {
                    properties = new Vector<String>();
                }
                properties.add(statement.getString().trim());
            }
            return properties;
        }
        return null;
    }

    private Vector<String> listPropertyStrings(OntClass ont_class, String property_uri, boolean monotonic) throws NullPointerException, RuntimeException {
        Vector<String> properties = this.listPropertyStrings(ont_class, property_uri);
        if (!monotonic) {
            ExtendedIterator super_class_iterator = ont_class.listSuperClasses(true);
            while (super_class_iterator.hasNext()) {
                Vector<String> new_properties = this.listPropertyStrings((OntClass)super_class_iterator.next(), property_uri, monotonic);
                if (new_properties == null) continue;
                if (properties == null) {
                    properties = new_properties;
                    continue;
                }
                properties.addAll(new_properties);
            }
        }
        return properties;
    }

    public Collection<String> listPropertyStrings(String property_uri) throws NullPointerException {
        if (this.getOntClass() == null) {
            throw new NullPointerException("Cannot get property string from a class that does not refer to an Ontology");
        }
        return this.listPropertyStrings(this.getOntClass(), property_uri);
    }

    public Vector<String> listPropertyStrings(String property_uri, boolean monotonic) throws NullPointerException {
        return this.listPropertyStrings(this.getOntClass(), property_uri, monotonic);
    }

    private DrbCortexItemSignature getSignature() throws NullPointerException {
        if (this.signature == null) {
            this.signature = new DrbCortexItemSignature(this);
        }
        return this.signature;
    }

    private void setSignature(DrbCortexItemSignature signature) {
        this.signature = signature;
    }

    public String getSchemaLocation() throws NullPointerException {
        if (this.schemaLocation != null) {
            return this.schemaLocation;
        }
        String schema_location = this.getPropertyString(DrbCortexModel.getUriPrefix() + "schemaLocation", false);
        if (schema_location != null) {
            if (this.getModel() != null) {
                String resolved_schema_location = this.getModel().resolveResourceUri(schema_location);
                if (resolved_schema_location != null) {
                    schema_location = resolved_schema_location;
                } else {
                    logger.warn("Class \"" + this.getLabel() + "\" resource location \"" + schema_location + "\" could not be resolved.");
                }
            } else {
                logger.warn("Class \"" + this.getLabel() + "\" not attached to a model: resource location \"" + schema_location + "\" may not be completely resolved.");
            }
            this.schemaLocation = schema_location;
        }
        return this.schemaLocation;
    }
}

