/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.sds;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;

final class KeyTreeMap {
    private static Logger logger = Logger.getLogger(KeyTreeMap.class);
    private int depth;
    private int size;
    private Map children;
    private Object value;
    private int[] lastKey;
    private Object lastValue;

    protected KeyTreeMap() {
        this(-1);
    }

    protected KeyTreeMap(int depth) {
        this.depth = depth;
        this.size = 0;
        this.children = new TreeMap();
    }

    protected final void add(int[] key, Object value) {
        if (this.depth < 0) {
            this.depth = key == null ? 0 : key.length;
        }
        if (this.depth == 0) {
            this.value = value;
            return;
        }
        if (key == null || key.length < this.depth) {
            logger.error("KeyTreeMap.add() ERROR: The given key is not consistent with the depth of the tree.");
            return;
        }
        Map curLevelMap = this.children;
        for (int i = 0; i < this.depth - 1; ++i) {
            TreeMap tmpLevelMap = (TreeMap)curLevelMap.get(new Integer(key[i]));
            if (tmpLevelMap == null) {
                tmpLevelMap = new TreeMap();
                curLevelMap.put(new Integer(key[i]), tmpLevelMap);
            }
            curLevelMap = tmpLevelMap;
        }
        if (curLevelMap.put(new Integer(key[this.depth - 1]), value) == null) {
            ++this.size;
        }
        this.lastKey = new int[key.length];
        this.lastValue = value;
        System.arraycopy(key, 0, this.lastKey, 0, key.length);
    }

    protected final Object get() {
        return this.value;
    }

    protected final void add(Object value) {
        this.value = value;
    }

    protected final Object get(int[] key) {
        if (this.depth <= 0 || key == null) {
            return this.value;
        }
        if (this.lastKey != null && Arrays.equals(this.lastKey, key)) {
            return this.lastValue;
        }
        Map curLevelMap = this.children;
        for (int i = 0; i < this.depth - 1; ++i) {
            Map tmpLevelMap = (Map)curLevelMap.get(new Integer(key[i]));
            if (tmpLevelMap == null) {
                return null;
            }
            curLevelMap = tmpLevelMap;
        }
        Object value = curLevelMap.get(new Integer(key[this.depth - 1]));
        return value;
    }

    protected final Set getSiblingKeys(int[] key) {
        if (key == null || this.depth <= 0) {
            return new TreeSet();
        }
        Map curLevelMap = this.children;
        for (int i = 0; i < this.depth - 1; ++i) {
            Map tmpLevelMap = (Map)curLevelMap.get(new Integer(key[i]));
            if (tmpLevelMap == null) {
                return new TreeSet();
            }
            curLevelMap = tmpLevelMap;
        }
        return curLevelMap.keySet();
    }

    protected final int getSize() {
        if (this.depth == 0 && this.value != null) {
            return 1;
        }
        return this.size;
    }

    protected final void clear() {
        this.children.clear();
        this.lastKey = null;
        this.lastValue = null;
        this.value = null;
        this.size = 0;
    }

    public String toString() {
        String tmpStr = "{depth=" + this.depth + ", size=" + this.getSize() + ", ";
        tmpStr = this.depth == 0 ? tmpStr + this.value : tmpStr + this.children;
        return tmpStr + "}";
    }

    protected final KeyTreeMapIterator iterator() {
        return new KeyTreeMapIterator();
    }

    public static void main(String[] args) {
        System.out.println("\nTest part 1");
        KeyTreeMap ktree = new KeyTreeMap();
        ktree.add(new int[]{0, 2, 0, 0}, new Long(66L));
        ktree.add(new int[]{0, 2, 0, 1}, new Long(177L));
        ktree.add(new int[]{1, 0, 0, 0}, new Long(321L));
        ktree.add(new int[]{1, 0, 0, 1}, new Long(457L));
        ktree.add(new int[]{0, 1, 0, 1}, new Long(44L));
        ktree.add(new int[]{0, 2, 0, 4}, new Long(205L));
        ktree.add(new int[]{0, 2, 0, 1}, new Long(186L));
        System.out.println(ktree.get(new int[]{1, 0, 0, 0}));
        System.out.println(ktree.get(new int[]{0, 2, 0, 2}));
        System.out.println(ktree.get(new int[]{0, 2, 0, 1}));
        System.out.println("toString() = " + ktree);
        ktree.clear();
        System.out.println("after clear() = " + ktree);
        System.out.println("\nTest part 2");
        ktree = new KeyTreeMap();
        System.out.println("toString() = " + ktree);
        for (int i = 0; i < 3; ++i) {
            if (i == 1) {
                ktree.add(new int[]{i, 0, 0}, new Long(100 * i));
                continue;
            }
            for (int j = 0; j < 5; ++j) {
                if (j < 2) {
                    ktree.add(new int[]{i, j, 0}, new Long(100 * i + 10 * j));
                    continue;
                }
                for (int k = 0; k < 3; ++k) {
                    ktree.add(new int[]{i, j, k}, new Long(100 * i + 10 * j + k));
                }
            }
        }
        System.out.println("toString() = " + ktree);
        KeyTreeMapIterator iterator = ktree.iterator();
        System.out.println("iterator = " + iterator);
        int i = 1;
        while (iterator.hasNext()) {
            System.out.print(iterator.next() + " ");
            if (i % 2 == 0) {
                iterator.remove();
            }
            ++i;
        }
        System.out.println();
        System.out.println("toString() = " + ktree);
        iterator = ktree.iterator();
        System.out.println("iterator = " + iterator);
        while (iterator.hasNext()) {
            System.out.print(iterator.next() + " ");
        }
        System.out.println();
    }

    final class KeyTreeMapIterator
    implements Iterator {
        Map[] map;
        Iterator[] iterator;
        Iterator subIterator;
        int level = -1;

        protected KeyTreeMapIterator() {
            if (KeyTreeMap.this.depth > 0) {
                this.level = 0;
                this.map = new Map[KeyTreeMap.this.depth];
                this.map[0] = KeyTreeMap.this.children;
                this.iterator = new Iterator[KeyTreeMap.this.depth];
                this.iterator[0] = this.map[0].values().iterator();
                this.subIterator = this.nextSubIterator();
            }
        }

        private final Iterator nextSubIterator() {
            while (this.level >= 0) {
                if (this.iterator[this.level].hasNext()) {
                    if (this.level < KeyTreeMap.this.depth - 1) {
                        this.map[this.level + 1] = (Map)this.iterator[this.level].next();
                        this.iterator[this.level + 1] = this.map[this.level + 1].values().iterator();
                        ++this.level;
                        continue;
                    }
                    return this.iterator[this.level];
                }
                --this.level;
            }
            return null;
        }

        @Override
        public final boolean hasNext() {
            if (this.level < 0) {
                return KeyTreeMap.this.value != null;
            }
            if (this.subIterator.hasNext()) {
                return true;
            }
            this.subIterator = this.nextSubIterator();
            return this.subIterator != null && this.subIterator.hasNext();
        }

        public final Object next() {
            if (this.subIterator == null) {
                if (KeyTreeMap.this.value == null) {
                    throw new NoSuchElementException();
                }
                return KeyTreeMap.this.value;
            }
            if (!this.subIterator.hasNext()) {
                this.subIterator = this.nextSubIterator();
            }
            return this.subIterator.next();
        }

        @Override
        public final void remove() {
            if (this.subIterator == null) {
                KeyTreeMap.this.value = null;
                KeyTreeMap.this.size = 0;
                return;
            }
            this.subIterator.remove();
            KeyTreeMap.this.size--;
            int tmpLevel = this.level;
            while (tmpLevel >= 0 && this.map[tmpLevel].size() == 0) {
                this.iterator[--tmpLevel].remove();
            }
        }
    }
}

