/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.query;

import fr.gael.drb.DrbSequence;
import fr.gael.drb.query.AbstractExpression;
import fr.gael.drb.query.DynamicContext;
import fr.gael.drb.query.DynamicException;
import fr.gael.drb.query.Expression;
import fr.gael.drb.query.Query;
import fr.gael.drb.query.Token;
import org.apache.log4j.Logger;

class IfExpression
extends AbstractExpression {
    Logger logger = Logger.getLogger(IfExpression.class);
    private Expression testExpression = null;
    private Expression thenExpression = null;
    private Expression elseExpression = null;

    public IfExpression(Token token) {
        super("If", token);
    }

    public void setTestExpression(Expression test_expression) {
        this.testExpression = test_expression;
    }

    public void setThenExpression(Expression then_expression) {
        this.thenExpression = then_expression;
    }

    public void setElseExpression(Expression else_expression) {
        this.elseExpression = else_expression;
    }

    public String toString() {
        return "if ( " + this.testExpression + " ) then " + this.thenExpression + " else " + this.elseExpression;
    }

    @Override
    public DrbSequence evaluate(DynamicContext context) {
        if (this.testExpression == null || this.thenExpression == null || this.elseExpression == null) {
            throw new DynamicException(this, "Incomplete \"if\" declaration");
        }
        DrbSequence testSequence = this.testExpression.evaluate(context);
        if (testSequence == null) {
            throw new DynamicException(this, "Error while evaluating the test expression");
        }
        if (this.isCancellationRequested()) {
            this.throwCancelException();
        }
        DrbSequence output_sequence = Query.getEffectiveBooleanValue(testSequence) ? this.thenExpression.evaluate(context) : this.elseExpression.evaluate(context);
        return output_sequence;
    }

    @Override
    public boolean isConstant() {
        return this.testExpression.isConstant() && this.elseExpression.isConstant() && this.thenExpression.isConstant();
    }

    @Override
    public boolean isUpdating() {
        double key = Math.random();
        this.logger.debug("If.isUpdating() : Start " + key);
        this.logger.debug("If.isUpdating() :  " + this.toString());
        boolean bool = this.testExpression.isUpdating() || this.elseExpression.isUpdating() || this.thenExpression.isUpdating();
        this.logger.debug("If.isUpdating() : Stop " + key);
        return bool;
    }
}

