/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.query;

import fr.gael.drb.DrbSequence;
import fr.gael.drb.query.AbstractExpression;
import fr.gael.drb.query.DynamicContext;
import fr.gael.drb.query.DynamicException;
import fr.gael.drb.query.Expression;
import fr.gael.drb.query.LiteralExpression;
import fr.gael.drb.query.RangeResult;
import fr.gael.drb.query.Token;
import fr.gael.drb.query.TypeException;
import fr.gael.drb.value.Integer;
import fr.gael.drb.value.Numeric;
import fr.gael.drb.value.Value;
import fr.gael.drb.value.ValueArray;
import org.apache.log4j.Logger;

class RangeExpression
extends AbstractExpression {
    private static Logger logger = Logger.getLogger(RangeExpression.class);
    private Expression minimum;
    private boolean constantMinimum = false;
    private long minimumValue;
    private Expression maximum;
    private boolean constantMaximum = false;
    private long maximumValue;

    public RangeExpression(Token token, Expression minimum, Expression maximum) {
        super("Range", token);
        this.minimum = minimum;
        if (minimum instanceof LiteralExpression) {
            try {
                Value minimumValue = ((LiteralExpression)minimum).getValue().convertTo(9);
                this.minimumValue = ((Numeric)minimumValue).longValue();
                this.constantMinimum = true;
            }
            catch (ClassCastException e) {
                logger.warn("Cannot extract range minimum value from literal \"" + minimum + "\": skipped.");
            }
        }
        this.maximum = maximum;
        if (maximum instanceof LiteralExpression) {
            Value maximum_value = ((LiteralExpression)maximum).getValue();
            try {
                maximum_value = maximum_value.convertTo(27);
                this.maximumValue = ((Integer)maximum_value).intValue();
                this.constantMaximum = true;
            }
            catch (ClassCastException e) {
                logger.warn("Cannot extract range maximum value from literal \"" + maximum + "\": skipped.");
            }
        }
    }

    @Override
    public boolean isConstant() {
        return this.minimum.isConstant() && this.maximum.isConstant();
    }

    public boolean isMinimumConstant() {
        return this.constantMinimum;
    }

    public long getMinimumValue() {
        return this.minimumValue;
    }

    public boolean isMaximumConstant() {
        return this.constantMaximum;
    }

    public long getMaximumValue() {
        return this.maximumValue;
    }

    public Long getMinimumValue(DynamicContext context) {
        DrbSequence minSequence = this.minimum.evaluate(context);
        if (minSequence == null) {
            throw new DynamicException(this, "Error while evaluating the minimim expression of the range");
        }
        ValueArray minArray = minSequence.atomize();
        if (minArray.length() == 0) {
            return Long.MAX_VALUE;
        }
        if (minArray.length() != 1) {
            throw new DynamicException(this, "The minimum of the range shall match a single xs:integer");
        }
        try {
            Numeric minValue = (Numeric)minArray.getElement(0).convertTo(9);
            return minValue.longValue();
        }
        catch (ClassCastException e) {
            throw new TypeException(this, "The minimum of the range has not an xs:integer type");
        }
    }

    public Long getMaximumValue(DynamicContext context) {
        DrbSequence maxSequence = this.maximum.evaluate(context);
        if (maxSequence == null) {
            throw new DynamicException(this, "Error while evaluating the maximum expression of the range");
        }
        ValueArray maxArray = maxSequence.atomize();
        if (maxArray.length() == 0) {
            return Long.MIN_VALUE;
        }
        if (maxArray.length() > 1) {
            throw new DynamicException(this, "The maximum of the range shall match a single xs:integer");
        }
        try {
            Numeric maxValue = (Numeric)maxArray.getElement(0).convertTo(9);
            return maxValue.longValue();
        }
        catch (ClassCastException e) {
            throw new TypeException(this, "The maximum of the range has not an xs:integer type");
        }
    }

    public String toString() {
        return this.minimum + " to " + this.maximum;
    }

    @Override
    public DrbSequence evaluate(DynamicContext context) {
        this.minimumValue = this.getMinimumValue(context);
        this.maximumValue = this.getMaximumValue(context);
        return new RangeResult(this.minimumValue, this.maximumValue);
    }
}

