/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.query;

import fr.gael.drb.query.QueryParserConstants;
import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;
import javax.swing.text.Style;

public class TokenElement
implements Serializable {
    public static final Object TOKEN_ATTRIBUTE = new AttributeKey();
    String representation;
    int scanValue;
    Color color = Color.black;
    Font font = new Font("Monospaced", 0, 14);
    Style style = null;

    TokenElement(String representation, int scan_value) {
        this.representation = representation;
        this.scanValue = scan_value;
    }

    TokenElement(String representation, Color color) {
        this.representation = representation;
        if (color != null) {
            this.color = color;
        }
        this.scanValue = TokenElement.getScanValueForRepresentation(representation);
    }

    TokenElement(String representation, Font font, Color color) {
        this.representation = representation;
        if (font != null) {
            this.font = font;
        }
        if (color != null) {
            this.color = color;
        }
        this.scanValue = TokenElement.getScanValueForRepresentation(representation);
    }

    TokenElement(String representation, int scan_value, Font font, Color color) {
        this.representation = representation;
        this.scanValue = scan_value;
        if (font != null) {
            this.font = font;
        }
        if (color != null) {
            this.color = color;
        }
    }

    private static int getScanValueForRepresentation(String name) {
        if (name == null) {
            return -1;
        }
        String[] images = QueryParserConstants.tokenImage;
        if (images == null) {
            return -1;
        }
        for (int i_image = 0; i_image < images.length; ++i_image) {
            String current = images[i_image];
            if (current == null || !current.equals(name)) continue;
            return i_image;
        }
        return -1;
    }

    public String toString() {
        return this.representation;
    }

    public int getScanValue() {
        return this.scanValue;
    }

    public Color getColor() {
        return this.color;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font new_font) {
        this.font = new_font;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public Style getStyle() {
        return this.style;
    }

    public String getCategory() {
        String nm = this.getClass().getName();
        int nmStart = nm.lastIndexOf(46) + 1;
        return nm.substring(nmStart, nm.length());
    }

    public final int hashCode() {
        return this.scanValue;
    }

    public final boolean equals(Object obj) {
        if (obj instanceof TokenElement) {
            TokenElement t = (TokenElement)obj;
            return this.scanValue == t.scanValue;
        }
        return false;
    }

    static class AttributeKey {
        private AttributeKey() {
        }

        public String toString() {
            return "token_element";
        }
    }
}

