/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.value;

import fr.gael.drb.value.AbstractNumeric;
import fr.gael.drb.value.Integer;
import fr.gael.drb.value.Numeric;
import fr.gael.drb.value.Value;
import java.math.BigDecimal;
import java.math.BigInteger;

public class Decimal
extends AbstractNumeric {
    public static final int PRIORITY = 8;
    protected BigDecimal value;

    public Decimal(String val) {
        this.value = new BigDecimal(val);
    }

    public Decimal(double val) {
        this.value = new BigDecimal(val);
    }

    protected Decimal(BigDecimal val) {
        this.value = val;
    }

    public String toString() {
        return this.value.toPlainString();
    }

    @Override
    public int getType() {
        return 26;
    }

    @Override
    public final int getPriority() {
        return 8;
    }

    @Override
    public Value convertTo(int type) throws ClassCastException {
        switch (type) {
            case 26: {
                return this;
            }
            case 27: {
                return new Integer(this.value.toBigInteger());
            }
        }
        return super.convertTo(type);
    }

    @Override
    public void assign(Value v) {
        this.value = new BigDecimal(v.toString());
    }

    @Override
    public Value unaryMinus() {
        return new Decimal(this.value.negate());
    }

    @Override
    public final Value add(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).add(x);
        }
        Decimal num = (Decimal)x.convertTo(26);
        return new Decimal(this.value.add(num.value));
    }

    @Override
    public Value sub(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).sub(x);
        }
        Decimal num = (Decimal)x.convertTo(26);
        return new Decimal(this.value.subtract(num.value));
    }

    @Override
    public Value multiply(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).multiply(x);
        }
        Decimal num = (Decimal)x.convertTo(26);
        return new Decimal(this.value.multiply(num.value));
    }

    @Override
    public final Value divide(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).divide(x);
        }
        Decimal num = (Decimal)x.convertTo(26);
        return new Decimal(this.value.divide(num.value, 0));
    }

    @Override
    public Value modulus(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).modulus(x);
        }
        throw new UnsupportedOperationException("Decimal: modulus is not implemented");
    }

    @Override
    public int compareTo(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).compareTo(x);
        }
        Decimal num = (Decimal)x.convertTo(26);
        return this.value.compareTo(num.value);
    }

    @Override
    public final boolean booleanValue() {
        return this.value.signum() != 0;
    }

    @Override
    public final byte byteValue() {
        return this.value.byteValue();
    }

    @Override
    public final short shortValue() {
        return this.value.shortValue();
    }

    @Override
    public final int intValue() {
        return this.value.intValue();
    }

    @Override
    public final long longValue() {
        return this.value.longValue();
    }

    @Override
    public final float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public final double doubleValue() {
        return this.value.doubleValue();
    }

    @Override
    protected final BigInteger integerValue() {
        return this.value.toBigInteger();
    }

    @Override
    protected final BigDecimal decimalValue() {
        return this.value;
    }

    @Override
    public final void assign(boolean value) {
        this.value = new BigDecimal(value ? 1.0 : 0.0);
    }

    @Override
    public final void assign(byte value) {
        this.value = new BigDecimal((double)value);
    }

    @Override
    public final void assign(short value) {
        this.value = new BigDecimal((double)value);
    }

    @Override
    public final void assign(int value) {
        this.value = new BigDecimal((double)value);
    }

    @Override
    public final void assign(long value) {
        this.value = new BigDecimal(Long.toString(value));
    }

    @Override
    public final void assign(float value) {
        this.value = new BigDecimal(value);
    }

    @Override
    public final void assign(double value) {
        this.value = new BigDecimal(value);
    }
}

