/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.value;

import fr.gael.drb.value.AbstractNumericArray;
import fr.gael.drb.value.Double;
import fr.gael.drb.value.Numeric;
import fr.gael.drb.value.NumericArray;
import fr.gael.drb.value.String;
import fr.gael.drb.value.Value;
import fr.gael.drb.value.ValueFormat;

public class DoubleArray
extends AbstractNumericArray
implements ValueFormat {
    static final int PRIORITY = 5;
    private double[] value;

    public DoubleArray(double[] v) {
        this.value = new double[v.length];
        System.arraycopy(v, 0, this.value, 0, v.length);
    }

    public DoubleArray(int size) {
        this.value = new double[size];
    }

    public final double[] getData() {
        return this.value;
    }

    public java.lang.String toString() {
        StringBuffer strbuf = new StringBuffer(this.value.length * 10);
        for (int i = 0; i < this.value.length; ++i) {
            if (i != 0) {
                strbuf.append(" ");
            }
            strbuf.append(this.value[i]);
        }
        return strbuf.toString();
    }

    @Override
    public java.lang.String getFormattedString(int length) {
        StringBuffer strbuf = new StringBuffer(this.value.length * length);
        for (int i = 0; i < this.length(); ++i) {
            strbuf.append(new Double(this.value[i]).getFormattedString(8));
        }
        return strbuf.toString();
    }

    @Override
    public final byte[] getFormattedBuffer() {
        byte[] buffer = new byte[8 * this.length()];
        for (int i = 0; i < this.length(); ++i) {
            long long_value = java.lang.Double.doubleToRawLongBits(this.value[i]);
            buffer[8 * i + 0] = (byte)(long_value >>> 56);
            buffer[8 * i + 1] = (byte)(long_value >>> 48);
            buffer[8 * i + 2] = (byte)(long_value >>> 40);
            buffer[8 * i + 3] = (byte)(long_value >>> 32);
            buffer[8 * i + 4] = (byte)(long_value >>> 24);
            buffer[8 * i + 5] = (byte)(long_value >>> 16);
            buffer[8 * i + 6] = (byte)(long_value >>> 8);
            buffer[8 * i + 7] = (byte)long_value;
        }
        return buffer;
    }

    @Override
    public final int getType() {
        return 10;
    }

    @Override
    public final int getPriority() {
        return 5;
    }

    @Override
    public final Value convertTo(int type) throws ClassCastException {
        if (type == 10) {
            return this;
        }
        if (type == 7) {
            return new String(this.toString());
        }
        throw new ClassCastException();
    }

    @Override
    public final void assign(Value v) throws ClassCastException {
        NumericArray b = (NumericArray)v;
        this.value = new double[b.length()];
        for (int i = 0; i < this.length(); ++i) {
            this.value[i] = b.doubleValue(i);
        }
    }

    @Override
    public final int getArrayType() {
        return 6;
    }

    @Override
    public final Value getElement(int index) {
        return new Double(this.value[index]);
    }

    @Override
    public final void assign(int index, Value element) {
        element = element.convertTo(9);
        this.value[index] = ((Numeric)element).doubleValue();
    }

    @Override
    public final int length() {
        return this.value.length;
    }

    @Override
    public final boolean booleanValue(int index) {
        return this.value[index] != 0.0;
    }

    @Override
    public final byte byteValue(int index) {
        return (byte)this.value[index];
    }

    @Override
    public final int intValue(int index) {
        return (int)this.value[index];
    }

    @Override
    public final long longValue(int index) {
        return (long)this.value[index];
    }

    @Override
    public final short shortValue(int index) {
        return (short)this.value[index];
    }

    @Override
    public final float floatValue(int index) {
        return (float)this.value[index];
    }

    @Override
    public final double doubleValue(int index) {
        return this.value[index];
    }

    @Override
    public final void assign(int index, boolean value) {
        this.value[index] = value ? 1 : 0;
    }

    @Override
    public final void assign(int index, byte value) {
        this.value[index] = value;
    }

    @Override
    public final void assign(int index, int value) {
        this.value[index] = value;
    }

    @Override
    public final void assign(int index, short value) {
        this.value[index] = value;
    }

    @Override
    public final void assign(int index, long value) {
        this.value[index] = value;
    }

    @Override
    public final void assign(int index, float value) {
        this.value[index] = value;
    }

    @Override
    public final void assign(int index, double value) {
        this.value[index] = value;
    }
}

