/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.xsd;

import fr.gael.drb.DrbDefaultAttribute;
import fr.gael.drb.DrbDefaultAttributeList;
import fr.gael.drb.DrbDefaultMutableNode;
import fr.gael.drb.DrbDefaultNodeList;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbNodeList;
import fr.gael.drb.value.Int;
import fr.gael.drb.value.String;
import fr.gael.drb.value.Value;
import fr.gael.drb.xsd.NodeValidator;
import fr.gael.drb.xsd.XmlSchema;
import fr.gael.drb.xsd.XsdInvalid;
import fr.gael.drb.xsd.XsdInvalidParticle;
import fr.gael.drb.xsd.XsdParticle;
import fr.gael.drb.xsd.XsdType;

public class XsdElement
extends XsdParticle
implements NodeValidator {
    static final java.lang.String TAG = "element";
    static final java.lang.String NAME_TAG = "name";
    static final java.lang.String REF_TAG = "ref";
    static final java.lang.String TYPE_TAG = "type";
    static final java.lang.String DEFAULT_TAG = "default";
    static final java.lang.String FIXED_TAG = "fixed";
    private java.lang.String name = null;
    private XsdType type = null;
    private int constraint = 0;
    private boolean abstractDecl = false;
    private XsdElement substitutionGroupAffiliation = null;
    private Value value = null;

    public XsdElement(int min_occurs, int max_occurs, java.lang.String name, XsdType type) {
        super(min_occurs, max_occurs);
        this.name = name;
        this.type = type;
    }

    XsdElement(java.lang.String name, XsdType type) {
        super(1, 1);
        this.name = name;
        this.type = type;
    }

    public final java.lang.String getName() {
        return this.name;
    }

    public final boolean isAbstract() {
        return this.abstractDecl;
    }

    void setAbstract(boolean abstract_decl) {
        this.abstractDecl = abstract_decl;
    }

    public final XsdType getType() {
        return this.type;
    }

    public final XsdElement getSubstitutionGroupAffiliation() {
        return this.substitutionGroupAffiliation;
    }

    void setSubstitutionGroupAffiliation(XsdElement substitution_affiliation) {
        this.substitutionGroupAffiliation = substitution_affiliation;
    }

    public final Value getValue() {
        return this.value;
    }

    public final int getConstraint() {
        return this.constraint;
    }

    final void setValueConstraint(Value value, int constraint) {
        this.value = value;
        this.constraint = constraint;
    }

    @Override
    DrbNode toNode() {
        DrbDefaultMutableNode eltNode = new DrbDefaultMutableNode(TAG);
        eltNode.setNamespaceURI("http://www.w3.org/2001/XMLSchema");
        DrbNode appNode = this.getAnnotation().toNode();
        if (appNode != null) {
            eltNode.appendChild(appNode);
        }
        DrbDefaultAttributeList attributes = new DrbDefaultAttributeList();
        attributes.add(new DrbDefaultAttribute(NAME_TAG, (Value)new String(this.getName()), eltNode));
        if (this.type == null) {
            attributes.add(new DrbDefaultAttribute(TYPE_TAG, (Value)new String("xs:anyType"), eltNode));
        } else {
            XmlSchema schema = this.type.schema;
            if (schema != null && this.type.getName() != null) {
                java.lang.String type_name = this.type.getName();
                if (schema != null) {
                    java.lang.String prefix = schema.namespaces.resolvePrefix(this.type.getTargetNamespace());
                    if (prefix == null && "http://www.w3.org/2001/XMLSchema".equals(this.type.getTargetNamespace())) {
                        prefix = "xs";
                    }
                    if (prefix != null) {
                        type_name = prefix + ":" + this.type.getName();
                    }
                } else {
                    type_name = this.type.getTargetNamespace() + ":" + this.type.getName();
                }
                attributes.add(new DrbDefaultAttribute(TYPE_TAG, (Value)new String(type_name), eltNode));
            } else {
                DrbNode typeNode = this.type.toNode();
                if (typeNode != null) {
                    eltNode.appendChild(typeNode);
                }
            }
        }
        if (this.getMinOccurs() != 1) {
            attributes.add(new DrbDefaultAttribute("minOccurs", (Value)new Int(this.getMinOccurs()), eltNode));
        }
        if (this.getMaxOccurs() == UNBOUNDED_OCCURS.intValue()) {
            attributes.add(new DrbDefaultAttribute("maxOccurs", (Value)new String("unbounded"), eltNode));
        } else if (this.getMaxOccurs() != 1) {
            attributes.add(new DrbDefaultAttribute("maxOccurs", (Value)new Int(this.getMaxOccurs()), eltNode));
        }
        eltNode.setAttributes(attributes);
        return eltNode;
    }

    @Override
    public final int getTerm() {
        return 2;
    }

    @Override
    public XsdInvalid isValid(DrbNode node) {
        DrbDefaultNodeList nodeList = new DrbDefaultNodeList();
        XsdInvalidParticle invalid = new XsdInvalidParticle(nodeList, this, 0, 0);
        if (node == null) {
            return this.getMinOccurs() == 0 ? null : invalid;
        }
        nodeList.add(node);
        if (this.getName() == null || !this.getName().equals(node.getName())) {
            return invalid;
        }
        XsdInvalid invalid_type = null;
        if (this.type != null && (invalid_type = this.type.isValid(node)) != null) {
            return invalid_type;
        }
        return null;
    }

    @Override
    public XsdInvalid isValid(DrbNodeList node_list) {
        XsdInvalidParticle invalid = new XsdInvalidParticle(node_list, this, 0, 0);
        if (node_list == null) {
            node_list = new DrbDefaultNodeList();
        }
        if (this.search(node_list, 0) == node_list.getLength()) {
            return null;
        }
        return invalid;
    }

    @Override
    public int search(DrbNodeList node_list, int start) {
        return this.search(node_list, start, new XsdInvalidParticle(node_list, this, start, start));
    }

    int search(DrbNodeList node_list, int start, XsdInvalidParticle invalid) {
        if (node_list == null) {
            node_list = new DrbDefaultNodeList();
        }
        if (start < 0) {
            return -1;
        }
        int occurs = 0;
        for (int i = start; i < node_list.getLength(); ++i) {
            DrbNode node = node_list.item(i);
            if (node == null) {
                return -1;
            }
            if (this.getName() == null || !this.getName().equals(node.getName()) || occurs == this.getMaxOccurs()) break;
            ++occurs;
        }
        invalid.setStopIndex(start + occurs);
        if (this.type != null && this.type.isComplex()) {
            if (occurs < this.getMinOccurs()) {
                return -1;
            }
            if (occurs > this.getMaxOccurs()) {
                return -1;
            }
        }
        return start + occurs;
    }
}

