/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.xsd;

import fr.gael.drb.value.Decimal;
import fr.gael.drb.value.Int;
import fr.gael.drb.value.Value;
import fr.gael.drb.xsd.XsdFacet;
import org.apache.log4j.Logger;

public class XsdTotalDigitsFacet
extends XsdFacet {
    private static Logger logger = Logger.getLogger(XsdTotalDigitsFacet.class);
    static final String TAG = "totalDigits";
    private int totalDigits;

    XsdTotalDigitsFacet(Value value) {
        this.totalDigits = ((Int)value.convertTo(3)).intValue();
    }

    @Override
    public final int getId() {
        return 11;
    }

    @Override
    public final Value getValue() {
        return new Int(this.totalDigits);
    }

    @Override
    public final String getName() {
        return TAG;
    }

    @Override
    public boolean isValid(Value v) {
        if (v == null) {
            return false;
        }
        try {
            switch (v.getType()) {
                case 5: {
                    logger.error("totalDigits facet is not allowed for xs:float datatype");
                    return false;
                }
                case 6: {
                    logger.error("totalDigits facet is not allowed for xs:double datatype");
                    return false;
                }
                case 10: {
                    logger.error("totalDigits facet is not allowed for list datatype");
                    return false;
                }
            }
            Decimal num = (Decimal)v.convertTo(26);
            String str = num.toString().trim();
            int canonical_len = str.length();
            if (str.contains(".")) {
                while (str.charAt(--canonical_len) == '0') {
                }
            }
            if (str.startsWith("-")) {
                --canonical_len;
            }
            return canonical_len <= this.totalDigits;
        }
        catch (ClassCastException e) {
            logger.warn("totalDigitsFacet: Cannot convert '" + v + "' to xs:decimal.");
            return false;
        }
    }
}

