/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.optimizer.probability;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.HistogramClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Histogram {
    private int nrOfClasses = 10;
    private double lowerBound = 0.0;
    private double upperBound = 0.0;
    private double classSize = 0.0;
    private List elementList = new ArrayList();
    private Map histogram = new TreeMap();
    private static Log log = LogFactory.getLog((Class)Histogram.class);

    public void addElements(List elements) {
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            Double element = this.toElement(node);
            if (element == null) continue;
            this.elementList.add(element);
        }
        Collections.sort(this.elementList);
        this.lowerBound = (Double)this.elementList.get(0);
        this.upperBound = (Double)this.elementList.get(this.elementList.size() - 1);
        this.classSize = (this.upperBound - this.lowerBound) / (double)this.nrOfClasses;
        log.debug((Object)("Number of elements: " + this.elementList.size()));
        log.debug((Object)("Histogram lower bound: " + this.lowerBound));
        log.debug((Object)("Histogram upper bound: " + this.upperBound));
        log.debug((Object)("Histogram class size: " + this.classSize));
        for (int i = 0; i < this.nrOfClasses; ++i) {
            double classLowerBound = this.lowerBound + (double)i * this.classSize;
            HistogramClass histogramClass = new HistogramClass();
            histogramClass.setLowerBound(classLowerBound);
            this.histogram.put(new Double(classLowerBound), histogramClass);
            log.debug((Object)("Create histogram class with lower bound: " + classLowerBound));
        }
        iter = this.elementList.iterator();
        while (iter.hasNext()) {
            Double element = (Double)iter.next();
            double classLowerBound = this.getLowerBound(element);
            HistogramClass histogramClass = (HistogramClass)this.histogram.get(new Double(classLowerBound));
            histogramClass.increment();
        }
    }

    public long getClassFrequency(Node node) {
        Double element = this.toElement(node);
        if (element >= this.lowerBound && element <= this.upperBound) {
            HistogramClass histogramClass = (HistogramClass)this.histogram.get(new Double(this.getLowerBound(element)));
            return histogramClass.getFrequency();
        }
        log.debug((Object)("The element is not contained in this histogram (return 0): " + element + " (" + this.lowerBound + ", " + this.upperBound + ")"));
        return 0L;
    }

    public Set getClasses() {
        HashSet<HistogramClass> histogramClasses = new HashSet<HistogramClass>();
        Iterator iter = this.histogram.values().iterator();
        while (iter.hasNext()) {
            histogramClasses.add((HistogramClass)iter.next());
        }
        return histogramClasses;
    }

    public void addClass(HistogramClass histogramClass) {
        this.histogram.put(new Double(histogramClass.getLowerBound()), histogramClass);
    }

    public void setLowerBound(double lowerBound) {
        this.lowerBound = lowerBound;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public void setUpperBound(double upperBound) {
        this.upperBound = upperBound;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public void setClassSize(double classSize) {
        this.classSize = classSize;
    }

    public double getClassSize() {
        return this.classSize;
    }

    public long size() {
        long size = 0L;
        Iterator iter = this.histogram.keySet().iterator();
        while (iter.hasNext()) {
            Double key = (Double)iter.next();
            HistogramClass histogramClass = (HistogramClass)this.histogram.get(key);
            size += histogramClass.getFrequency();
        }
        return size;
    }

    private double getLowerBound(double element) {
        int i = 0;
        double bound = this.lowerBound + (double)i * this.classSize;
        double nextBound = this.lowerBound + (double)(++i) * this.classSize;
        while (element > nextBound) {
            bound = nextBound;
            nextBound = this.lowerBound + (double)(++i) * this.classSize;
        }
        return bound;
    }

    private Double toElement(Node node) {
        if (node.isLiteral()) {
            return new Double(node.getLiteralLexicalForm().hashCode());
        }
        if (node.isURI()) {
            return new Double(node.getURI().hashCode());
        }
        if (node.isBlank()) {
            return new Double(node.getBlankNodeId().getLabelString().hashCode());
        }
        return null;
    }
}

