/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitor;
import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.op.Op0;
import com.hp.hpl.jena.sparql.algebra.op.Op1;
import com.hp.hpl.jena.sparql.algebra.op.Op2;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpDatasetNames;
import com.hp.hpl.jena.sparql.algebra.op.OpDiff;
import com.hp.hpl.jena.sparql.algebra.op.OpDistinct;
import com.hp.hpl.jena.sparql.algebra.op.OpExt;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpGroupAgg;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpList;
import com.hp.hpl.jena.sparql.algebra.op.OpNull;
import com.hp.hpl.jena.sparql.algebra.op.OpOrder;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpReduced;
import com.hp.hpl.jena.sparql.algebra.op.OpService;
import com.hp.hpl.jena.sparql.algebra.op.OpSlice;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.algebra.op.OpUnion;
import com.hp.hpl.jena.sparql.util.ALog;
import java.util.Stack;

public class Transformer {
    static boolean noDupIfSame = true;

    public static Op transform(Transform tranform, Op op) {
        if (op == null) {
            ALog.warn(Transformer.class, "Attempt to transform a null Op - ignored");
            return op;
        }
        TransformApply v = new TransformApply(tranform);
        op.visit(v);
        return v.result();
    }

    private Transformer() {
    }

    static class TransformApply
    implements OpVisitor {
        Transform transform = null;
        Stack stack = new Stack();

        private Op pop() {
            return (Op)this.stack.pop();
        }

        private void push(Op op) {
            this.stack.push(op);
        }

        public TransformApply(Transform transform) {
            this.transform = transform;
        }

        public Op result() {
            if (this.stack.size() != 1) {
                ALog.warn(this, "Stack is not aligned");
            }
            return this.pop();
        }

        private void visit0(Op0 op) {
            this.push(op.apply(this.transform));
        }

        private void visit1(Op1 op) {
            op.getSubOp().visit(this);
            Op subOp = this.pop();
            this.push(op.apply(this.transform, subOp));
        }

        private void visit2(Op2 op) {
            op.getLeft().visit(this);
            Op left = this.pop();
            op.getRight().visit(this);
            Op right = this.pop();
            Op opX = op.apply(this.transform, left, right);
            this.push(opX);
        }

        public void visit(OpTable opTable) {
            this.visit0(opTable);
        }

        public void visit(OpQuadPattern quadPattern) {
            this.visit0(quadPattern);
        }

        public void visit(OpDatasetNames dsNames) {
            this.visit0(dsNames);
        }

        public void visit(OpBGP op) {
            this.visit0(op);
        }

        public void visit(OpJoin opJoin) {
            this.visit2(opJoin);
        }

        public void visit(OpLeftJoin opLeftJoin) {
            this.visit2(opLeftJoin);
        }

        public void visit(OpDiff opDiff) {
            this.visit2(opDiff);
        }

        public void visit(OpUnion opUnion) {
            this.visit2(opUnion);
        }

        public void visit(OpFilter opFilter) {
            this.visit1(opFilter);
        }

        public void visit(OpGraph opGraph) {
            this.visit1(opGraph);
        }

        public void visit(OpService opService) {
            this.visit1(opService);
        }

        public void visit(OpExt opExt) {
            this.push(this.transform.transform(opExt));
        }

        public void visit(OpNull opNull) {
            this.visit0(opNull);
        }

        public void visit(OpList opList) {
            this.visit1(opList);
        }

        public void visit(OpOrder opOrder) {
            this.visit1(opOrder);
        }

        public void visit(OpProject opProject) {
            this.visit1(opProject);
        }

        public void visit(OpDistinct opDistinct) {
            this.visit1(opDistinct);
        }

        public void visit(OpReduced opReduced) {
            this.visit1(opReduced);
        }

        public void visit(OpSlice opSlice) {
            this.visit1(opSlice);
        }

        public void visit(OpGroupAgg opGroupAgg) {
            this.visit1(opGroupAgg);
        }
    }
}

