/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.ModelReader;
import com.hp.hpl.jena.rdf.model.ModelSpec;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.CannotCreateException;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.vocabulary.JenaModelSpec;

public abstract class ModelSpecImpl
implements ModelSpec {
    protected ModelMaker maker;
    public static final Model emptyModel = ModelFactory.createDefaultModel();
    protected Model defaultModel = null;
    public static final Resource emptyResource = emptyModel.createResource();
    protected Model description = emptyModel;
    protected Resource root = ResourceFactory.createResource("");

    public ModelSpecImpl(ModelMaker maker) {
        if (maker == null) {
            throw new RuntimeException("null maker not allowed");
        }
        this.maker = maker;
    }

    public final Model createFreshModel() {
        return this.loadFiles(this.doCreateModel());
    }

    protected abstract Model doCreateModel();

    public Model createDefaultModel() {
        if (this.defaultModel == null) {
            this.defaultModel = this.makeDefaultModel();
        }
        return this.defaultModel;
    }

    protected Model makeDefaultModel() {
        Statement s = this.root.getProperty(JenaModelSpec.modelName);
        return this.loadFiles(s == null ? this.maker.createDefaultModel() : this.maker.createModel(s.getString()));
    }

    public Model createModelOver(String name) {
        return this.loadFiles(this.implementCreateModelOver(name));
    }

    public abstract Model implementCreateModelOver(String var1);

    public Model openModel(String name) {
        return this.loadFiles(this.maker.openModel(name));
    }

    public Model openModel() {
        Statement s = this.root.getProperty(JenaModelSpec.modelName);
        return this.loadFiles(s == null ? this.maker.openModel() : this.maker.openModel(s.getString(), true));
    }

    public Model openModelIfPresent(String name) {
        return this.maker.hasModel(name) ? this.loadFiles(this.maker.openModel(name)) : null;
    }

    public ModelMaker getModelMaker() {
        return this.maker;
    }

    protected Model loadFiles(Model m) {
        StmtIterator it = this.description.listStatements(this.root, JenaModelSpec.loadWith, (RDFNode)null);
        while (it.hasNext()) {
            this.loadFile(m, it.nextStatement().getResource());
        }
        return m;
    }

    protected Model loadFile(Model m, Resource file) {
        FileManager.get().readModel(m, file.getURI());
        return m;
    }

    public Model getModel() {
        return this.createDefaultModel();
    }

    public Model createModel() {
        return this.createFreshModel();
    }

    public Model getModel(String URL2) {
        return null;
    }

    public Model getModel(String URL2, ModelReader loadIfAbsent) {
        throw new CannotCreateException(URL2);
    }
}

