/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys;

import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.BaseInfGraph;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.RDFSRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.RulePreprocessHook;
import com.hp.hpl.jena.reasoner.rulesys.Util;
import com.hp.hpl.jena.reasoner.rulesys.impl.RDFSCMPPreprocessHook;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class RDFSRuleReasoner
extends GenericRuleReasoner {
    public static final String DEFAULT_RULES = "default";
    public static final String FULL_RULES = "full";
    public static final String SIMPLE_RULES = "simple";
    protected static final String RULE_FILE = "etc/rdfs-fb-tgc-noresource.rules";
    protected static final String FULL_RULE_FILE = "etc/rdfs-fb-tgc.rules";
    protected static final String SIMPLE_RULE_FILE = "etc/rdfs-fb-tgc-simple.rules";
    protected static HashMap ruleSets = new HashMap();
    protected static HashMap ruleFiles;
    protected static RulePreprocessHook cmpProcessor;

    public RDFSRuleReasoner(ReasonerFactory parent) {
        super(RDFSRuleReasoner.loadRulesLevel(DEFAULT_RULES), parent);
        this.setMode(HYBRID);
        this.setTransitiveClosureCaching(true);
    }

    public RDFSRuleReasoner(ReasonerFactory factory, Resource configuration) {
        this(factory);
        if (configuration != null) {
            StmtIterator i = configuration.listProperties();
            while (i.hasNext()) {
                Statement st = i.nextStatement();
                this.doSetParameter(st.getPredicate(), ((Object)st.getObject()).toString());
            }
        }
    }

    protected RDFSRuleReasoner(FBRuleInfGraph schemaGraph, ReasonerFactory factory) {
        super(schemaGraph.getRules(), factory);
        this.schemaGraph = schemaGraph;
    }

    protected boolean doSetParameter(Property parameter, Object value) {
        if (parameter.equals(ReasonerVocabulary.PROPenableCMPScan)) {
            boolean scanProperties = Util.convertBooleanPredicateArg(parameter, value);
            if (scanProperties) {
                this.addPreprocessingHook(cmpProcessor);
            } else {
                this.removePreprocessingHook(cmpProcessor);
            }
            return true;
        }
        if (parameter.equals(ReasonerVocabulary.PROPsetRDFSLevel)) {
            String level = ((String)value).toLowerCase();
            this.setRules(RDFSRuleReasoner.loadRulesLevel(level));
            if (level.equals(FULL_RULES)) {
                this.addPreprocessingHook(cmpProcessor);
            } else {
                this.removePreprocessingHook(cmpProcessor);
            }
            return true;
        }
        return super.doSetParameter(parameter, value);
    }

    public InfGraph bind(Graph data) throws ReasonerException {
        RDFSRuleInfGraph fbgraph;
        Graph schemaArg = this.schemaGraph == null ? this.getPreload() : this.schemaGraph;
        RDFSRuleInfGraph graph = null;
        List ruleSet = ((FBRuleInfGraph)schemaArg).getRules();
        graph = fbgraph = new RDFSRuleInfGraph(this, ruleSet, schemaArg);
        if (this.enableTGCCaching) {
            fbgraph.setUseTGCCache();
        }
        fbgraph.setTraceOn(this.traceOn);
        if (this.preprocessorHooks != null) {
            Iterator i = this.preprocessorHooks.iterator();
            while (i.hasNext()) {
                fbgraph.addPreprocessingHook((RulePreprocessHook)i.next());
            }
        }
        graph.setDerivationLogging(this.recordDerivations);
        graph.rebind(data);
        return graph;
    }

    public Reasoner bindSchema(Graph tbox) throws ReasonerException {
        if (this.schemaGraph != null) {
            throw new ReasonerException("Can only bind one schema at a time to an RDFSRuleReasoner");
        }
        FBRuleInfGraph graph = new FBRuleInfGraph((Reasoner)this, this.rules, (Graph)this.getPreload(), tbox);
        if (this.enableTGCCaching) {
            graph.setUseTGCCache();
        }
        graph.prepare();
        RDFSRuleReasoner grr = new RDFSRuleReasoner(graph, this.factory);
        grr.setDerivationLogging(this.recordDerivations);
        grr.setTraceOn(this.traceOn);
        grr.setTransitiveClosureCaching(this.enableTGCCaching);
        grr.setFunctorFiltering(this.filterFunctors);
        if (this.preprocessorHooks != null) {
            Iterator i = this.preprocessorHooks.iterator();
            while (i.hasNext()) {
                grr.addPreprocessingHook((RulePreprocessHook)i.next());
            }
        }
        return grr;
    }

    public static List loadRulesLevel(String level) {
        List ruleSet = (List)ruleSets.get(level);
        if (ruleSet == null) {
            String file = (String)ruleFiles.get(level);
            if (file == null) {
                throw new ReasonerException("Illegal RDFS conformance level: " + level);
            }
            ruleSet = RDFSRuleReasoner.loadRules(file);
            ruleSets.put(level, ruleSet);
        }
        return ruleSet;
    }

    public Capabilities getGraphCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new BaseInfGraph.InfFindSafeCapabilities();
        }
        return this.capabilities;
    }

    static {
        cmpProcessor = new RDFSCMPPreprocessHook();
        ruleFiles = new HashMap();
        ruleFiles.put(DEFAULT_RULES, RULE_FILE);
        ruleFiles.put(FULL_RULES, FULL_RULE_FILE);
        ruleFiles.put(SIMPLE_RULES, SIMPLE_RULE_FILE);
    }
}

