/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drbx.cortex;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import fr.gael.cortex.CortexModel;
import fr.gael.drb.DrbFactory;
import fr.gael.drb.DrbItem;
import fr.gael.drb.DrbNode;
import fr.gael.drb.impl.DrbFactoryResolver;
import fr.gael.drb.meta.DrbMetadataResolver;
import fr.gael.drbx.cortex.DrbCortexItemClass;
import fr.gael.drbx.cortex.DrbCortexMetadataResolver;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Collection;
import java.util.Vector;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrbCortexModel {
    private static DrbCortexModel defaultModel = null;
    private static boolean isEhCacheAvailable;
    private static boolean isEhCacheChecked;
    private static final String itemPathCacheName = "fr.gael.drbx.cortex.ItemPathCache";
    private static Logger logger;
    private static final String uriPrefix = "http://www.gael.fr/drb#";
    private static final DrbCortexItemClass itemClass;
    private CacheManager cacheManager = null;
    private Collection<DrbCortexItemClass> classes = new Vector<DrbCortexItemClass>();
    private CortexModel cortexModel = null;
    private Cache itemPathCache = null;

    public static synchronized DrbCortexModel getDefaultModel() throws IOException {
        if (defaultModel == null) {
            defaultModel = new DrbCortexModel();
        }
        return defaultModel;
    }

    private static String getItemPathCacheName() {
        return itemPathCacheName;
    }

    protected static String getUriPrefix() {
        return uriPrefix;
    }

    private static boolean isEhCacheAvailable() {
        return isEhCacheAvailable;
    }

    private static boolean isEhCacheChecked() {
        return isEhCacheChecked;
    }

    public static void main(String[] args) throws Exception {
        block17: {
            DrbNode node = null;
            PrintStream output_dot_file = null;
            PrintStream output_slk_file = null;
            for (int iarg = 0; iarg < args.length; ++iarg) {
                if (args[iarg].equals("--dot")) {
                    if (iarg >= args.length - 1) {
                        logger.error("The \"--dot\" option shall be followed by a  file name.");
                        continue;
                    }
                    output_dot_file = new PrintStream(new FileOutputStream(args[++iarg]));
                    continue;
                }
                if (args[iarg].equals("--sylk") || args[iarg].equals("--slk")) {
                    if (iarg >= args.length - 1) {
                        logger.error("The \"--sylk\" option shall be followed by a  file name.");
                        continue;
                    }
                    output_slk_file = new PrintStream(new FileOutputStream(args[++iarg]));
                    continue;
                }
                if (!args[iarg].equals("--item")) continue;
                if (iarg >= args.length - 1) {
                    logger.error("The \"--probe-item\" option shall be followed by a  path to a node.");
                    continue;
                }
                System.out.println("Input item: \"" + args[++iarg] + "\"");
                node = DrbFactory.openURI((String)args[iarg]);
            }
            DrbCortexModel model = DrbCortexModel.getDefaultModel();
            DrbFactoryResolver.setMetadataResolver((DrbMetadataResolver)new DrbCortexMetadataResolver(model));
            if (node != null) {
                try {
                    DrbCortexItemClass node_class = DrbCortexModel.getDefaultModel().getClassOf((DrbItem)node);
                    if (node_class != null) {
                        System.out.println("Found class: " + node_class.getLabel());
                        if (node_class.getSchemaLocation() != null) {
                            System.out.println("Schema Location: \"" + node_class.getSchemaLocation() + "\"");
                        } else {
                            System.out.println("Schema Location: None specified.");
                        }
                        System.out.println("Implementation identifier: \"" + node_class.getPropertyString(DrbCortexModel.getUriPrefix() + "implementationIdentifier", false) + "\"");
                        System.out.println("Children count: " + node.getChildrenCount());
                        System.out.println("Found class 2: " + DrbCortexModel.getDefaultModel().getClassOf((DrbItem)DrbFactory.openURI((String)"D:\\data\\alos\\palsar\\PSR_MMC_IP__0000461001")).getLabel());
                        break block17;
                    }
                    System.out.println("No class of the ontology includes item \"" + node.getName() + "\"");
                }
                catch (Exception exception) {
                    logger.fatal("Error while retrieving node class (" + exception.getMessage() + ")", exception);
                }
            } else if (output_dot_file != null || output_slk_file != null) {
                if (output_dot_file != null) {
                    output_dot_file.print(model.toDot());
                }
                if (output_slk_file != null) {
                    output_slk_file.print(model.toSylk());
                }
            } else {
                System.err.println("Nothing to process.");
            }
        }
    }

    public static void setDefaultModel(DrbCortexModel model) {
        defaultModel = model;
    }

    protected static void setEhCacheAvailable(boolean isEhCacheAvailable) {
        DrbCortexModel.isEhCacheAvailable = isEhCacheAvailable;
    }

    protected static void setEhCacheChecked(boolean isEhCacheChecked) {
        DrbCortexModel.isEhCacheChecked = isEhCacheChecked;
    }

    public DrbCortexModel() throws IOException {
        this(CortexModel.getDefaultModel());
    }

    public DrbCortexModel(CortexModel model) {
        this.setCortexModel(model);
    }

    private CacheManager getCacheManager() {
        return this.cacheManager;
    }

    private Collection<DrbCortexItemClass> getClasses() throws NullPointerException {
        if (this.classes == null) {
            if (this.getCortexModel() == null) {
                throw new NullPointerException("Cannot retreive DRB Item subclasse from a null model.");
            }
            Vector<DrbCortexItemClass> new_classes = new Vector<DrbCortexItemClass>();
            OntModel model = this.getCortexModel().getOntModel();
            OntClass item_class = model.getOntClass(DrbCortexModel.getUriPrefix() + "item");
            if (item_class == null) {
                logger.debug("DRB Item top level class not found.");
                return null;
            }
            ExtendedIterator sub_classes = item_class.listSubClasses(true);
            while (sub_classes.hasNext()) {
                OntClass sub_class = (OntClass)sub_classes.next();
                new_classes.add(new DrbCortexItemClass(this, sub_class));
            }
            this.setClasses(new_classes);
            logger.debug("Top level classes loaded: " + this.classes.size() + " classes found");
        }
        return this.classes;
    }

    DrbCortexItemClass getClassFromCache(String item_path) {
        Element element;
        if (item_path == null) {
            throw new NullPointerException("Null item path.");
        }
        Cache cache = this.getItemPathCache();
        if (cache != null && (element = cache.get((Serializable)((Object)item_path))) != null) {
            return (DrbCortexItemClass)element.getObjectValue();
        }
        return null;
    }

    public DrbCortexItemClass getClassOf(DrbItem item) {
        if (item == null) {
            throw new NullPointerException("Null item.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[CTX CLASS REQUEST] Searching class for item \"" + item.getName() + "\"...");
        }
        DrbCortexItemClass best_fitting_class = null;
        if (item.getItemType() == 1) {
            best_fitting_class = this.getClassFromCache(((DrbNode)item).getPath());
        }
        if (best_fitting_class != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("   [CTX CLASS FOUND] Item \"" + item.getName() + "\"@" + Integer.toHexString(item.hashCode()) + " already identified as of class \"" + best_fitting_class.getLabel() + "\" (returned as is).");
            }
            if (itemClass.equals(best_fitting_class)) {
                return null;
            }
            return best_fitting_class;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("   [CTX CLASS] Item \"" + item.getName() + "\"@" + Integer.toHexString(item.hashCode()) + " not found in cache.");
        }
        for (DrbCortexItemClass current_class : this.getClasses()) {
            best_fitting_class = current_class.getClassOf(item);
            if (best_fitting_class == null) continue;
            if (item.getItemType() == 1) {
                this.putClassInCache(((DrbNode)item).getPath(), best_fitting_class);
            }
            return best_fitting_class;
        }
        if (item.getItemType() == 1) {
            this.putClassInCache(((DrbNode)item).getPath(), itemClass);
        }
        return null;
    }

    public CortexModel getCortexModel() {
        return this.cortexModel;
    }

    private Cache getItemPathCache() {
        return this.itemPathCache;
    }

    private void initializeCache() {
        CacheManager cacheManager;
        if (DrbCortexModel.isEhCacheChecked() && !DrbCortexModel.isEhCacheAvailable()) {
            return;
        }
        if (!DrbCortexModel.isEhCacheChecked()) {
            try {
                Class.forName("net.sf.ehcache.Cache");
            }
            catch (ClassNotFoundException exception) {
                logger.info("No caching system available at runtime.");
                DrbCortexModel.setEhCacheAvailable(false);
                DrbCortexModel.setEhCacheChecked(true);
                return;
            }
            logger.info("Caching system available.");
            DrbCortexModel.setEhCacheAvailable(true);
            DrbCortexModel.setEhCacheChecked(true);
        }
        if ((cacheManager = this.getCacheManager()) == null) {
            try {
                cacheManager = CacheManager.create((URL)this.getClass().getResource("ehcache.xml"));
                logger.info("Cache manager created.");
            }
            catch (CacheException exception) {
                logger.error("Cannot create cache manager - disabling caching functionality.", exception);
                this.setItemPathCache(null);
                DrbCortexModel.setEhCacheAvailable(false);
                return;
            }
            this.setCacheManager(cacheManager);
            Cache cache = new Cache(DrbCortexModel.getItemPathCacheName(), 100, MemoryStoreEvictionPolicy.LFU, false, null, true, 0L, 0L, false, 0L, null);
            logger.info("Cache of item classes created.");
            cacheManager.addCacheIfAbsent((Ehcache)cache);
            this.setItemPathCache(cache);
        } else {
            Cache cache = this.getItemPathCache();
            if (cache != null) {
                cache.removeAll();
                logger.info("Cache of item classes cleared.");
            } else {
                logger.error("Inconsistent cache state: null cache with an available manager - functionality disabled");
                cacheManager.shutdown();
                this.setCacheManager(null);
                DrbCortexModel.setEhCacheAvailable(false);
                return;
            }
        }
    }

    void putClassInCache(String item_path, DrbCortexItemClass clazz) {
        if (item_path == null) {
            throw new NullPointerException("Null item path.");
        }
        if (clazz == null) {
            throw new NullPointerException("Null item class.");
        }
        Cache cache = this.getItemPathCache();
        if (cache != null) {
            Element element = new Element((Object)item_path, (Object)clazz);
            cache.put(element);
        }
    }

    void removeClassFromCache(String item_path) {
        if (item_path == null) {
            throw new NullPointerException("Null item path.");
        }
        Cache cache = this.getItemPathCache();
        if (cache != null) {
            cache.remove((Serializable)((Object)item_path));
        }
    }

    public String resolveResourceUri(String uri) {
        return this.getCortexModel().resolveResourceUrl(uri);
    }

    private void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    private void setClasses(Collection<DrbCortexItemClass> forest) {
        this.classes = forest;
    }

    private void setCortexModel(CortexModel model) {
        if (model != this.cortexModel) {
            this.cortexModel = model;
            this.setClasses(null);
            this.initializeCache();
        }
    }

    private void setItemPathCache(Cache itemPathCache) {
        this.itemPathCache = itemPathCache;
    }

    public String toDot() {
        String graph = "digraph G {\nranksep=15;\nratio=auto;\nrankdir=RL\nedge [arrowhead=\"onormal\"];\nnode [color=lightblue2, style=filled];\n";
        logger.info("String graph=" + graph);
        OntModel model = this.getCortexModel().getOntModel();
        OntClass item_class = model.getOntClass(DrbCortexModel.getUriPrefix() + "item");
        if (item_class == null) {
            logger.debug("DRB Item top level class not found.");
            return null;
        }
        ExtendedIterator sub_classes = model.listClasses();
        while (sub_classes.hasNext()) {
            OntClass sub_class = (OntClass)sub_classes.next();
            String sub_class_label = sub_class.getLabel(null);
            sub_class_label = sub_class_label != null ? "[label=\"" + sub_class_label.trim() + "\"]" : "[label=\"" + sub_class.getURI() + "\"]";
            graph = graph + "\n   \"" + sub_class.getURI() + "\" " + sub_class_label + "\n";
            ExtendedIterator super_classes = sub_class.listSuperClasses(true);
            while (super_classes.hasNext()) {
                OntClass super_class = (OntClass)super_classes.next();
                graph = graph + "      \"" + sub_class.getURI() + "\" -> \"" + super_class.getURI() + "\"\n";
            }
            DrbCortexItemClass current_item_class = new DrbCortexItemClass(sub_class);
            String schema_location_value = current_item_class.getSchemaLocation();
            logger.info("schema_location_value=" + schema_location_value);
            if (schema_location_value != null) {
                graph = graph + "   \"" + sub_class.getURI() + "-schemaLocation\" [label=\"" + schema_location_value.trim() + "\" shape=box color=grey]\n      \"" + sub_class.getURI() + "\" -> \"" + sub_class.getURI() + "-schemaLocation\" [label=\"schemaLocation\" fontcolor=grey color=grey arrowhead=\"normal\"]\n\n";
            } else {
                logger.info("No schema location in the ontoloy for this item");
            }
            String implementation_id_value = current_item_class.getPropertyString(DrbCortexModel.getUriPrefix() + "implementationIdentifier");
            logger.info("\n\n*****************\nimplementation_id_value=" + implementation_id_value);
            if (implementation_id_value != null) {
                graph = graph + "   \"" + sub_class.getURI() + "-implementationIdentifier\" [label=\"" + implementation_id_value.trim() + "\" shape=box color=grey]\n      \"" + sub_class.getURI() + "\" -> \"" + sub_class.getURI() + "-implementationIdentifier\" [label=\"implementationIdentifier\" fontcolor=grey color=grey arrowhead=\"normal\"]\n\n";
                continue;
            }
            logger.info("No implementationIdentifier in the ontoloy for this item");
        }
        graph = graph + "}";
        logger.debug(graph);
        logger.info("String graph=" + graph);
        return graph;
    }

    public String toSylk() {
        String spreadsheet = "ID;P\n";
        OntModel model = this.getCortexModel().getOntModel();
        OntClass item_class = model.getOntClass(DrbCortexModel.getUriPrefix() + "item");
        if (item_class == null) {
            logger.debug("DRB Item top level class not found.");
            return null;
        }
        ExtendedIterator sub_classes = model.listClasses();
        int row = 0;
        while (sub_classes.hasNext()) {
            OntClass sub_class = (OntClass)sub_classes.next();
            spreadsheet = spreadsheet + "C;Y" + ++row + ";X1;K\"" + sub_class.getURI() + "\"\n";
            if (sub_class.getLabel(null) == null) continue;
            spreadsheet = spreadsheet + "C;Y" + row + ";X2;K\"" + sub_class.getLabel(null).trim() + "\"\n";
        }
        spreadsheet = spreadsheet + "E\n";
        return spreadsheet;
    }

    static {
        isEhCacheChecked = false;
        logger = Logger.getLogger(DrbCortexModel.class);
        itemClass = DrbCortexItemClass.getCortexItemClassByName(DrbCortexModel.getUriPrefix() + "item");
    }
}

