/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.streams;

import fr.gael.streams.StreamObserver;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ObservableInputStream
extends InputStream {
    protected static Map<Long, StreamObserver> observers = new ConcurrentHashMap<Long, StreamObserver>();

    public static void addStreamObserver(Long key, StreamObserver observer) {
        observers.put(key, observer);
    }

    public static void removeStreamObserver(Long key, StreamObserver observer) {
        observers.remove(key, observer);
    }

    public static void informObservers(String info) {
        StreamObserver myObserver = observers.get(Thread.currentThread().getId());
        if (myObserver != null) {
            myObserver.update(info);
        }
    }
}

