/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.query;

import fr.gael.drb.DrbDefaultAttribute;
import fr.gael.drb.DrbDefaultSequence;
import fr.gael.drb.DrbItem;
import fr.gael.drb.DrbSequence;
import fr.gael.drb.query.AbstractExpression;
import fr.gael.drb.query.DynamicContext;
import fr.gael.drb.query.DynamicException;
import fr.gael.drb.query.Expression;
import fr.gael.drb.query.QName;
import fr.gael.drb.query.Token;
import fr.gael.drb.query.TypeException;
import fr.gael.drb.value.String;
import fr.gael.drb.value.Value;
import fr.gael.drb.value.ValueArray;
import fr.gael.drb.xsd.Namespace;
import org.apache.log4j.Logger;

class ComputedAttributeConstructorExpression
extends AbstractExpression {
    private static Logger logger = Logger.getLogger(ComputedAttributeConstructorExpression.class);
    private QName name;
    private Expression name_expression;
    private Expression content_expression;

    public ComputedAttributeConstructorExpression(Token token, java.lang.String name) {
        super("Computed Attribute constructor", token);
        this.name = new QName(name);
        this.name_expression = null;
    }

    public ComputedAttributeConstructorExpression(Token token, Expression name_expression) {
        super("Computed Attribute constructor", token);
        this.name_expression = name_expression;
        this.name = null;
    }

    public void setContentExpression(Expression expression) {
        this.content_expression = expression;
    }

    @Override
    public DrbSequence evaluate(DynamicContext outer_context) {
        DynamicContext context = new DynamicContext(outer_context);
        DrbDefaultAttribute attribute = null;
        QName name = this.processAttributeName(context);
        attribute = new DrbDefaultAttribute(name.getLocalName(), null);
        this.setAttributeURI(context, attribute, name);
        if (this.content_expression == null) {
            return new DrbDefaultSequence(attribute);
        }
        this.processContentExpression(context, this.content_expression, attribute);
        return new DrbDefaultSequence(attribute);
    }

    private void setAttributeURI(DynamicContext context, DrbDefaultAttribute attribute, QName name) {
        Namespace namespace = context.getNamespace();
        if (name.getPrefix() == null) {
            if (name.getLocalName().equals("xmlns")) {
                throw new DynamicException(this, "XQDY0044 - The local name \"xmlns\" to declare a default namespace is not allowed for a computed attribute constructor.");
            }
            attribute.setNamespaceURI(null);
        } else if (name.getPrefix() != null) {
            if (name.getPrefix().equals("xmlns")) {
                throw new DynamicException(this, "XQDY0044 - The prefix \"xmlns\" is not allowed for a computed attribute constructor.");
            }
            java.lang.String nURI = namespace.resolveNamespace(name.getPrefix());
            if (nURI == null) {
                throw new DynamicException(this, "XQDY0074 - The prefix \"" + name.getPrefix() + "\" has not been bound.");
            }
            if (nURI.equals("http://www.w3.org/2000/xmlns/")) {
                throw new DynamicException(this, "XQDY0044 - The namespace linked  to the xmlns prefix is not allowed inside \"computed attribute constructor.");
            }
            attribute.setNamespaceURI(nURI);
        }
    }

    private QName processAttributeName(DynamicContext context) {
        if (this.name != null) {
            return this.name;
        }
        if (this.name_expression == null) {
            throw new DynamicException(this, "The name or the name expression of the element constructor cannot be null");
        }
        DrbSequence sequence = this.name_expression.evaluate(context);
        if (sequence == null) {
            throw new DynamicException(this, "Error while evaluating the name expression");
        }
        ValueArray array = sequence.atomize();
        if (array.length() != 1) {
            throw new TypeException(this, "XPTY0004 - The sequence length of the name expression must be one");
        }
        Value value = array.getElement(0);
        if (!(value instanceof String)) {
            throw new TypeException(this, "XPTY0004 - Result of the evaluation of the name expression must be a singleton containing either a String or a QName");
        }
        return new QName(value.toString());
    }

    private void processContentExpression(DynamicContext context, Expression content_expression, DrbDefaultAttribute attribute) {
        DrbSequence sequence = content_expression.evaluate(context);
        if (sequence != null) {
            sequence = sequence.atomize();
        }
        if (sequence == null) {
            throw new DynamicException(this, "Error while evaluating content-expression for attribut " + attribute.getName());
        }
        boolean value_initialized = false;
        boolean concatenation_performed = false;
        java.lang.String attribute_string = "";
        for (int iitem = 0; iitem < sequence.getLength(); ++iitem) {
            DrbItem item = sequence.getItem(iitem);
            if (item == null) {
                throw new DynamicException(this, "Null item resulting from evaluation of attribute " + attribute.getName());
            }
            Value attribute_value = (Value)item;
            if (attribute_value == null) {
                throw new DynamicException(this, "Null value resulting from evaluation of attribute " + attribute.getName());
            }
            if (!value_initialized) {
                attribute.setValue(attribute_value);
                value_initialized = true;
                continue;
            }
            try {
                if (!concatenation_performed) {
                    attribute_string = ((String)attribute.getValue().convertTo(7)).toString();
                }
                if (iitem >= 1) {
                    attribute_string = attribute_string + " ";
                }
                attribute_string = attribute_string + ((String)attribute_value.convertTo(7)).toString();
            }
            catch (ClassCastException e) {
                throw new DynamicException(this, "XQ0052 - Unable to cast item #" + (iitem + 1) + " to string (attribute " + attribute.getName() + ")");
            }
            concatenation_performed = true;
        }
        if (!value_initialized || concatenation_performed) {
            attribute.setValue(new String(attribute_string));
        }
    }
}

