---
name: Bug Report
about: Report a bug in DuraGraph Python SDK
title: "[BUG] "
labels: bug
assignees: ''
---

## Bug Description

<!-- A clear and concise description of the bug -->

## To Reproduce

Steps to reproduce the behavior:

1. Create a graph with...
2. Run...
3. See error

## Expected Behavior

<!-- What you expected to happen -->

## Actual Behavior

<!-- What actually happened -->

## Code Example

```python
# Minimal code to reproduce the issue
from duragraph import Graph, llm_node

@Graph(id="example")
class MyAgent:
    ...
```

## Error Message

```
# Paste the full error message/traceback here
```

## Environment

- OS: [e.g., macOS 14.0, Ubuntu 22.04]
- Python version: [e.g., 3.12.0]
- DuraGraph version: [e.g., 0.1.0]
- Control Plane version (if applicable): [e.g., 0.1.0]

## Additional Context

<!-- Any other context about the problem -->
