from setuptools import setup, find_packages

setup(
    name="dverse_agent_python",
    version="v1.0.1",
    packages=find_packages(),
    install_requires=[
        "argon2-cffi==23.1.0",
        "argon2-cffi-bindings==21.2.0",
        "azure-core==1.30.1",
        "azure-storage-blob==12.20.0",
        "boolean.py==4.0",
        "CacheControl==0.14.0",
        "certifi==2024.6.2",
        "cffi==1.16.0",
        "cfgv==3.4.0",
        "charset-normalizer==3.3.2",
        "click==8.1.7",
        "colorama==0.4.6",
        "confluent-kafka==2.4.0",
        "cryptography==42.0.8",
        "cyclonedx-python-lib==7.4.0",
        "defusedxml==0.7.1",
        "distlib==0.3.8",
        "environs==9.5.0",
        "filelock==3.14.0",
        "fsspec==2024.6.0",
        "grpcio==1.60.0",
        "html5lib==1.1",
        "huggingface-hub==0.23.2",
        "identify==2.5.36",
        "idna==3.7",
        "intel-openmp==2021.4.0",
        "isodate==0.6.1",
        "Jinja2==3.1.4",
        "joblib==1.4.2",
        "license-expression==30.3.0",
        "markdown-it-py==3.0.0",
        "MarkupSafe==2.1.5",
        "marshmallow==3.21.2",
        "mdurl==0.1.2",
        "minio==7.2.7",
        "mkl==2021.4.0",
        "mpmath==1.3.0",
        "msgpack==1.0.8",
        "networkx==3.3",
        "nodeenv==1.9.1",
        "numpy==1.26.4",
        "packageurl-python==0.15.0",
        "packaging==24.0",
        "pandas==2.2.2",
        "pillow==10.3.0",
        "pip-api==0.0.33",
        "pip-requirements-parser==32.0.1",
        "pip_audit==2.7.3",
        "platformdirs==4.2.2",
        "pre-commit==3.7.1",
        "proto-plus==1.23.0",
        "protobuf==4.25.3",
        "py-serializable==1.0.3",
        "pyarrow==16.1.0",
        "pyasn1==0.6.0",
        "pyasn1_modules==0.4.0",
        "pycparser==2.22",
        "pycryptodome==3.20.0",
        "Pygments==2.18.0",
        "pymilvus==2.4.1",
        "pyparsing==3.1.2",
        "python-dateutil==2.9.0.post0",
        "python-dotenv==1.0.1",
        "python-slugify==8.0.4",
        "pytz==2024.1",
        "PyYAML==6.0.1",
        "regex==2024.5.15",
        "requests==2.32.3",
        "rich==13.7.1",
        "safetensors==0.4.3",
        "scikit-learn==1.5.0",
        "scipy==1.13.1",
        "sentence-transformers==3.0.0",
        "setuptools==70.0.0",
        "six==1.16.0",
        "sortedcontainers==2.4.0",
        "sympy==1.12.1",
        "tbb==2021.12.0",
        "text-unidecode==1.3",
        "threadpoolctl==3.5.0",
        "tokenizers==0.19.1",
        "toml==0.10.2",
        "torch==2.3.0",
        "tqdm==4.66.4",
        "transformers==4.41.2",
        "typing_extensions==4.12.1",
        "tzdata==2024.1",
        "ujson==5.10.0",
        "urllib3==2.2.1",
        "virtualenv==20.26.2",
        "webencodings==0.5.1",
        "wheel==0.43.0"
    ],
    entry_points={
        "console_scripts": [
            # If we have scripts to expose as CLI commands, specify them here
        ],
    },
    author="Fontys-Dverse",
    description="A package for creating an Agent for the DVerse platform.",
    long_description="A package for creating an Agent for the DVerse platform. "
                     "You can see an example at "
                     "https://github.com/fuas-dverse/dverse-agent-python/blob/main/demo_agent.py "
                     "for how you can create your own.",
    url="https://pypi.org/project/dverse-agent-python/"
)

# In the dverse-agent-python repository
# Make sure that you do not cd away from the base directory of the repository for the next few steps.
# First, run : pip install . # This will clone the repository and create a package out of it.
# Then execute : python setup.py bdist_wheel # This will create a tar.gz. file of the package.
# You can find the tar file in the dist folder in the same repository as where you are now.
