# Introduction
The Dyspatch API is based on the REST paradigm, and features resource based URLs with standard HTTP response codes to indicate errors.
We use standard HTTP authentication and request verbs, and all responses are JSON formatted.
See our [Implementation Guide](https://docs.dyspatch.io/development/implementing_dyspatch/) for more details on how to implement Dyspatch.

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 2018.02
- Package version: 1.0.0
- Build package: io.swagger.codegen.languages.PythonClientCodegen

For more information, please visit [https://docs.dyspatch.io](https://docs.dyspatch.io)

## Requirements.

Python 2.7 and 3.6+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import swagger_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import swagger_client
```

## Getting Started

Please follow the [installation procedure](#installation-usage) and then run the following:

```python
from __future__ import print_function
import time
import swagger_client
from swagger_client.rest import ApiException
from pprint import pprint

# Configure API key authorization: Bearer
swagger_client.configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# swagger_client.configuration.api_key_prefix['Authorization'] = 'Bearer'
# create an instance of the API class
api_instance = swagger_client.LocalizationsApi()
template_draft_id = 'template_draft_id_example' # str | A draft ID
localization_id = 'localization_id_example' # str | A localization ID

try:
    # Gets a Localized Draft
    api_response = api_instance.localizations_localization_id_drafts_template_draft_id_get(template_draft_id, localization_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling LocalizationsApi->localizations_localization_id_drafts_template_draft_id_get: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://api.dyspatch.io*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*LocalizationsApi* | [**localizations_localization_id_drafts_template_draft_id_get**](docs/LocalizationsApi.md#localizations_localization_id_drafts_template_draft_id_get) | **GET** /localizations/{localizationId}/drafts/{templateDraftId} | Gets a Localized Draft
*LocalizationsApi* | [**localizations_localization_id_get**](docs/LocalizationsApi.md#localizations_localization_id_get) | **GET** /localizations/{localizationId} | Get Localization Object by ID
*TemplatesApi* | [**templates_get**](docs/TemplatesApi.md#templates_get) | **GET** /templates | List Templates
*TemplatesApi* | [**templates_template_id_drafts_get**](docs/TemplatesApi.md#templates_template_id_drafts_get) | **GET** /templates/{templateId}/drafts | List Template Drafts
*TemplatesApi* | [**templates_template_id_drafts_template_draft_id_get**](docs/TemplatesApi.md#templates_template_id_drafts_template_draft_id_get) | **GET** /templates/{templateId}/drafts/{templateDraftId} | Get a Draft
*TemplatesApi* | [**templates_template_id_get**](docs/TemplatesApi.md#templates_template_id_get) | **GET** /templates/{templateId} | Get Template by ID


## Documentation For Models

 - [APIError](docs/APIError.md)
 - [CompiledRead](docs/CompiledRead.md)
 - [CreatedAt](docs/CreatedAt.md)
 - [Cursor](docs/Cursor.md)
 - [LanguageId](docs/LanguageId.md)
 - [LocalizationDraftMetaRead](docs/LocalizationDraftMetaRead.md)
 - [LocalizationDraftRead](docs/LocalizationDraftRead.md)
 - [LocalizationDraftUrl](docs/LocalizationDraftUrl.md)
 - [LocalizationId](docs/LocalizationId.md)
 - [LocalizationMetaRead](docs/LocalizationMetaRead.md)
 - [LocalizationName](docs/LocalizationName.md)
 - [LocalizationRead](docs/LocalizationRead.md)
 - [LocalizationUrl](docs/LocalizationUrl.md)
 - [TemplateDescription](docs/TemplateDescription.md)
 - [TemplateDraftId](docs/TemplateDraftId.md)
 - [TemplateDraftMetaRead](docs/TemplateDraftMetaRead.md)
 - [TemplateDraftRead](docs/TemplateDraftRead.md)
 - [TemplateDraftUrl](docs/TemplateDraftUrl.md)
 - [TemplateDraftsRead](docs/TemplateDraftsRead.md)
 - [TemplateId](docs/TemplateId.md)
 - [TemplateMetaRead](docs/TemplateMetaRead.md)
 - [TemplateName](docs/TemplateName.md)
 - [TemplateRead](docs/TemplateRead.md)
 - [TemplateUrl](docs/TemplateUrl.md)
 - [TemplatesRead](docs/TemplatesRead.md)
 - [UpdatedAt](docs/UpdatedAt.md)


## Documentation For Authorization


## Bearer

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header
