# coding: utf-8

"""
    Dyspatch API

    # Introduction  The Dyspatch API is based on the REST paradigm, and features resource based URLs with standard HTTP response codes to indicate errors. We use standard HTTP authentication and request verbs, and all responses are JSON formatted. See our [Implementation Guide](https://docs.dyspatch.io/development/implementing_dyspatch/) for more details on how to implement Dyspatch.   # noqa: E501

    OpenAPI spec version: 2018.02
    Contact: support@dyspatch.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from swagger_client.api_client import ApiClient


class LocalizationsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def localizations_localization_id_drafts_template_draft_id_get(self, template_draft_id, localization_id, **kwargs):  # noqa: E501
        """Gets a Localized Draft  # noqa: E501

        Returns a localized Draft object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.localizations_localization_id_drafts_template_draft_id_get(template_draft_id, localization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str template_draft_id: A draft ID (required)
        :param str localization_id: A localization ID (required)
        :return: LocalizationDraftRead
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.localizations_localization_id_drafts_template_draft_id_get_with_http_info(template_draft_id, localization_id, **kwargs)  # noqa: E501
        else:
            (data) = self.localizations_localization_id_drafts_template_draft_id_get_with_http_info(template_draft_id, localization_id, **kwargs)  # noqa: E501
            return data

    def localizations_localization_id_drafts_template_draft_id_get_with_http_info(self, template_draft_id, localization_id, **kwargs):  # noqa: E501
        """Gets a Localized Draft  # noqa: E501

        Returns a localized Draft object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.localizations_localization_id_drafts_template_draft_id_get_with_http_info(template_draft_id, localization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str template_draft_id: A draft ID (required)
        :param str localization_id: A localization ID (required)
        :return: LocalizationDraftRead
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['template_draft_id', 'localization_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method localizations_localization_id_drafts_template_draft_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'template_draft_id' is set
        if ('template_draft_id' not in params or
                params['template_draft_id'] is None):
            raise ValueError("Missing the required parameter `template_draft_id` when calling `localizations_localization_id_drafts_template_draft_id_get`")  # noqa: E501
        # verify the required parameter 'localization_id' is set
        if ('localization_id' not in params or
                params['localization_id'] is None):
            raise ValueError("Missing the required parameter `localization_id` when calling `localizations_localization_id_drafts_template_draft_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'template_draft_id' in params:
            path_params['templateDraftId'] = params['template_draft_id']  # noqa: E501
        if 'localization_id' in params:
            path_params['localizationId'] = params['localization_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.dyspatch.2018.02+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/localizations/{localizationId}/drafts/{templateDraftId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LocalizationDraftRead',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def localizations_localization_id_get(self, localization_id, **kwargs):  # noqa: E501
        """Get Localization Object by ID  # noqa: E501

        Returns a specific localization object with a matching ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.localizations_localization_id_get(localization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str localization_id: A localization ID (required)
        :return: LocalizationRead
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.localizations_localization_id_get_with_http_info(localization_id, **kwargs)  # noqa: E501
        else:
            (data) = self.localizations_localization_id_get_with_http_info(localization_id, **kwargs)  # noqa: E501
            return data

    def localizations_localization_id_get_with_http_info(self, localization_id, **kwargs):  # noqa: E501
        """Get Localization Object by ID  # noqa: E501

        Returns a specific localization object with a matching ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.localizations_localization_id_get_with_http_info(localization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str localization_id: A localization ID (required)
        :return: LocalizationRead
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['localization_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method localizations_localization_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'localization_id' is set
        if ('localization_id' not in params or
                params['localization_id'] is None):
            raise ValueError("Missing the required parameter `localization_id` when calling `localizations_localization_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'localization_id' in params:
            path_params['localizationId'] = params['localization_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.dyspatch.2018.02+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/localizations/{localizationId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LocalizationRead',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
