# Dyspatch Python Client
# Introduction
The Dyspatch API is based on the REST paradigm and features resource based URLs
with standard HTTP response codes to indicate errors.

We use standard HTTP authentication and request verbs and all responses are
JSON formatted. See our [Implementation
Guide](https://docs.dyspatch.io/development/implementing_dyspatch/) for more
details on how to implement Dyspatch.

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 2019.10
- Package version: 3.0.0
- Build package: io.swagger.codegen.languages.PythonClientCodegen
For more information, please visit [https://docs.dyspatch.io](https://docs.dyspatch.io)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import dyspatch_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import dyspatch_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import dyspatch_client
from dyspatch_client.rest import ApiException
from pprint import pprint

# Configure API key authorization: Bearer
configuration = dyspatch_client.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = dyspatch_client.DraftsApi(dyspatch_client.ApiClient(configuration))
draft_id = 'draft_id_example' # str | A draft ID
target_language = 'target_language_example' # str | The type of templating language to compile as. Should only be used for visual templates.

try:
    # Get Draft by ID
    api_response = api_instance.drafts_draft_id_get(draft_id, target_language)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DraftsApi->drafts_draft_id_get: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://api.dyspatch.io*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DraftsApi* | [**drafts_draft_id_get**](docs/DraftsApi.md#drafts_draft_id_get) | **GET** /drafts/{draftId} | Get Draft by ID
*DraftsApi* | [**drafts_draft_id_localization_keys_get**](docs/DraftsApi.md#drafts_draft_id_localization_keys_get) | **GET** /drafts/{draftId}/localizationKeys | Get Localization Keys
*DraftsApi* | [**drafts_draft_id_localizations_get**](docs/DraftsApi.md#drafts_draft_id_localizations_get) | **GET** /drafts/{draftId}/localizations | Get Localizations on a Draft
*DraftsApi* | [**drafts_draft_id_localizations_language_id_delete**](docs/DraftsApi.md#drafts_draft_id_localizations_language_id_delete) | **DELETE** /drafts/{draftId}/localizations/{languageId} | Remove a Localization
*DraftsApi* | [**drafts_draft_id_localizations_language_id_put**](docs/DraftsApi.md#drafts_draft_id_localizations_language_id_put) | **PUT** /drafts/{draftId}/localizations/{languageId} | Create or Update a Localization
*DraftsApi* | [**drafts_draft_id_localizations_language_id_translations_put**](docs/DraftsApi.md#drafts_draft_id_localizations_language_id_translations_put) | **PUT** /drafts/{draftId}/localizations/{languageId}/translations | Set Translations for Language
*DraftsApi* | [**drafts_draft_id_publish_request_post**](docs/DraftsApi.md#drafts_draft_id_publish_request_post) | **POST** /drafts/{draftId}/publishRequest | Submit the Draft for Approval
*DraftsApi* | [**drafts_get**](docs/DraftsApi.md#drafts_get) | **GET** /drafts | List Drafts
*LocalizationsApi* | [**localizations_localization_id_get**](docs/LocalizationsApi.md#localizations_localization_id_get) | **GET** /localizations/{localizationId} | Get Localization Object by ID
*TemplatesApi* | [**templates_get**](docs/TemplatesApi.md#templates_get) | **GET** /templates | List Templates
*TemplatesApi* | [**templates_template_id_get**](docs/TemplatesApi.md#templates_template_id_get) | **GET** /templates/{templateId} | Get Template by ID


## Documentation For Models

 - [APIError](docs/APIError.md)
 - [Body](docs/Body.md)
 - [CompiledRead](docs/CompiledRead.md)
 - [CreatedAt](docs/CreatedAt.md)
 - [Cursor](docs/Cursor.md)
 - [DraftDescription](docs/DraftDescription.md)
 - [DraftId](docs/DraftId.md)
 - [DraftMetaRead](docs/DraftMetaRead.md)
 - [DraftName](docs/DraftName.md)
 - [DraftRead](docs/DraftRead.md)
 - [DraftUrl](docs/DraftUrl.md)
 - [DraftsRead](docs/DraftsRead.md)
 - [LanguageId](docs/LanguageId.md)
 - [LocalizationId](docs/LocalizationId.md)
 - [LocalizationKeyRead](docs/LocalizationKeyRead.md)
 - [LocalizationMetaRead](docs/LocalizationMetaRead.md)
 - [LocalizationName](docs/LocalizationName.md)
 - [LocalizationRead](docs/LocalizationRead.md)
 - [LocalizationUrl](docs/LocalizationUrl.md)
 - [TemplateDescription](docs/TemplateDescription.md)
 - [TemplateId](docs/TemplateId.md)
 - [TemplateMetaRead](docs/TemplateMetaRead.md)
 - [TemplateName](docs/TemplateName.md)
 - [TemplateRead](docs/TemplateRead.md)
 - [TemplateUrl](docs/TemplateUrl.md)
 - [TemplatesRead](docs/TemplatesRead.md)
 - [UpdatedAt](docs/UpdatedAt.md)


## Documentation For Authorization


## Bearer

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Author

support@dyspatch.io

