# coding: utf-8

"""
    Dyspatch API

    # Introduction  The Dyspatch API is based on the REST paradigm and features resource based URLs with standard HTTP response codes to indicate errors. We use standard HTTP authentication and request verbs and all responses are JSON formatted. See our [Implementation Guide](https://docs.dyspatch.io/development/implementing_dyspatch/) for more details on how to implement Dyspatch.  ## API Client Libraries  Dyspatch provides API Clients for the following languages and web frameworks:  - [Java](https://github.com/getdyspatch/dyspatch-java) - [Javascript](https://github.com/getdyspatch/dyspatch-javascript) - [Python](https://github.com/getdyspatch/dyspatch-python) - [C#](https://github.com/getdyspatch/dyspatch-dotnet) - [Go](https://github.com/getdyspatch/dyspatch-golang) - [Ruby](https://github.com/getdyspatch/dyspatch-ruby)   # noqa: E501

    OpenAPI spec version: 2019.10
    Contact: support@dyspatch.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from dyspatch_client.api_client import ApiClient


class DraftsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def drafts_draft_id_get(self, draft_id, target_language, **kwargs):  # noqa: E501
        """Get Draft by ID  # noqa: E501

        Gets a draft object with the matching ID. The \"compiled\" field will contain the unlocalized default template object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.drafts_draft_id_get(draft_id, target_language, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str draft_id: A draft ID (required)
        :param str target_language: The type of templating language to compile as. Should only be used for visual templates. (required)
        :return: DraftRead
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.drafts_draft_id_get_with_http_info(draft_id, target_language, **kwargs)  # noqa: E501
        else:
            (data) = self.drafts_draft_id_get_with_http_info(draft_id, target_language, **kwargs)  # noqa: E501
            return data

    def drafts_draft_id_get_with_http_info(self, draft_id, target_language, **kwargs):  # noqa: E501
        """Get Draft by ID  # noqa: E501

        Gets a draft object with the matching ID. The \"compiled\" field will contain the unlocalized default template object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.drafts_draft_id_get_with_http_info(draft_id, target_language, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str draft_id: A draft ID (required)
        :param str target_language: The type of templating language to compile as. Should only be used for visual templates. (required)
        :return: DraftRead
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['draft_id', 'target_language']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method drafts_draft_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'draft_id' is set
        if ('draft_id' not in params or
                params['draft_id'] is None):
            raise ValueError("Missing the required parameter `draft_id` when calling `drafts_draft_id_get`")  # noqa: E501
        # verify the required parameter 'target_language' is set
        if ('target_language' not in params or
                params['target_language'] is None):
            raise ValueError("Missing the required parameter `target_language` when calling `drafts_draft_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'draft_id' in params:
            path_params['draftId'] = params['draft_id']  # noqa: E501

        query_params = []
        if 'target_language' in params:
            query_params.append(('targetLanguage', params['target_language']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.dyspatch.2019.10+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/drafts/{draftId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DraftRead',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def drafts_draft_id_localization_keys_get(self, draft_id, **kwargs):  # noqa: E501
        """Get Localization Keys  # noqa: E501

        Returns the list of values that need to be translated for the draft. Set the `Accept` header to `application/vnd.dyspatch.2019.10+json` to get a JSON object, or `text/vnd.dyspatch.2019.10+x-gettext-translation` to get the POT file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.drafts_draft_id_localization_keys_get(draft_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str draft_id: A draft ID (required)
        :param str accept: A version of the API that should be used for the request. For example, to use version \"2019.10\", set the value to \"application/vnd.dyspatch.2019.10+json\".
        :return: list[LocalizationKeyRead]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.drafts_draft_id_localization_keys_get_with_http_info(draft_id, **kwargs)  # noqa: E501
        else:
            (data) = self.drafts_draft_id_localization_keys_get_with_http_info(draft_id, **kwargs)  # noqa: E501
            return data

    def drafts_draft_id_localization_keys_get_with_http_info(self, draft_id, **kwargs):  # noqa: E501
        """Get Localization Keys  # noqa: E501

        Returns the list of values that need to be translated for the draft. Set the `Accept` header to `application/vnd.dyspatch.2019.10+json` to get a JSON object, or `text/vnd.dyspatch.2019.10+x-gettext-translation` to get the POT file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.drafts_draft_id_localization_keys_get_with_http_info(draft_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str draft_id: A draft ID (required)
        :param str accept: A version of the API that should be used for the request. For example, to use version \"2019.10\", set the value to \"application/vnd.dyspatch.2019.10+json\".
        :return: list[LocalizationKeyRead]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['draft_id', 'accept']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method drafts_draft_id_localization_keys_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'draft_id' is set
        if ('draft_id' not in params or
                params['draft_id'] is None):
            raise ValueError("Missing the required parameter `draft_id` when calling `drafts_draft_id_localization_keys_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'draft_id' in params:
            path_params['draftId'] = params['draft_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'accept' in params:
            header_params['Accept'] = params['accept']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.dyspatch.2019.10+json', 'text/vnd.dyspatch.2019.10+x-gettext-translation'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/drafts/{draftId}/localizationKeys', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[LocalizationKeyRead]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def drafts_draft_id_localizations_get(self, draft_id, **kwargs):  # noqa: E501
        """Get Localizations on a Draft  # noqa: E501

        Returns localization metadata object for a template draft.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.drafts_draft_id_localizations_get(draft_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str draft_id: A draft ID (required)
        :return: list[LocalizationMetaRead]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.drafts_draft_id_localizations_get_with_http_info(draft_id, **kwargs)  # noqa: E501
        else:
            (data) = self.drafts_draft_id_localizations_get_with_http_info(draft_id, **kwargs)  # noqa: E501
            return data

    def drafts_draft_id_localizations_get_with_http_info(self, draft_id, **kwargs):  # noqa: E501
        """Get Localizations on a Draft  # noqa: E501

        Returns localization metadata object for a template draft.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.drafts_draft_id_localizations_get_with_http_info(draft_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str draft_id: A draft ID (required)
        :return: list[LocalizationMetaRead]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['draft_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method drafts_draft_id_localizations_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'draft_id' is set
        if ('draft_id' not in params or
                params['draft_id'] is None):
            raise ValueError("Missing the required parameter `draft_id` when calling `drafts_draft_id_localizations_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'draft_id' in params:
            path_params['draftId'] = params['draft_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.dyspatch.2019.10+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/drafts/{draftId}/localizations', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[LocalizationMetaRead]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def drafts_draft_id_localizations_language_id_delete(self, draft_id, language_id, **kwargs):  # noqa: E501
        """Remove a Localization  # noqa: E501

        Deletes the localization with the given `languageId` if it exists.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.drafts_draft_id_localizations_language_id_delete(draft_id, language_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str draft_id: A draft ID (required)
        :param str language_id: A language ID (eg: en-US) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.drafts_draft_id_localizations_language_id_delete_with_http_info(draft_id, language_id, **kwargs)  # noqa: E501
        else:
            (data) = self.drafts_draft_id_localizations_language_id_delete_with_http_info(draft_id, language_id, **kwargs)  # noqa: E501
            return data

    def drafts_draft_id_localizations_language_id_delete_with_http_info(self, draft_id, language_id, **kwargs):  # noqa: E501
        """Remove a Localization  # noqa: E501

        Deletes the localization with the given `languageId` if it exists.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.drafts_draft_id_localizations_language_id_delete_with_http_info(draft_id, language_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str draft_id: A draft ID (required)
        :param str language_id: A language ID (eg: en-US) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['draft_id', 'language_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method drafts_draft_id_localizations_language_id_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'draft_id' is set
        if ('draft_id' not in params or
                params['draft_id'] is None):
            raise ValueError("Missing the required parameter `draft_id` when calling `drafts_draft_id_localizations_language_id_delete`")  # noqa: E501
        # verify the required parameter 'language_id' is set
        if ('language_id' not in params or
                params['language_id'] is None):
            raise ValueError("Missing the required parameter `language_id` when calling `drafts_draft_id_localizations_language_id_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'draft_id' in params:
            path_params['draftId'] = params['draft_id']  # noqa: E501
        if 'language_id' in params:
            path_params['languageId'] = params['language_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.dyspatch.2019.10+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/drafts/{draftId}/localizations/{languageId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def drafts_draft_id_localizations_language_id_put(self, draft_id, language_id, body, **kwargs):  # noqa: E501
        """Create or Update a Localization  # noqa: E501

        Inserts a localization or sets the name on an existing localization that already uses the `languageId`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.drafts_draft_id_localizations_language_id_put(draft_id, language_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str draft_id: A draft ID (required)
        :param str language_id: A language ID (eg: en-US) (required)
        :param Body body: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.drafts_draft_id_localizations_language_id_put_with_http_info(draft_id, language_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.drafts_draft_id_localizations_language_id_put_with_http_info(draft_id, language_id, body, **kwargs)  # noqa: E501
            return data

    def drafts_draft_id_localizations_language_id_put_with_http_info(self, draft_id, language_id, body, **kwargs):  # noqa: E501
        """Create or Update a Localization  # noqa: E501

        Inserts a localization or sets the name on an existing localization that already uses the `languageId`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.drafts_draft_id_localizations_language_id_put_with_http_info(draft_id, language_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str draft_id: A draft ID (required)
        :param str language_id: A language ID (eg: en-US) (required)
        :param Body body: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['draft_id', 'language_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method drafts_draft_id_localizations_language_id_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'draft_id' is set
        if ('draft_id' not in params or
                params['draft_id'] is None):
            raise ValueError("Missing the required parameter `draft_id` when calling `drafts_draft_id_localizations_language_id_put`")  # noqa: E501
        # verify the required parameter 'language_id' is set
        if ('language_id' not in params or
                params['language_id'] is None):
            raise ValueError("Missing the required parameter `language_id` when calling `drafts_draft_id_localizations_language_id_put`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `drafts_draft_id_localizations_language_id_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'draft_id' in params:
            path_params['draftId'] = params['draft_id']  # noqa: E501
        if 'language_id' in params:
            path_params['languageId'] = params['language_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.dyspatch.2019.10+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/drafts/{draftId}/localizations/{languageId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def drafts_draft_id_localizations_language_id_translations_put(self, draft_id, language_id, body, **kwargs):  # noqa: E501
        """Set Translations for Language  # noqa: E501

        Completely replaces any existing translations for the given language with those provided in request body. Variables embedded in keys or values are expected to be in the format `%(my_variable)s` and will automatically convert to the correct Dyspatch format depending on the type of template. Accepts key/value pairs in JSON format or in gettext PO file format. For JSON set `Content-Type` header to `application/json`. For gettext PO format set `Content-Type` header to `text/x-gettext-translation`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.drafts_draft_id_localizations_language_id_translations_put(draft_id, language_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str draft_id: A draft ID (required)
        :param str language_id: A language ID (eg: en-US) (required)
        :param object body: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.drafts_draft_id_localizations_language_id_translations_put_with_http_info(draft_id, language_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.drafts_draft_id_localizations_language_id_translations_put_with_http_info(draft_id, language_id, body, **kwargs)  # noqa: E501
            return data

    def drafts_draft_id_localizations_language_id_translations_put_with_http_info(self, draft_id, language_id, body, **kwargs):  # noqa: E501
        """Set Translations for Language  # noqa: E501

        Completely replaces any existing translations for the given language with those provided in request body. Variables embedded in keys or values are expected to be in the format `%(my_variable)s` and will automatically convert to the correct Dyspatch format depending on the type of template. Accepts key/value pairs in JSON format or in gettext PO file format. For JSON set `Content-Type` header to `application/json`. For gettext PO format set `Content-Type` header to `text/x-gettext-translation`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.drafts_draft_id_localizations_language_id_translations_put_with_http_info(draft_id, language_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str draft_id: A draft ID (required)
        :param str language_id: A language ID (eg: en-US) (required)
        :param object body: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['draft_id', 'language_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method drafts_draft_id_localizations_language_id_translations_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'draft_id' is set
        if ('draft_id' not in params or
                params['draft_id'] is None):
            raise ValueError("Missing the required parameter `draft_id` when calling `drafts_draft_id_localizations_language_id_translations_put`")  # noqa: E501
        # verify the required parameter 'language_id' is set
        if ('language_id' not in params or
                params['language_id'] is None):
            raise ValueError("Missing the required parameter `language_id` when calling `drafts_draft_id_localizations_language_id_translations_put`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `drafts_draft_id_localizations_language_id_translations_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'draft_id' in params:
            path_params['draftId'] = params['draft_id']  # noqa: E501
        if 'language_id' in params:
            path_params['languageId'] = params['language_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.dyspatch.2019.10+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/drafts/{draftId}/localizations/{languageId}/translations', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def drafts_draft_id_publish_request_post(self, draft_id, **kwargs):  # noqa: E501
        """Submit the Draft for Approval  # noqa: E501

        Moves the draft into [submitted and locked state](https://docs.dyspatch.io/templates/submitting_a_template/#awaiting-approval). This will allow your email stakeholders to review the template draft and provide feedback.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.drafts_draft_id_publish_request_post(draft_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str draft_id: A draft ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.drafts_draft_id_publish_request_post_with_http_info(draft_id, **kwargs)  # noqa: E501
        else:
            (data) = self.drafts_draft_id_publish_request_post_with_http_info(draft_id, **kwargs)  # noqa: E501
            return data

    def drafts_draft_id_publish_request_post_with_http_info(self, draft_id, **kwargs):  # noqa: E501
        """Submit the Draft for Approval  # noqa: E501

        Moves the draft into [submitted and locked state](https://docs.dyspatch.io/templates/submitting_a_template/#awaiting-approval). This will allow your email stakeholders to review the template draft and provide feedback.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.drafts_draft_id_publish_request_post_with_http_info(draft_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str draft_id: A draft ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['draft_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method drafts_draft_id_publish_request_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'draft_id' is set
        if ('draft_id' not in params or
                params['draft_id'] is None):
            raise ValueError("Missing the required parameter `draft_id` when calling `drafts_draft_id_publish_request_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'draft_id' in params:
            path_params['draftId'] = params['draft_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.dyspatch.2019.10+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/drafts/{draftId}/publishRequest', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def drafts_get(self, **kwargs):  # noqa: E501
        """List Drafts  # noqa: E501

        Gets a list of all drafts for your oranization. Up to 25 results returned before results are paginated.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.drafts_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str status: Filter the list of drafts by a particular status
        :return: DraftsRead
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.drafts_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.drafts_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def drafts_get_with_http_info(self, **kwargs):  # noqa: E501
        """List Drafts  # noqa: E501

        Gets a list of all drafts for your oranization. Up to 25 results returned before results are paginated.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.drafts_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str status: Filter the list of drafts by a particular status
        :return: DraftsRead
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['status']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method drafts_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'status' in params:
            query_params.append(('status', params['status']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.dyspatch.2019.10+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/drafts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DraftsRead',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
