# Dyspatch Python Client
# Introduction
The Dyspatch API is based on the REST paradigm and features resource based URLs
with standard HTTP response codes to indicate errors.

We use standard HTTP authentication and request verbs and all responses are
JSON formatted. See our [Implementation
Guide](https://docs.dyspatch.io/development/implementing_dyspatch/) for more
details on how to implement Dyspatch.

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 2019.10
- Package version: 4.0.0
- Build package: io.swagger.codegen.languages.PythonClientCodegen
For more information, please visit [https://docs.dyspatch.io](https://docs.dyspatch.io)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

```sh
pip install dyspatch-python
```

Then import the package:
```python
import dyspatch_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import dyspatch_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import dyspatch_client
from dyspatch_client.rest import ApiException
from pprint import pprint

# Configure API key authorization: Bearer
configuration = dyspatch_client.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = dyspatch_client.DraftsApi(dyspatch_client.ApiClient(configuration))
draft_id = 'draft_id_example' # str | A draft ID
target_language = 'target_language_example' # str | The type of templating language to compile as. Should only be used for visual templates.

try:
    # Get Draft by ID
    api_response = api_instance.drafts_draft_id_get(draft_id, target_language)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DraftsApi->drafts_draft_id_get: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://api.dyspatch.io*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DraftsApi* | [**delete_localization**](docs/DraftsApi.md#delete_localization) | **DELETE** /drafts/{draftId}/localizations/{languageId} | Remove a localization
*DraftsApi* | [**get_draft_by_id**](docs/DraftsApi.md#get_draft_by_id) | **GET** /drafts/{draftId} | Get Draft by ID
*DraftsApi* | [**get_draft_localization_keys**](docs/DraftsApi.md#get_draft_localization_keys) | **GET** /drafts/{draftId}/localizationKeys | Get localization keys
*DraftsApi* | [**get_drafts**](docs/DraftsApi.md#get_drafts) | **GET** /drafts | List Drafts
*DraftsApi* | [**get_localization_for_draft**](docs/DraftsApi.md#get_localization_for_draft) | **GET** /drafts/{draftId}/localizations | Get localizations on a draft
*DraftsApi* | [**save_localization**](docs/DraftsApi.md#save_localization) | **PUT** /drafts/{draftId}/localizations/{languageId} | Create or update a localization
*DraftsApi* | [**set_translation**](docs/DraftsApi.md#set_translation) | **PUT** /drafts/{draftId}/localizations/{languageId}/translations | Set translations for language
*DraftsApi* | [**submit_draft_for_approval**](docs/DraftsApi.md#submit_draft_for_approval) | **POST** /drafts/{draftId}/publishRequest | Submit the draft for approval
*LocalizationsApi* | [**get_localization_by_id**](docs/LocalizationsApi.md#get_localization_by_id) | **GET** /localizations/{localizationId} | Get Localization Object by ID
*TemplatesApi* | [**get_template_by_id**](docs/TemplatesApi.md#get_template_by_id) | **GET** /templates/{templateId} | Get Template by ID
*TemplatesApi* | [**get_templates**](docs/TemplatesApi.md#get_templates) | **GET** /templates | List Templates


## Documentation For Models

 - [APIError](docs/APIError.md)
 - [CompiledRead](docs/CompiledRead.md)
 - [Cursor](docs/Cursor.md)
 - [DraftMetaRead](docs/DraftMetaRead.md)
 - [DraftRead](docs/DraftRead.md)
 - [DraftsRead](docs/DraftsRead.md)
 - [InlineObject](docs/InlineObject.md)
 - [LocalizationKeyRead](docs/LocalizationKeyRead.md)
 - [LocalizationMetaRead](docs/LocalizationMetaRead.md)
 - [LocalizationRead](docs/LocalizationRead.md)
 - [TemplateMetaRead](docs/TemplateMetaRead.md)
 - [TemplateRead](docs/TemplateRead.md)
 - [TemplatesRead](docs/TemplatesRead.md)


## Documentation For Authorization


## Bearer

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Author

support@dyspatch.io
