# coding: utf-8

"""
    Dyspatch API

    # Introduction  The Dyspatch API is based on the REST paradigm, and features resource based URLs with standard HTTP response codes to indicate errors. We use standard HTTP authentication and request verbs, and all responses are JSON formatted. See our [Implementation Guide](https://docs.dyspatch.io/development/implementing_dyspatch/) for more details on how to implement Dyspatch.  ## API Client Libraries Dyspatch provides API Clients for popular languages and web frameworks.  - [Java](https://github.com/getdyspatch/dyspatch-java) - [Javascript](https://github.com/getdyspatch/dyspatch-javascript) - [Python](https://github.com/getdyspatch/dyspatch-python) - [C#](https://github.com/getdyspatch/dyspatch-dotnet) - [Go](https://github.com/getdyspatch/dyspatch-golang) - [Ruby](https://github.com/getdyspatch/dyspatch-ruby)    # noqa: E501

    The version of the OpenAPI document: 2019.10
    Contact: support@dyspatch.io
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from dyspatch_client.api_client import ApiClient
from dyspatch_client.exceptions import (
    ApiTypeError,
    ApiValueError
)


class TemplatesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_template_by_id(self, template_id, target_language, accept, **kwargs):  # noqa: E501
        """Get Template by ID  # noqa: E501

        Gets a template object with the matching ID. If the template has published content the \"compiled\" field will contain the template .  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_template_by_id(template_id, target_language, accept, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str template_id: A template ID (required)
        :param str target_language: The type of templating language to compile as. Should only be used for visual templates. (required)
        :param str accept: A version of the API that should be used for the request. For example, to use version \"2019.10\", set the value to \"application/vnd.dyspatch.2019.10+json\" (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TemplateRead
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_template_by_id_with_http_info(template_id, target_language, accept, **kwargs)  # noqa: E501

    def get_template_by_id_with_http_info(self, template_id, target_language, accept, **kwargs):  # noqa: E501
        """Get Template by ID  # noqa: E501

        Gets a template object with the matching ID. If the template has published content the \"compiled\" field will contain the template .  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_template_by_id_with_http_info(template_id, target_language, accept, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str template_id: A template ID (required)
        :param str target_language: The type of templating language to compile as. Should only be used for visual templates. (required)
        :param str accept: A version of the API that should be used for the request. For example, to use version \"2019.10\", set the value to \"application/vnd.dyspatch.2019.10+json\" (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TemplateRead, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['template_id', 'target_language', 'accept']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_template_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'template_id' is set
        if self.api_client.client_side_validation and ('template_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['template_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `template_id` when calling `get_template_by_id`")  # noqa: E501
        # verify the required parameter 'target_language' is set
        if self.api_client.client_side_validation and ('target_language' not in local_var_params or  # noqa: E501
                                                        local_var_params['target_language'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `target_language` when calling `get_template_by_id`")  # noqa: E501
        # verify the required parameter 'accept' is set
        if self.api_client.client_side_validation and ('accept' not in local_var_params or  # noqa: E501
                                                        local_var_params['accept'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `accept` when calling `get_template_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'template_id' in local_var_params:
            path_params['templateId'] = local_var_params['template_id']  # noqa: E501

        query_params = []
        if 'target_language' in local_var_params and local_var_params['target_language'] is not None:  # noqa: E501
            query_params.append(('targetLanguage', local_var_params['target_language']))  # noqa: E501

        header_params = {}
        if 'accept' in local_var_params:
            header_params['Accept'] = local_var_params['accept']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.dyspatch.2019.10+json', '*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/templates/{templateId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TemplateRead',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_templates(self, accept, **kwargs):  # noqa: E501
        """List Templates  # noqa: E501

        Gets a list of Template Metadata objects for all templates. Up to 25 results returned before results are paginated.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_templates(accept, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str accept: A version of the API that should be used for the request. For example, to use version \"2019.10\", set the value to \"application/vnd.dyspatch.2019.10+json\" (required)
        :param str cursor: A cursor value used to retrieve a specific page from a paginated result set.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TemplatesRead
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_templates_with_http_info(accept, **kwargs)  # noqa: E501

    def get_templates_with_http_info(self, accept, **kwargs):  # noqa: E501
        """List Templates  # noqa: E501

        Gets a list of Template Metadata objects for all templates. Up to 25 results returned before results are paginated.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_templates_with_http_info(accept, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str accept: A version of the API that should be used for the request. For example, to use version \"2019.10\", set the value to \"application/vnd.dyspatch.2019.10+json\" (required)
        :param str cursor: A cursor value used to retrieve a specific page from a paginated result set.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TemplatesRead, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['accept', 'cursor']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_templates" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'accept' is set
        if self.api_client.client_side_validation and ('accept' not in local_var_params or  # noqa: E501
                                                        local_var_params['accept'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `accept` when calling `get_templates`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'cursor' in local_var_params and local_var_params['cursor'] is not None:  # noqa: E501
            query_params.append(('cursor', local_var_params['cursor']))  # noqa: E501

        header_params = {}
        if 'accept' in local_var_params:
            header_params['Accept'] = local_var_params['accept']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.dyspatch.2019.10+json', '*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/templates', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TemplatesRead',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
