# coding: utf-8

"""
    Dyspatch API

    # Introduction  The Dyspatch API is based on the REST paradigm, and features resource based URLs with standard HTTP response codes to indicate errors. We use standard HTTP authentication and request verbs, and all responses are JSON formatted. See our [Implementation Guide](https://docs.dyspatch.io/development/implementing_dyspatch/) for more details on how to implement Dyspatch.  ## API Client Libraries Dyspatch provides API Clients for popular languages and web frameworks.  - [Java](https://github.com/getdyspatch/dyspatch-java) - [Javascript](https://github.com/getdyspatch/dyspatch-javascript) - [Python](https://github.com/getdyspatch/dyspatch-python) - [C#](https://github.com/getdyspatch/dyspatch-dotnet) - [Go](https://github.com/getdyspatch/dyspatch-golang) - [Ruby](https://github.com/getdyspatch/dyspatch-ruby)    # noqa: E501

    The version of the OpenAPI document: 2019.10
    Contact: support@dyspatch.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from dyspatch_client.configuration import Configuration


class CompiledRead(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'sender': 'str',
        'reply_to': 'str',
        'subject': 'str',
        'html': 'str',
        'text': 'str'
    }

    attribute_map = {
        'sender': 'sender',
        'reply_to': 'replyTo',
        'subject': 'subject',
        'html': 'html',
        'text': 'text'
    }

    def __init__(self, sender=None, reply_to=None, subject=None, html=None, text=None, local_vars_configuration=None):  # noqa: E501
        """CompiledRead - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._sender = None
        self._reply_to = None
        self._subject = None
        self._html = None
        self._text = None
        self.discriminator = None

        if sender is not None:
            self.sender = sender
        if reply_to is not None:
            self.reply_to = reply_to
        if subject is not None:
            self.subject = subject
        if html is not None:
            self.html = html
        if text is not None:
            self.text = text

    @property
    def sender(self):
        """Gets the sender of this CompiledRead.  # noqa: E501

        Sender address  # noqa: E501

        :return: The sender of this CompiledRead.  # noqa: E501
        :rtype: str
        """
        return self._sender

    @sender.setter
    def sender(self, sender):
        """Sets the sender of this CompiledRead.

        Sender address  # noqa: E501

        :param sender: The sender of this CompiledRead.  # noqa: E501
        :type: str
        """

        self._sender = sender

    @property
    def reply_to(self):
        """Gets the reply_to of this CompiledRead.  # noqa: E501

        Reply-To address  # noqa: E501

        :return: The reply_to of this CompiledRead.  # noqa: E501
        :rtype: str
        """
        return self._reply_to

    @reply_to.setter
    def reply_to(self, reply_to):
        """Sets the reply_to of this CompiledRead.

        Reply-To address  # noqa: E501

        :param reply_to: The reply_to of this CompiledRead.  # noqa: E501
        :type: str
        """

        self._reply_to = reply_to

    @property
    def subject(self):
        """Gets the subject of this CompiledRead.  # noqa: E501

        Base64 encoded template subject line  # noqa: E501

        :return: The subject of this CompiledRead.  # noqa: E501
        :rtype: str
        """
        return self._subject

    @subject.setter
    def subject(self, subject):
        """Sets the subject of this CompiledRead.

        Base64 encoded template subject line  # noqa: E501

        :param subject: The subject of this CompiledRead.  # noqa: E501
        :type: str
        """

        self._subject = subject

    @property
    def html(self):
        """Gets the html of this CompiledRead.  # noqa: E501

        Base64 encoded template HTML body  # noqa: E501

        :return: The html of this CompiledRead.  # noqa: E501
        :rtype: str
        """
        return self._html

    @html.setter
    def html(self, html):
        """Sets the html of this CompiledRead.

        Base64 encoded template HTML body  # noqa: E501

        :param html: The html of this CompiledRead.  # noqa: E501
        :type: str
        """

        self._html = html

    @property
    def text(self):
        """Gets the text of this CompiledRead.  # noqa: E501

        Base64 encoded template text body  # noqa: E501

        :return: The text of this CompiledRead.  # noqa: E501
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text):
        """Sets the text of this CompiledRead.

        Base64 encoded template text body  # noqa: E501

        :param text: The text of this CompiledRead.  # noqa: E501
        :type: str
        """

        self._text = text

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CompiledRead):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CompiledRead):
            return True

        return self.to_dict() != other.to_dict()
