# dyspatch-python
# Introduction

The Dyspatch API is based on the REST paradigm, and features resource based URLs with standard HTTP response
codes to indicate errors. We use standard HTTP authentication and request verbs, and all responses are JSON formatted.
See our [Implementation Guide](https://docs.dyspatch.io/development/implementing_dyspatch/) for more details on
how to implement Dyspatch.

## API Client Libraries
Dyspatch provides API Clients for popular languages and web frameworks.

- [Java](https://github.com/getdyspatch/dyspatch-java)
- [Javascript](https://github.com/getdyspatch/dyspatch-javascript)
- [Python](https://github.com/getdyspatch/dyspatch-python)
- [C#](https://github.com/getdyspatch/dyspatch-dotnet)
- [Go](https://github.com/getdyspatch/dyspatch-golang)
- [Ruby](https://github.com/getdyspatch/dyspatch-ruby)


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 2020.04
- Package version: 5.0.1
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://docs.dyspatch.io](https://docs.dyspatch.io)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import dyspatch_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import dyspatch_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import dyspatch_client
from dyspatch_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.dyspatch.io
# See configuration.py for a list of all supported configuration parameters.
configuration = dyspatch_client.Configuration(
    host = "https://api.dyspatch.io"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: Bearer
configuration = dyspatch_client.Configuration(
    host = "https://api.dyspatch.io",
    api_key = {
        'Authorization': 'YOUR_API_KEY'
    }
)
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'


# Enter a context with an instance of the API client
with dyspatch_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = dyspatch_client.DraftsApi(api_client)
    draft_id = 'draft_id_example' # str | A draft ID
language_id = 'language_id_example' # str | A language ID (eg: en-US)
accept = 'accept_example' # str | A version of the API that should be used for the request. For example, to use version \"2020.04\", set the value to \"application/vnd.dyspatch.2020.04+json\"

    try:
        # Remove a localization
        api_instance.delete_localization(draft_id, language_id, accept)
    except ApiException as e:
        print("Exception when calling DraftsApi->delete_localization: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *https://api.dyspatch.io*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DraftsApi* | [**delete_localization**](docs/DraftsApi.md#delete_localization) | **DELETE** /drafts/{draftId}/localizations/{languageId} | Remove a localization
*DraftsApi* | [**get_draft_by_id**](docs/DraftsApi.md#get_draft_by_id) | **GET** /drafts/{draftId} | Get Draft by ID
*DraftsApi* | [**get_draft_localization_keys**](docs/DraftsApi.md#get_draft_localization_keys) | **GET** /drafts/{draftId}/localizationKeys | Get localization keys
*DraftsApi* | [**get_drafts**](docs/DraftsApi.md#get_drafts) | **GET** /drafts | List Drafts
*DraftsApi* | [**get_localization_for_draft**](docs/DraftsApi.md#get_localization_for_draft) | **GET** /drafts/{draftId}/localizations | Get localizations on a draft
*DraftsApi* | [**save_localization**](docs/DraftsApi.md#save_localization) | **PUT** /drafts/{draftId}/localizations/{languageId} | Create or update a localization
*DraftsApi* | [**set_translation**](docs/DraftsApi.md#set_translation) | **PUT** /drafts/{draftId}/localizations/{languageId}/translations | Set translations for language
*DraftsApi* | [**submit_draft_for_approval**](docs/DraftsApi.md#submit_draft_for_approval) | **POST** /drafts/{draftId}/publishRequest | Submit the draft for approval
*LocalizationsApi* | [**get_localization_by_id**](docs/LocalizationsApi.md#get_localization_by_id) | **GET** /localizations/{localizationId} | Get Localization Object by ID
*TemplatesApi* | [**get_template_by_id**](docs/TemplatesApi.md#get_template_by_id) | **GET** /templates/{templateId} | Get Template by ID
*TemplatesApi* | [**get_templates**](docs/TemplatesApi.md#get_templates) | **GET** /templates | List Templates


## Documentation For Models

 - [APIError](docs/APIError.md)
 - [CompiledRead](docs/CompiledRead.md)
 - [Cursor](docs/Cursor.md)
 - [DraftMetaRead](docs/DraftMetaRead.md)
 - [DraftRead](docs/DraftRead.md)
 - [DraftsRead](docs/DraftsRead.md)
 - [InlineObject](docs/InlineObject.md)
 - [LocalizationKeyRead](docs/LocalizationKeyRead.md)
 - [LocalizationMetaRead](docs/LocalizationMetaRead.md)
 - [LocalizationRead](docs/LocalizationRead.md)
 - [TemplateMetaRead](docs/TemplateMetaRead.md)
 - [TemplateRead](docs/TemplateRead.md)
 - [TemplatesRead](docs/TemplatesRead.md)


## Documentation For Authorization


## Bearer

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Author

support@dyspatch.io


