# coding: utf-8

"""
    Dyspatch API

    # Introduction  The Dyspatch API is based on the REST paradigm, and features resource based URLs with standard HTTP response codes to indicate errors. We use standard HTTP authentication and request verbs, and all responses are JSON formatted. See our [Implementation Guide](https://docs.dyspatch.io/development/implementing_dyspatch/) for more details on how to implement Dyspatch.  ## API Client Libraries Dyspatch provides API Clients for popular languages and web frameworks.  - [Java](https://github.com/getdyspatch/dyspatch-java) - [Javascript](https://github.com/getdyspatch/dyspatch-javascript) - [Python](https://github.com/getdyspatch/dyspatch-python) - [C#](https://github.com/getdyspatch/dyspatch-dotnet) - [Go](https://github.com/getdyspatch/dyspatch-golang) - [Ruby](https://github.com/getdyspatch/dyspatch-ruby)   # noqa: E501

    The version of the OpenAPI document: 2020.04
    Contact: support@dyspatch.io
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from dyspatch_client.api_client import ApiClient
from dyspatch_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class DraftsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_localization(self, draft_id, language_id, accept, **kwargs):  # noqa: E501
        """Remove a localization  # noqa: E501

        Deletes the localization with the given language ID if it exists  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_localization(draft_id, language_id, accept, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str draft_id: A draft ID (required)
        :param str language_id: A language ID (eg: en-US) (required)
        :param str accept: A version of the API that should be used for the request. For example, to use version \"2020.04\", set the value to \"application/vnd.dyspatch.2020.04+json\" (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_localization_with_http_info(draft_id, language_id, accept, **kwargs)  # noqa: E501

    def delete_localization_with_http_info(self, draft_id, language_id, accept, **kwargs):  # noqa: E501
        """Remove a localization  # noqa: E501

        Deletes the localization with the given language ID if it exists  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_localization_with_http_info(draft_id, language_id, accept, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str draft_id: A draft ID (required)
        :param str language_id: A language ID (eg: en-US) (required)
        :param str accept: A version of the API that should be used for the request. For example, to use version \"2020.04\", set the value to \"application/vnd.dyspatch.2020.04+json\" (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'draft_id',
            'language_id',
            'accept'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_localization" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'draft_id' is set
        if self.api_client.client_side_validation and ('draft_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['draft_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `draft_id` when calling `delete_localization`")  # noqa: E501
        # verify the required parameter 'language_id' is set
        if self.api_client.client_side_validation and ('language_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['language_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `language_id` when calling `delete_localization`")  # noqa: E501
        # verify the required parameter 'accept' is set
        if self.api_client.client_side_validation and ('accept' not in local_var_params or  # noqa: E501
                                                        local_var_params['accept'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `accept` when calling `delete_localization`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'draft_id' in local_var_params:
            path_params['draftId'] = local_var_params['draft_id']  # noqa: E501
        if 'language_id' in local_var_params:
            path_params['languageId'] = local_var_params['language_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'accept' in local_var_params:
            header_params['Accept'] = local_var_params['accept']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/drafts/{draftId}/localizations/{languageId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_draft_by_id(self, draft_id, target_language, accept, **kwargs):  # noqa: E501
        """Get Draft by ID  # noqa: E501

        Gets a draft object with the matching ID. The \"compiled\" field will contain the template in the default, unlocalized form.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_draft_by_id(draft_id, target_language, accept, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str draft_id: A draft ID (required)
        :param str target_language: The type of templating language to compile as. Should only be used for visual templates. (required)
        :param str accept: A version of the API that should be used for the request. For example, to use version \"2020.04\", set the value to \"application/vnd.dyspatch.2020.04+json\" (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DraftRead
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_draft_by_id_with_http_info(draft_id, target_language, accept, **kwargs)  # noqa: E501

    def get_draft_by_id_with_http_info(self, draft_id, target_language, accept, **kwargs):  # noqa: E501
        """Get Draft by ID  # noqa: E501

        Gets a draft object with the matching ID. The \"compiled\" field will contain the template in the default, unlocalized form.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_draft_by_id_with_http_info(draft_id, target_language, accept, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str draft_id: A draft ID (required)
        :param str target_language: The type of templating language to compile as. Should only be used for visual templates. (required)
        :param str accept: A version of the API that should be used for the request. For example, to use version \"2020.04\", set the value to \"application/vnd.dyspatch.2020.04+json\" (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DraftRead, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'draft_id',
            'target_language',
            'accept'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_draft_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'draft_id' is set
        if self.api_client.client_side_validation and ('draft_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['draft_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `draft_id` when calling `get_draft_by_id`")  # noqa: E501
        # verify the required parameter 'target_language' is set
        if self.api_client.client_side_validation and ('target_language' not in local_var_params or  # noqa: E501
                                                        local_var_params['target_language'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `target_language` when calling `get_draft_by_id`")  # noqa: E501
        # verify the required parameter 'accept' is set
        if self.api_client.client_side_validation and ('accept' not in local_var_params or  # noqa: E501
                                                        local_var_params['accept'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `accept` when calling `get_draft_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'draft_id' in local_var_params:
            path_params['draftId'] = local_var_params['draft_id']  # noqa: E501

        query_params = []
        if 'target_language' in local_var_params and local_var_params['target_language'] is not None:  # noqa: E501
            query_params.append(('targetLanguage', local_var_params['target_language']))  # noqa: E501

        header_params = {}
        if 'accept' in local_var_params:
            header_params['Accept'] = local_var_params['accept']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.dyspatch.2020.04+json', '*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/drafts/{draftId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DraftRead',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_draft_localization_keys(self, draft_id, accept, **kwargs):  # noqa: E501
        """Get localization keys  # noqa: E501

        Returns the list of values that need to be translated for the draft. Set the `Accept` header to `application/vnd.dyspatch.2020.04+json` to get a JSON object, or `text/vnd.dyspatch.2020.04+x-gettext-translation` to get the POT file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_draft_localization_keys(draft_id, accept, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str draft_id: A draft ID (required)
        :param str accept: A version of the API that should be used for the request. For example, to use version \"2020.04\", set the value to \"application/vnd.dyspatch.2020.04+json\" (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[LocalizationKeyRead]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_draft_localization_keys_with_http_info(draft_id, accept, **kwargs)  # noqa: E501

    def get_draft_localization_keys_with_http_info(self, draft_id, accept, **kwargs):  # noqa: E501
        """Get localization keys  # noqa: E501

        Returns the list of values that need to be translated for the draft. Set the `Accept` header to `application/vnd.dyspatch.2020.04+json` to get a JSON object, or `text/vnd.dyspatch.2020.04+x-gettext-translation` to get the POT file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_draft_localization_keys_with_http_info(draft_id, accept, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str draft_id: A draft ID (required)
        :param str accept: A version of the API that should be used for the request. For example, to use version \"2020.04\", set the value to \"application/vnd.dyspatch.2020.04+json\" (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[LocalizationKeyRead], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'draft_id',
            'accept'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_draft_localization_keys" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'draft_id' is set
        if self.api_client.client_side_validation and ('draft_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['draft_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `draft_id` when calling `get_draft_localization_keys`")  # noqa: E501
        # verify the required parameter 'accept' is set
        if self.api_client.client_side_validation and ('accept' not in local_var_params or  # noqa: E501
                                                        local_var_params['accept'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `accept` when calling `get_draft_localization_keys`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'draft_id' in local_var_params:
            path_params['draftId'] = local_var_params['draft_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'accept' in local_var_params:
            header_params['Accept'] = local_var_params['accept']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.dyspatch.2020.04+json', '*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/drafts/{draftId}/localizationKeys', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[LocalizationKeyRead]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_drafts(self, accept, **kwargs):  # noqa: E501
        """List Drafts  # noqa: E501

        Returns all drafts for your organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_drafts(accept, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str accept: A version of the API that should be used for the request. For example, to use version \"2020.04\", set the value to \"application/vnd.dyspatch.2020.04+json\" (required)
        :param str cursor: A cursor value used to retrieve a specific page from a paginated result set.
        :param str status: Filter the list of drafts by a particular status
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DraftsRead
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_drafts_with_http_info(accept, **kwargs)  # noqa: E501

    def get_drafts_with_http_info(self, accept, **kwargs):  # noqa: E501
        """List Drafts  # noqa: E501

        Returns all drafts for your organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_drafts_with_http_info(accept, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str accept: A version of the API that should be used for the request. For example, to use version \"2020.04\", set the value to \"application/vnd.dyspatch.2020.04+json\" (required)
        :param str cursor: A cursor value used to retrieve a specific page from a paginated result set.
        :param str status: Filter the list of drafts by a particular status
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DraftsRead, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'accept',
            'cursor',
            'status'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_drafts" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'accept' is set
        if self.api_client.client_side_validation and ('accept' not in local_var_params or  # noqa: E501
                                                        local_var_params['accept'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `accept` when calling `get_drafts`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'cursor' in local_var_params and local_var_params['cursor'] is not None:  # noqa: E501
            query_params.append(('cursor', local_var_params['cursor']))  # noqa: E501
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501

        header_params = {}
        if 'accept' in local_var_params:
            header_params['Accept'] = local_var_params['accept']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.dyspatch.2020.04+json', '*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/drafts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DraftsRead',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_localization_for_draft(self, draft_id, accept, **kwargs):  # noqa: E501
        """Get localizations on a draft  # noqa: E501

        Returns localization metadata for the draft  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_localization_for_draft(draft_id, accept, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str draft_id: A draft ID (required)
        :param str accept: A version of the API that should be used for the request. For example, to use version \"2020.04\", set the value to \"application/vnd.dyspatch.2020.04+json\" (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[LocalizationMetaRead]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_localization_for_draft_with_http_info(draft_id, accept, **kwargs)  # noqa: E501

    def get_localization_for_draft_with_http_info(self, draft_id, accept, **kwargs):  # noqa: E501
        """Get localizations on a draft  # noqa: E501

        Returns localization metadata for the draft  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_localization_for_draft_with_http_info(draft_id, accept, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str draft_id: A draft ID (required)
        :param str accept: A version of the API that should be used for the request. For example, to use version \"2020.04\", set the value to \"application/vnd.dyspatch.2020.04+json\" (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[LocalizationMetaRead], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'draft_id',
            'accept'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_localization_for_draft" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'draft_id' is set
        if self.api_client.client_side_validation and ('draft_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['draft_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `draft_id` when calling `get_localization_for_draft`")  # noqa: E501
        # verify the required parameter 'accept' is set
        if self.api_client.client_side_validation and ('accept' not in local_var_params or  # noqa: E501
                                                        local_var_params['accept'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `accept` when calling `get_localization_for_draft`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'draft_id' in local_var_params:
            path_params['draftId'] = local_var_params['draft_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'accept' in local_var_params:
            header_params['Accept'] = local_var_params['accept']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.dyspatch.2020.04+json', '*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/drafts/{draftId}/localizations', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[LocalizationMetaRead]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def save_localization(self, draft_id, language_id, accept, inline_object, **kwargs):  # noqa: E501
        """Create or update a localization  # noqa: E501

        Inserts a localization or sets the name on an existing localization that already uses the languageId  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_localization(draft_id, language_id, accept, inline_object, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str draft_id: A draft ID (required)
        :param str language_id: A language ID (eg: en-US) (required)
        :param str accept: A version of the API that should be used for the request. For example, to use version \"2020.04\", set the value to \"application/vnd.dyspatch.2020.04+json\" (required)
        :param InlineObject inline_object: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.save_localization_with_http_info(draft_id, language_id, accept, inline_object, **kwargs)  # noqa: E501

    def save_localization_with_http_info(self, draft_id, language_id, accept, inline_object, **kwargs):  # noqa: E501
        """Create or update a localization  # noqa: E501

        Inserts a localization or sets the name on an existing localization that already uses the languageId  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_localization_with_http_info(draft_id, language_id, accept, inline_object, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str draft_id: A draft ID (required)
        :param str language_id: A language ID (eg: en-US) (required)
        :param str accept: A version of the API that should be used for the request. For example, to use version \"2020.04\", set the value to \"application/vnd.dyspatch.2020.04+json\" (required)
        :param InlineObject inline_object: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'draft_id',
            'language_id',
            'accept',
            'inline_object'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method save_localization" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'draft_id' is set
        if self.api_client.client_side_validation and ('draft_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['draft_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `draft_id` when calling `save_localization`")  # noqa: E501
        # verify the required parameter 'language_id' is set
        if self.api_client.client_side_validation and ('language_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['language_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `language_id` when calling `save_localization`")  # noqa: E501
        # verify the required parameter 'accept' is set
        if self.api_client.client_side_validation and ('accept' not in local_var_params or  # noqa: E501
                                                        local_var_params['accept'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `accept` when calling `save_localization`")  # noqa: E501
        # verify the required parameter 'inline_object' is set
        if self.api_client.client_side_validation and ('inline_object' not in local_var_params or  # noqa: E501
                                                        local_var_params['inline_object'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `inline_object` when calling `save_localization`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'draft_id' in local_var_params:
            path_params['draftId'] = local_var_params['draft_id']  # noqa: E501
        if 'language_id' in local_var_params:
            path_params['languageId'] = local_var_params['language_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'accept' in local_var_params:
            header_params['Accept'] = local_var_params['accept']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'inline_object' in local_var_params:
            body_params = local_var_params['inline_object']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/drafts/{draftId}/localizations/{languageId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_translation(self, draft_id, language_id, accept, request_body, **kwargs):  # noqa: E501
        """Set translations for language  # noqa: E501

        Completely replaces any existing translations for the given language with those provided in request body. Variables embedded in keys or values are expected to be in the format `%(my_variable)s` and will automatically convert to the correct Dyspatch format depending on the type of template. Accepts key/value pairs in JSON format or in gettext PO file format. For JSON set `Content-Type` header to `application/json`. For gettext PO format set `Content-Type` header to `text/x-gettext-translation`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_translation(draft_id, language_id, accept, request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str draft_id: A draft ID (required)
        :param str language_id: A language ID (eg: en-US) (required)
        :param str accept: A version of the API that should be used for the request. For example, to use version \"2020.04\", set the value to \"application/vnd.dyspatch.2020.04+json\" (required)
        :param dict(str, str) request_body: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.set_translation_with_http_info(draft_id, language_id, accept, request_body, **kwargs)  # noqa: E501

    def set_translation_with_http_info(self, draft_id, language_id, accept, request_body, **kwargs):  # noqa: E501
        """Set translations for language  # noqa: E501

        Completely replaces any existing translations for the given language with those provided in request body. Variables embedded in keys or values are expected to be in the format `%(my_variable)s` and will automatically convert to the correct Dyspatch format depending on the type of template. Accepts key/value pairs in JSON format or in gettext PO file format. For JSON set `Content-Type` header to `application/json`. For gettext PO format set `Content-Type` header to `text/x-gettext-translation`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_translation_with_http_info(draft_id, language_id, accept, request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str draft_id: A draft ID (required)
        :param str language_id: A language ID (eg: en-US) (required)
        :param str accept: A version of the API that should be used for the request. For example, to use version \"2020.04\", set the value to \"application/vnd.dyspatch.2020.04+json\" (required)
        :param dict(str, str) request_body: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'draft_id',
            'language_id',
            'accept',
            'request_body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_translation" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'draft_id' is set
        if self.api_client.client_side_validation and ('draft_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['draft_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `draft_id` when calling `set_translation`")  # noqa: E501
        # verify the required parameter 'language_id' is set
        if self.api_client.client_side_validation and ('language_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['language_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `language_id` when calling `set_translation`")  # noqa: E501
        # verify the required parameter 'accept' is set
        if self.api_client.client_side_validation and ('accept' not in local_var_params or  # noqa: E501
                                                        local_var_params['accept'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `accept` when calling `set_translation`")  # noqa: E501
        # verify the required parameter 'request_body' is set
        if self.api_client.client_side_validation and ('request_body' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_body` when calling `set_translation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'draft_id' in local_var_params:
            path_params['draftId'] = local_var_params['draft_id']  # noqa: E501
        if 'language_id' in local_var_params:
            path_params['languageId'] = local_var_params['language_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'accept' in local_var_params:
            header_params['Accept'] = local_var_params['accept']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request_body' in local_var_params:
            body_params = local_var_params['request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.dyspatch.2020.04+json', '*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/drafts/{draftId}/localizations/{languageId}/translations', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def submit_draft_for_approval(self, draft_id, accept, **kwargs):  # noqa: E501
        """Submit the draft for approval  # noqa: E501

        Moves the draft into submitted state.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.submit_draft_for_approval(draft_id, accept, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str draft_id: A draft ID (required)
        :param str accept: A version of the API that should be used for the request. For example, to use version \"2020.04\", set the value to \"application/vnd.dyspatch.2020.04+json\" (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.submit_draft_for_approval_with_http_info(draft_id, accept, **kwargs)  # noqa: E501

    def submit_draft_for_approval_with_http_info(self, draft_id, accept, **kwargs):  # noqa: E501
        """Submit the draft for approval  # noqa: E501

        Moves the draft into submitted state.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.submit_draft_for_approval_with_http_info(draft_id, accept, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str draft_id: A draft ID (required)
        :param str accept: A version of the API that should be used for the request. For example, to use version \"2020.04\", set the value to \"application/vnd.dyspatch.2020.04+json\" (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'draft_id',
            'accept'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method submit_draft_for_approval" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'draft_id' is set
        if self.api_client.client_side_validation and ('draft_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['draft_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `draft_id` when calling `submit_draft_for_approval`")  # noqa: E501
        # verify the required parameter 'accept' is set
        if self.api_client.client_side_validation and ('accept' not in local_var_params or  # noqa: E501
                                                        local_var_params['accept'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `accept` when calling `submit_draft_for_approval`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'draft_id' in local_var_params:
            path_params['draftId'] = local_var_params['draft_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'accept' in local_var_params:
            header_params['Accept'] = local_var_params['accept']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.dyspatch.2020.04+json', '*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/drafts/{draftId}/publishRequest', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
