# coding: utf-8

"""
    Dyspatch API

    # Introduction  The Dyspatch API is based on the REST paradigm, and features resource based URLs with standard HTTP response codes to indicate errors. We use standard HTTP authentication and request verbs, and all responses are JSON formatted. See our [Implementation Guide](https://docs.dyspatch.io/development/implementing_dyspatch/) for more details on how to implement Dyspatch.  ## API Client Libraries Dyspatch provides API Clients for popular languages and web frameworks.  - [Java](https://github.com/getdyspatch/dyspatch-java) - [Javascript](https://github.com/getdyspatch/dyspatch-javascript) - [Python](https://github.com/getdyspatch/dyspatch-python) - [C#](https://github.com/getdyspatch/dyspatch-dotnet) - [Go](https://github.com/getdyspatch/dyspatch-golang) - [Ruby](https://github.com/getdyspatch/dyspatch-ruby)   # noqa: E501

    The version of the OpenAPI document: 2020.11
    Contact: support@dyspatch.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from dyspatch_client.configuration import Configuration


class LocalizationMetaRead(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'name': 'str',
        'url': 'str',
        'locale_group': 'str',
        'languages': 'list[str]'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'url': 'url',
        'locale_group': 'localeGroup',
        'languages': 'languages'
    }

    def __init__(self, id=None, name=None, url=None, locale_group=None, languages=None, local_vars_configuration=None):  # noqa: E501
        """LocalizationMetaRead - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._name = None
        self._url = None
        self._locale_group = None
        self._languages = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if name is not None:
            self.name = name
        if url is not None:
            self.url = url
        if locale_group is not None:
            self.locale_group = locale_group
        if languages is not None:
            self.languages = languages

    @property
    def id(self):
        """Gets the id of this LocalizationMetaRead.  # noqa: E501

        An opaque, unique identifier for a localization  # noqa: E501

        :return: The id of this LocalizationMetaRead.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this LocalizationMetaRead.

        An opaque, unique identifier for a localization  # noqa: E501

        :param id: The id of this LocalizationMetaRead.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def name(self):
        """Gets the name of this LocalizationMetaRead.  # noqa: E501

        The user-specified name of a localization  # noqa: E501

        :return: The name of this LocalizationMetaRead.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this LocalizationMetaRead.

        The user-specified name of a localization  # noqa: E501

        :param name: The name of this LocalizationMetaRead.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def url(self):
        """Gets the url of this LocalizationMetaRead.  # noqa: E501

        The API url for a specific localization  # noqa: E501

        :return: The url of this LocalizationMetaRead.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this LocalizationMetaRead.

        The API url for a specific localization  # noqa: E501

        :param url: The url of this LocalizationMetaRead.  # noqa: E501
        :type: str
        """

        self._url = url

    @property
    def locale_group(self):
        """Gets the locale_group of this LocalizationMetaRead.  # noqa: E501

        the locale group this localization belongs to, if this field is empty the localization does not belong to any locale group  # noqa: E501

        :return: The locale_group of this LocalizationMetaRead.  # noqa: E501
        :rtype: str
        """
        return self._locale_group

    @locale_group.setter
    def locale_group(self, locale_group):
        """Sets the locale_group of this LocalizationMetaRead.

        the locale group this localization belongs to, if this field is empty the localization does not belong to any locale group  # noqa: E501

        :param locale_group: The locale_group of this LocalizationMetaRead.  # noqa: E501
        :type: str
        """

        self._locale_group = locale_group

    @property
    def languages(self):
        """Gets the languages of this LocalizationMetaRead.  # noqa: E501

        a list of locale codes that are available in the localization. See [supported languages](https://docs.dyspatch.io/localization/supported_languages/) for an exhaustive list of locale codes.   # noqa: E501

        :return: The languages of this LocalizationMetaRead.  # noqa: E501
        :rtype: list[str]
        """
        return self._languages

    @languages.setter
    def languages(self, languages):
        """Sets the languages of this LocalizationMetaRead.

        a list of locale codes that are available in the localization. See [supported languages](https://docs.dyspatch.io/localization/supported_languages/) for an exhaustive list of locale codes.   # noqa: E501

        :param languages: The languages of this LocalizationMetaRead.  # noqa: E501
        :type: list[str]
        """

        self._languages = languages

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LocalizationMetaRead):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, LocalizationMetaRead):
            return True

        return self.to_dict() != other.to_dict()
