/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.stats;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.decompiler.code.InstructionSequence;
import org.jetbrains.java.decompiler.main.CancellationManager;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.StrongConnectivityHelper;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DoStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DummyExitStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SwitchStatement;
import org.jetbrains.java.decompiler.struct.match.IMatchable;
import org.jetbrains.java.decompiler.struct.match.MatchEngine;
import org.jetbrains.java.decompiler.struct.match.MatchNode;
import org.jetbrains.java.decompiler.util.StartEndPair;
import org.jetbrains.java.decompiler.util.TextBuffer;
import org.jetbrains.java.decompiler.util.TextUtil;
import org.jetbrains.java.decompiler.util.VBStyleCollection;

public abstract class Statement
implements IMatchable {
    public StatementType type;
    public int id;
    private final Map<StatEdge.EdgeType, List<StatEdge>> mapSuccEdges = new HashMap<StatEdge.EdgeType, List<StatEdge>>();
    private final Map<StatEdge.EdgeType, List<StatEdge>> mapPredEdges = new HashMap<StatEdge.EdgeType, List<StatEdge>>();
    private final Map<StatEdge.EdgeType, List<Statement>> mapSuccStates = new HashMap<StatEdge.EdgeType, List<Statement>>();
    private final Map<StatEdge.EdgeType, List<Statement>> mapPredStates = new HashMap<StatEdge.EdgeType, List<Statement>>();
    private final HashSet<StatEdge> labelEdges = new HashSet();
    private boolean copied = false;
    protected final VBStyleCollection<Statement, Integer> stats = new VBStyleCollection();
    protected Statement parent;
    protected Statement first;
    protected List<Exprent> exprents;
    protected final List<Exprent> varDefinitions = new ArrayList<Exprent>();
    protected Statement post;
    protected StatementType lastBasicType = StatementType.GENERAL;
    protected boolean isMonitorEnter;
    protected boolean containsMonitorExit;
    protected HashSet<Statement> continueSet = new HashSet();
    private final CancellationManager cancellationManager = DecompilerContext.getCancellationManager();
    private StartEndPair endpoints;

    Statement(@NotNull StatementType type) {
        this.id = DecompilerContext.getCounterContainer().getCounterAndIncrement(0);
        this.type = type;
        this.cancellationManager.checkCanceled();
    }

    Statement(@NotNull StatementType type, int id) {
        this.id = DecompilerContext.getCounterContainer().getCounterAndIncrement(0);
        this.type = type;
        this.id = id;
        this.cancellationManager.checkCanceled();
    }

    public void clearTempInformation() {
        this.post = null;
        this.continueSet = null;
        this.copied = false;
        this.isMonitorEnter = false;
        this.containsMonitorExit = false;
        Statement.processMap(this.mapSuccEdges);
        Statement.processMap(this.mapPredEdges);
        Statement.processMap(this.mapSuccStates);
        Statement.processMap(this.mapPredStates);
    }

    private static <T> void processMap(Map<StatEdge.EdgeType, List<T>> map) {
        map.remove(StatEdge.EdgeType.EXCEPTION);
        List<T> lst = map.get(StatEdge.EdgeType.DIRECT_ALL);
        if (lst != null) {
            map.put(StatEdge.EdgeType.ALL, new ArrayList<T>(lst));
        } else {
            map.remove(StatEdge.EdgeType.ALL);
        }
    }

    public void collapseNodesToStatement(Statement stat) {
        this.cancellationManager.checkCanceled();
        Statement head = stat.getFirst();
        Statement post = stat.getPost();
        VBStyleCollection<Statement, Integer> setNodes = stat.getStats();
        if (post != null) {
            for (StatEdge edge : post.getEdges(StatEdge.EdgeType.DIRECT_ALL, StatEdge.EdgeDirection.BACKWARD)) {
                if (!stat.containsStatementStrict(edge.getSource())) continue;
                edge.getSource().changeEdgeType(StatEdge.EdgeDirection.FORWARD, edge, StatEdge.EdgeType.BREAK);
                stat.addLabeledEdge(edge);
            }
        }
        for (StatEdge prededge : head.getAllPredecessorEdges()) {
            this.cancellationManager.checkCanceled();
            if (prededge.getType() != StatEdge.EdgeType.EXCEPTION && stat.containsStatementStrict(prededge.getSource())) {
                prededge.getSource().changeEdgeType(StatEdge.EdgeDirection.FORWARD, prededge, StatEdge.EdgeType.CONTINUE);
                stat.addLabeledEdge(prededge);
            }
            head.removePredecessor(prededge);
            prededge.getSource().changeEdgeNode(StatEdge.EdgeDirection.FORWARD, prededge, stat);
            stat.addPredecessor(prededge);
        }
        if (setNodes.containsKey(this.first.id)) {
            this.first = stat;
        }
        HashSet<Statement> setHandlers = new HashSet<Statement>(head.getNeighbours(StatEdge.EdgeType.EXCEPTION, StatEdge.EdgeDirection.FORWARD));
        for (Statement node : setNodes) {
            setHandlers.retainAll(node.getNeighbours(StatEdge.EdgeType.EXCEPTION, StatEdge.EdgeDirection.FORWARD));
        }
        if (!setHandlers.isEmpty()) {
            for (StatEdge edge : head.getEdges(StatEdge.EdgeType.EXCEPTION, StatEdge.EdgeDirection.FORWARD)) {
                Statement handler = edge.getDestination();
                if (!setHandlers.contains(handler) || setNodes.containsKey(handler.id)) continue;
                stat.addSuccessor(new StatEdge(stat, handler, edge.getExceptions()));
            }
            for (Statement node : setNodes) {
                for (StatEdge edge : node.getEdges(StatEdge.EdgeType.EXCEPTION, StatEdge.EdgeDirection.FORWARD)) {
                    if (!setHandlers.contains(edge.getDestination())) continue;
                    node.removeSuccessor(edge);
                }
            }
        }
        if (post != null && !stat.getNeighbours(StatEdge.EdgeType.EXCEPTION, StatEdge.EdgeDirection.FORWARD).contains(post)) {
            stat.addSuccessor(new StatEdge(StatEdge.EdgeType.REGULAR, stat, post));
        }
        for (Statement st : setNodes) {
            this.stats.removeWithKey(st.id);
        }
        this.stats.addWithKey(stat, stat.id);
        stat.setAllParent();
        stat.setParent(this);
        stat.buildContinueSet();
        stat.buildMonitorFlags();
        if (stat.type == StatementType.SWITCH) {
            ((SwitchStatement)stat).sortEdgesAndNodes();
        }
    }

    public void setAllParent() {
        for (Statement st : this.stats) {
            st.setParent(this);
        }
    }

    public void addLabeledEdge(StatEdge edge) {
        if (edge.closure != null) {
            edge.closure.getLabelEdges().remove(edge);
        }
        edge.closure = this;
        this.getLabelEdges().add(edge);
    }

    private void addEdgeDirectInternal(StatEdge.EdgeDirection direction, StatEdge edge, StatEdge.EdgeType edgetype) {
        Map<StatEdge.EdgeType, List<StatEdge>> mapEdges = direction == StatEdge.EdgeDirection.BACKWARD ? this.mapPredEdges : this.mapSuccEdges;
        Map<StatEdge.EdgeType, List<Statement>> mapStates = direction == StatEdge.EdgeDirection.BACKWARD ? this.mapPredStates : this.mapSuccStates;
        mapEdges.computeIfAbsent(edgetype, k -> new ArrayList()).add(edge);
        mapStates.computeIfAbsent(edgetype, k -> new ArrayList()).add(direction == StatEdge.EdgeDirection.BACKWARD ? edge.getSource() : edge.getDestination());
    }

    private void addEdgeInternal(StatEdge.EdgeDirection direction, StatEdge edge) {
        StatEdge.EdgeType type = edge.getType();
        StatEdge.EdgeType[] arrtypes = type == StatEdge.EdgeType.EXCEPTION ? new StatEdge.EdgeType[]{StatEdge.EdgeType.ALL, StatEdge.EdgeType.EXCEPTION} : new StatEdge.EdgeType[]{StatEdge.EdgeType.ALL, StatEdge.EdgeType.DIRECT_ALL, type};
        for (StatEdge.EdgeType edgetype : arrtypes) {
            this.addEdgeDirectInternal(direction, edge, edgetype);
        }
    }

    private void removeEdgeDirectInternal(StatEdge.EdgeDirection direction, StatEdge edge, StatEdge.EdgeType edgetype) {
        int index;
        Map<StatEdge.EdgeType, List<StatEdge>> mapEdges = direction == StatEdge.EdgeDirection.BACKWARD ? this.mapPredEdges : this.mapSuccEdges;
        Map<StatEdge.EdgeType, List<Statement>> mapStates = direction == StatEdge.EdgeDirection.BACKWARD ? this.mapPredStates : this.mapSuccStates;
        List<StatEdge> lst = mapEdges.get(edgetype);
        if (lst != null && (index = lst.indexOf(edge)) >= 0) {
            lst.remove(index);
            mapStates.get(edgetype).remove(index);
        }
    }

    private void removeEdgeInternal(StatEdge.EdgeDirection direction, StatEdge edge) {
        StatEdge.EdgeType type = edge.getType();
        StatEdge.EdgeType[] arrtypes = type == StatEdge.EdgeType.EXCEPTION ? new StatEdge.EdgeType[]{StatEdge.EdgeType.ALL, StatEdge.EdgeType.EXCEPTION} : new StatEdge.EdgeType[]{StatEdge.EdgeType.ALL, StatEdge.EdgeType.DIRECT_ALL, type};
        for (StatEdge.EdgeType edgetype : arrtypes) {
            this.removeEdgeDirectInternal(direction, edge, edgetype);
        }
    }

    public void addPredecessor(StatEdge edge) {
        this.addEdgeInternal(StatEdge.EdgeDirection.BACKWARD, edge);
    }

    public void removePredecessor(StatEdge edge) {
        if (edge == null) {
            return;
        }
        this.removeEdgeInternal(StatEdge.EdgeDirection.BACKWARD, edge);
    }

    public void addSuccessor(StatEdge edge) {
        this.addEdgeInternal(StatEdge.EdgeDirection.FORWARD, edge);
        if (edge.closure != null) {
            edge.closure.getLabelEdges().add(edge);
        }
        edge.getDestination().addPredecessor(edge);
    }

    public void removeSuccessor(StatEdge edge) {
        if (edge == null) {
            return;
        }
        this.removeEdgeInternal(StatEdge.EdgeDirection.FORWARD, edge);
        if (edge.closure != null) {
            edge.closure.getLabelEdges().remove(edge);
        }
        if (edge.getDestination() != null) {
            edge.getDestination().removePredecessor(edge);
        }
    }

    public void removeAllSuccessors(Statement stat) {
        if (stat == null) {
            return;
        }
        for (StatEdge edge : this.getAllSuccessorEdges()) {
            if (edge.getDestination() != stat) continue;
            this.removeSuccessor(edge);
        }
    }

    public HashSet<Statement> buildContinueSet() {
        this.cancellationManager.checkCanceled();
        this.continueSet.clear();
        for (Statement st : this.stats) {
            this.continueSet.addAll(st.buildContinueSet());
            if (st == this.first) continue;
            this.continueSet.remove(st.getBasichead());
        }
        for (StatEdge edge : this.getEdges(StatEdge.EdgeType.CONTINUE, StatEdge.EdgeDirection.FORWARD)) {
            this.continueSet.add(edge.getDestination().getBasichead());
        }
        if (this.type == StatementType.DO) {
            this.continueSet.remove(this.first.getBasichead());
        }
        return this.continueSet;
    }

    public void buildMonitorFlags() {
        for (Statement st : this.stats) {
            st.buildMonitorFlags();
        }
        switch (this.type.ordinal()) {
            case 5: {
                BasicBlockStatement bblock = (BasicBlockStatement)this;
                InstructionSequence seq = bblock.getBlock().getSeq();
                if (seq == null || seq.isEmpty()) break;
                for (int i = 0; i < seq.length(); ++i) {
                    if (seq.getInstr((int)i).opcode != 195) continue;
                    this.containsMonitorExit = true;
                    break;
                }
                this.isMonitorEnter = seq.getLastInstr().opcode == 194;
                break;
            }
            case 1: 
            case 11: {
                this.containsMonitorExit = false;
                for (Statement st : this.stats) {
                    this.containsMonitorExit |= st.isContainsMonitorExit();
                }
                break;
            }
            case 0: 
            case 6: 
            case 9: {
                break;
            }
            default: {
                this.containsMonitorExit = false;
                for (Statement st : this.stats) {
                    this.containsMonitorExit |= st.isContainsMonitorExit();
                }
            }
        }
    }

    public List<Statement> getReversePostOrderList() {
        return this.getReversePostOrderList(this.first);
    }

    public List<Statement> getReversePostOrderList(Statement stat) {
        this.cancellationManager.checkCanceled();
        ArrayList<Statement> res = new ArrayList<Statement>();
        Statement.addToReversePostOrderListIterative(stat, res);
        return res;
    }

    public List<Statement> getPostReversePostOrderList() {
        return this.getPostReversePostOrderList(null);
    }

    public List<Statement> getPostReversePostOrderList(List<Statement> lstexits) {
        this.cancellationManager.checkCanceled();
        ArrayList<Statement> res = new ArrayList<Statement>();
        if (lstexits == null) {
            lstexits = new StrongConnectivityHelper(this).getExitReps();
        }
        HashSet setVisited = new HashSet();
        for (Statement exit : lstexits) {
            this.cancellationManager.checkCanceled();
            Statement.addToPostReversePostOrderList(exit, res, setVisited);
        }
        if (res.size() != this.stats.size()) {
            throw new RuntimeException("computing post reverse post order failed!");
        }
        return res;
    }

    public boolean containsStatement(Statement stat) {
        return this == stat || this.containsStatementStrict(stat);
    }

    public boolean containsStatementStrict(Statement stat) {
        this.cancellationManager.checkCanceled();
        if (this.stats.contains(stat)) {
            return true;
        }
        for (Statement st : this.stats) {
            if (!st.containsStatementStrict(stat)) continue;
            return true;
        }
        return false;
    }

    public TextBuffer toJava() {
        return this.toJava(0, BytecodeMappingTracer.DUMMY);
    }

    public TextBuffer toJava(int indent, BytecodeMappingTracer tracer) {
        throw new RuntimeException("not implemented");
    }

    public List<IMatchable> getSequentialObjects() {
        return new ArrayList<IMatchable>(this.stats);
    }

    @NotNull
    public List<? extends IMatchable> getExprentsOrSequentialObjects() {
        List<Exprent> exprents = this.getExprents();
        if (exprents != null) {
            return exprents;
        }
        return this.getSequentialObjects();
    }

    public void initExprents() {
    }

    public void replaceExprent(Exprent oldexpr, Exprent newexpr) {
    }

    public Statement getSimpleCopy() {
        throw new RuntimeException("not implemented");
    }

    public void initSimpleCopy() {
        if (!this.stats.isEmpty()) {
            this.first = (Statement)this.stats.get(0);
        }
    }

    public void replaceStatement(Statement oldstat, Statement newstat) {
        this.cancellationManager.checkCanceled();
        for (StatEdge edge : oldstat.getAllPredecessorEdges()) {
            oldstat.removePredecessor(edge);
            edge.getSource().changeEdgeNode(StatEdge.EdgeDirection.FORWARD, edge, newstat);
            newstat.addPredecessor(edge);
        }
        for (StatEdge edge : oldstat.getAllSuccessorEdges()) {
            oldstat.removeSuccessor(edge);
            edge.setSource(newstat);
            newstat.addSuccessor(edge);
        }
        int statindex = this.stats.getIndexByKey(oldstat.id);
        this.stats.removeWithKey(oldstat.id);
        this.stats.addWithKeyAndIndex(statindex, newstat, newstat.id);
        newstat.setParent(this);
        newstat.post = oldstat.post;
        if (this.first == oldstat) {
            this.first = newstat;
        }
        ArrayList<StatEdge> lst = new ArrayList<StatEdge>(oldstat.getLabelEdges());
        for (int i = lst.size() - 1; i >= 0; --i) {
            StatEdge edge = (StatEdge)lst.get(i);
            if (edge.getSource() != newstat) {
                newstat.addLabeledEdge(edge);
                continue;
            }
            if (this == edge.getDestination() || this.containsStatementStrict(edge.getDestination())) {
                edge.closure = null;
                continue;
            }
            this.addLabeledEdge(edge);
        }
        oldstat.getLabelEdges().clear();
    }

    private static void addToReversePostOrderListIterative(Statement root, List<? super Statement> lst) {
        LinkedList<Statement> stackNode = new LinkedList<Statement>();
        LinkedList<Integer> stackIndex = new LinkedList<Integer>();
        HashSet<Statement> setVisited = new HashSet<Statement>();
        stackNode.add(root);
        stackIndex.add(0);
        while (!stackNode.isEmpty()) {
            int index;
            Statement node = (Statement)stackNode.getLast();
            setVisited.add(node);
            List<StatEdge> lstEdges = node.getAllSuccessorEdges();
            for (index = ((Integer)stackIndex.removeLast()).intValue(); index < lstEdges.size(); ++index) {
                StatEdge edge = lstEdges.get(index);
                Statement succ = edge.getDestination();
                if (setVisited.contains(succ) || edge.getType() != StatEdge.EdgeType.REGULAR && edge.getType() != StatEdge.EdgeType.EXCEPTION) continue;
                stackIndex.add(index + 1);
                stackNode.add(succ);
                stackIndex.add(0);
                break;
            }
            if (index != lstEdges.size()) continue;
            lst.add(0, node);
            stackNode.removeLast();
        }
    }

    private static void addToPostReversePostOrderList(Statement stat, List<? super Statement> lst, HashSet<? super Statement> setVisited) {
        if (setVisited.contains(stat)) {
            return;
        }
        setVisited.add(stat);
        for (StatEdge prededge : stat.getEdges(StatEdge.EdgeType.REGULAR.unite(StatEdge.EdgeType.EXCEPTION), StatEdge.EdgeDirection.BACKWARD)) {
            Statement pred = prededge.getSource();
            if (setVisited.contains(pred)) continue;
            Statement.addToPostReversePostOrderList(pred, lst, setVisited);
        }
        lst.add(0, stat);
    }

    public void changeEdgeNode(StatEdge.EdgeDirection direction, StatEdge edge, Statement value) {
        this.cancellationManager.checkCanceled();
        Map<StatEdge.EdgeType, List<StatEdge>> mapEdges = direction == StatEdge.EdgeDirection.BACKWARD ? this.mapPredEdges : this.mapSuccEdges;
        Map<StatEdge.EdgeType, List<Statement>> mapStates = direction == StatEdge.EdgeDirection.BACKWARD ? this.mapPredStates : this.mapSuccStates;
        StatEdge.EdgeType type = edge.getType();
        StatEdge.EdgeType[] arrtypes = type == StatEdge.EdgeType.EXCEPTION ? new StatEdge.EdgeType[]{StatEdge.EdgeType.ALL, StatEdge.EdgeType.EXCEPTION} : new StatEdge.EdgeType[]{StatEdge.EdgeType.ALL, StatEdge.EdgeType.DIRECT_ALL, type};
        for (StatEdge.EdgeType edgetype : arrtypes) {
            int index;
            List<StatEdge> lst = mapEdges.get(edgetype);
            if (lst == null || (index = lst.indexOf(edge)) < 0) continue;
            mapStates.get(edgetype).set(index, value);
        }
        if (direction == StatEdge.EdgeDirection.BACKWARD) {
            edge.setSource(value);
        } else {
            edge.setDestination(value);
        }
    }

    public void changeEdgeType(StatEdge.EdgeDirection direction, StatEdge edge, StatEdge.EdgeType newtype) {
        this.cancellationManager.checkCanceled();
        StatEdge.EdgeType oldtype = edge.getType();
        if (oldtype == newtype) {
            return;
        }
        if (oldtype == StatEdge.EdgeType.EXCEPTION || newtype == StatEdge.EdgeType.EXCEPTION) {
            throw new RuntimeException("Invalid edge type!");
        }
        this.removeEdgeDirectInternal(direction, edge, oldtype);
        this.addEdgeDirectInternal(direction, edge, newtype);
        if (direction == StatEdge.EdgeDirection.FORWARD) {
            edge.getDestination().changeEdgeType(StatEdge.EdgeDirection.BACKWARD, edge, newtype);
        }
        edge.setType(newtype);
    }

    private List<StatEdge> getEdges(StatEdge.EdgeType type, @NotNull StatEdge.EdgeDirection direction) {
        List<Object> res;
        Map<StatEdge.EdgeType, List<StatEdge>> map;
        this.cancellationManager.checkCanceled();
        Map<StatEdge.EdgeType, List<StatEdge>> map2 = map = direction == StatEdge.EdgeDirection.BACKWARD ? this.mapPredEdges : this.mapSuccEdges;
        if ((type.mask() & type.mask() - 1) == 0) {
            res = map.get(type);
            res = res == null ? new ArrayList() : new ArrayList(res);
        } else {
            res = new ArrayList();
            for (StatEdge.EdgeType edgetype : StatEdge.EdgeType.types()) {
                List<StatEdge> lst;
                if ((type.mask() & edgetype.mask()) == 0 || (lst = map.get(edgetype)) == null) continue;
                res.addAll(lst);
            }
        }
        return res;
    }

    public List<Statement> getNeighbours(StatEdge.EdgeType type, StatEdge.EdgeDirection direction) {
        List<Object> res;
        Map<StatEdge.EdgeType, List<Statement>> map;
        this.cancellationManager.checkCanceled();
        Map<StatEdge.EdgeType, List<Statement>> map2 = map = direction == StatEdge.EdgeDirection.BACKWARD ? this.mapPredStates : this.mapSuccStates;
        if ((type.mask() & type.mask() - 1) == 0) {
            res = map.get(type);
            res = res == null ? new ArrayList() : new ArrayList(res);
        } else {
            res = new ArrayList();
            for (StatEdge.EdgeType edgetype : StatEdge.EdgeType.types()) {
                List<Statement> lst;
                if ((type.mask() & edgetype.mask()) == 0 || (lst = map.get(edgetype)) == null) continue;
                res.addAll(lst);
            }
        }
        return res;
    }

    public Set<Statement> getNeighboursSet(StatEdge.EdgeType type, StatEdge.EdgeDirection direction) {
        return new HashSet<Statement>(this.getNeighbours(type, direction));
    }

    public List<StatEdge> getSuccessorEdges(StatEdge.EdgeType type) {
        return this.getEdges(type, StatEdge.EdgeDirection.FORWARD);
    }

    public List<StatEdge> getPredecessorEdges(StatEdge.EdgeType type) {
        return this.getEdges(type, StatEdge.EdgeDirection.BACKWARD);
    }

    public List<StatEdge> getAllSuccessorEdges() {
        return this.getEdges(StatEdge.EdgeType.ALL, StatEdge.EdgeDirection.FORWARD);
    }

    public List<StatEdge> getAllPredecessorEdges() {
        return this.getEdges(StatEdge.EdgeType.ALL, StatEdge.EdgeDirection.BACKWARD);
    }

    public Statement getFirst() {
        this.cancellationManager.checkCanceled();
        return this.first;
    }

    public void setFirst(Statement first) {
        this.first = first;
    }

    public Statement getPost() {
        return this.post;
    }

    public VBStyleCollection<Statement, Integer> getStats() {
        this.cancellationManager.checkCanceled();
        return this.stats;
    }

    public StatementType getLastBasicType() {
        return this.lastBasicType;
    }

    public HashSet<Statement> getContinueSet() {
        return this.continueSet;
    }

    public boolean isContainsMonitorExit() {
        return this.containsMonitorExit;
    }

    public boolean isMonitorEnter() {
        return this.isMonitorEnter;
    }

    public BasicBlockStatement getBasichead() {
        if (this.type == StatementType.BASIC_BLOCK) {
            return (BasicBlockStatement)this;
        }
        return this.first.getBasichead();
    }

    public boolean isLabeled() {
        for (StatEdge edge : this.labelEdges) {
            if (!edge.labeled || !edge.explicit) continue;
            return true;
        }
        return false;
    }

    public boolean hasBasicSuccEdge() {
        return this.type == StatementType.BASIC_BLOCK || this.type == StatementType.IF && ((IfStatement)this).iftype == 0 || this.type == StatementType.DO && ((DoStatement)this).getLoopType() != DoStatement.LoopType.DO;
    }

    public Statement getParent() {
        this.cancellationManager.checkCanceled();
        return this.parent;
    }

    public void setParent(Statement parent) {
        this.parent = parent;
    }

    public Statement getTopParent() {
        Statement ret = this;
        while (ret.getParent() != null) {
            ret = ret.getParent();
        }
        return ret;
    }

    public HashSet<StatEdge> getLabelEdges() {
        return this.labelEdges;
    }

    public List<Exprent> getVarDefinitions() {
        this.cancellationManager.checkCanceled();
        return this.varDefinitions;
    }

    @Nullable
    public List<Exprent> getExprents() {
        this.cancellationManager.checkCanceled();
        return this.exprents;
    }

    public void setExprents(List<Exprent> exprents) {
        this.exprents = exprents;
    }

    public boolean isCopied() {
        return this.copied;
    }

    public void setCopied(boolean copied) {
        this.copied = copied;
    }

    public String toString() {
        return this.toString(0);
    }

    protected String toString(int indent) {
        StringBuilder buf = new StringBuilder();
        buf.append(TextUtil.getIndentString(indent)).append((Object)this.type).append(": ").append(this.id);
        for (Statement stat : this.stats) {
            buf.append(DecompilerContext.getNewLineSeparator());
            buf.append(stat.toString(indent + 1));
        }
        return buf.toString();
    }

    public void getOffset(@Nullable BitSet values) {
        if (values == null) {
            return;
        }
        if (this instanceof DummyExitStatement && ((DummyExitStatement)this).bytecode != null) {
            values.or(((DummyExitStatement)this).bytecode);
        }
        if (this.getExprents() != null) {
            for (Exprent e : this.getExprents()) {
                e.fillBytecodeRange(values);
            }
        } else {
            for (IMatchable obj : this.getSequentialObjects()) {
                if (obj == null) continue;
                if (obj instanceof Statement) {
                    ((Statement)obj).getOffset(values);
                    continue;
                }
                if (!(obj instanceof Exprent)) continue;
                ((Exprent)obj).fillBytecodeRange(values);
            }
        }
    }

    public StartEndPair getStartEndRange() {
        if (this.endpoints == null) {
            BitSet set = new BitSet();
            this.getOffset(set);
            this.endpoints = new StartEndPair(set.nextSetBit(0), set.length() - 1);
        }
        return this.endpoints;
    }

    @Override
    public IMatchable findObject(MatchNode matchNode, int index) {
        int node_type = matchNode.getType();
        if (node_type == 0 && !this.stats.isEmpty()) {
            String position = (String)matchNode.getRuleValue(IMatchable.MatchProperties.STATEMENT_POSITION);
            if (position != null) {
                if (position.matches("-?\\d+")) {
                    return (IMatchable)this.stats.get((this.stats.size() + Integer.parseInt(position)) % this.stats.size());
                }
            } else if (index < this.stats.size()) {
                return (IMatchable)this.stats.get(index);
            }
        } else if (node_type == 1 && this.exprents != null && !this.exprents.isEmpty()) {
            String position = (String)matchNode.getRuleValue(IMatchable.MatchProperties.EXPRENT_POSITION);
            if (position != null) {
                if (position.matches("-?\\d+")) {
                    return this.exprents.get((this.exprents.size() + Integer.parseInt(position)) % this.exprents.size());
                }
            } else if (index < this.exprents.size()) {
                return this.exprents.get(index);
            }
        }
        return null;
    }

    @Override
    public boolean match(MatchNode matchNode, MatchEngine engine) {
        if (matchNode.getType() != 0) {
            return false;
        }
        block6: for (Map.Entry<IMatchable.MatchProperties, MatchNode.RuleValue> rule : matchNode.getRules().entrySet()) {
            switch (rule.getKey()) {
                case STATEMENT_TYPE: {
                    if (this.type == rule.getValue().value) break;
                    return false;
                }
                case STATEMENT_STATSIZE: {
                    if (this.stats.size() == ((Integer)rule.getValue().value).intValue()) break;
                    return false;
                }
                case STATEMENT_EXPRSIZE: {
                    int exprsize = (Integer)rule.getValue().value;
                    if (!(exprsize == -1 ? this.exprents != null : this.exprents == null || this.exprents.size() != exprsize)) continue block6;
                    return false;
                }
                case STATEMENT_RET: {
                    if (engine.checkAndSetVariableValue((String)rule.getValue().value, this)) break;
                    return false;
                }
            }
        }
        return true;
    }

    public static enum StatementType {
        GENERAL,
        IF,
        DO,
        SWITCH,
        TRY_CATCH,
        BASIC_BLOCK,
        SYNCHRONIZED,
        PLACEHOLDER,
        CATCH_ALL,
        ROOT,
        DUMMY_EXIT,
        SEQUENCE;

    }
}

