/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.decompiler.main.AssertProcessor;
import org.jetbrains.java.decompiler.main.ClassReference14Processor;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.EnumProcessor;
import org.jetbrains.java.decompiler.main.InitializerProcessor;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.rels.ClassWrapper;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AnnotationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ExitExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.NewExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.typeann.TargetInfo;
import org.jetbrains.java.decompiler.modules.decompiler.typeann.TypeAnnotation;
import org.jetbrains.java.decompiler.modules.decompiler.typeann.TypeAnnotationWriteHelper;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersion;
import org.jetbrains.java.decompiler.modules.renamer.PoolInterceptor;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructField;
import org.jetbrains.java.decompiler.struct.StructMember;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.StructRecordComponent;
import org.jetbrains.java.decompiler.struct.StructTypePathEntry;
import org.jetbrains.java.decompiler.struct.attr.StructAnnDefaultAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructAnnotationAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructAnnotationParameterAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructConstantValueAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructExceptionsAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructLineNumberTableAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructMethodParametersAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructModuleAttribute;
import org.jetbrains.java.decompiler.struct.consts.PrimitiveConstant;
import org.jetbrains.java.decompiler.struct.gen.FieldDescriptor;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.Type;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericClassDescriptor;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericFieldDescriptor;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericMethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericType;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.TextBuffer;

public class ClassWriter {
    private final PoolInterceptor interceptor = DecompilerContext.getPoolInterceptor();
    private static final Map<Integer, String> MODIFIERS = new LinkedHashMap<Integer, String>();
    private static final int CLASS_ALLOWED = 3103;
    private static final int FIELD_ALLOWED = 223;
    private static final int METHOD_ALLOWED = 3391;
    private static final int CLASS_EXCLUDED = 1032;
    private static final int FIELD_EXCLUDED = 25;
    private static final int METHOD_EXCLUDED = 1025;
    private static final int ACCESSIBILITY_FLAGS = 7;

    private static void invokeProcessors(ClassesProcessor.ClassNode node) {
        ClassWrapper wrapper = node.getWrapper();
        StructClass cl = wrapper.getClassStruct();
        InitializerProcessor.extractInitializers(wrapper);
        InitializerProcessor.hideInitalizers(wrapper);
        if (node.type == 0 && !cl.isVersion5() && DecompilerContext.getOption("dc4")) {
            ClassReference14Processor.processClassReferences(node);
        }
        if (cl.hasModifier(16384) && DecompilerContext.getOption("den")) {
            EnumProcessor.clearEnum(wrapper);
        }
        if (DecompilerContext.getOption("das")) {
            AssertProcessor.buildAssertions(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void classLambdaToJava(ClassesProcessor.ClassNode node, TextBuffer buffer, Exprent method_object, int indent, BytecodeMappingTracer origTracer) {
        ClassWrapper wrapper = node.getWrapper();
        if (wrapper == null) {
            return;
        }
        boolean lambdaToAnonymous = DecompilerContext.getOption("lac");
        ClassesProcessor.ClassNode outerNode = (ClassesProcessor.ClassNode)DecompilerContext.getProperty("CURRENT_CLASS_NODE");
        DecompilerContext.setProperty("CURRENT_CLASS_NODE", node);
        BytecodeMappingTracer tracer = new BytecodeMappingTracer(origTracer.getCurrentSourceLine());
        try {
            StructClass cl = wrapper.getClassStruct();
            DecompilerContext.getLogger().startWriteClass(node.simpleName);
            if (node.lambdaInformation.is_method_reference) {
                if (!node.lambdaInformation.is_content_method_static && method_object != null) {
                    method_object.inferExprType(new VarType(8, 0, node.lambdaInformation.content_class_name));
                    String instance = method_object.toJava(indent, tracer).toString();
                    if (method_object.type == 6 && ((FunctionExprent)method_object).getFuncType() == 29 && ((FunctionExprent)method_object).doesCast()) {
                        buffer.append('(').append(instance).append(')');
                    } else {
                        buffer.append(instance);
                    }
                } else {
                    buffer.append(ExprProcessor.getCastTypeName(new VarType(node.lambdaInformation.content_class_name, true), Collections.emptyList()));
                }
                buffer.append("::").append("<init>".equals(node.lambdaInformation.content_method_name) ? "new" : node.lambdaInformation.content_method_name);
            } else {
                StructMethod mt = cl.getMethod(node.lambdaInformation.content_method_key);
                MethodWrapper methodWrapper = wrapper.getMethodWrapper(mt.getName(), mt.getDescriptor());
                MethodDescriptor md_content = MethodDescriptor.parseDescriptor(node.lambdaInformation.content_method_descriptor);
                MethodDescriptor md_lambda = MethodDescriptor.parseDescriptor(node.lambdaInformation.method_descriptor);
                List<TypeAnnotation> parameterTypeAnnotations = TargetInfo.FormalParameterTarget.extract(TypeAnnotation.listFrom(mt));
                boolean explicitlyTyped = !parameterTypeAnnotations.isEmpty();
                boolean simpleLambda = false;
                if (!lambdaToAnonymous) {
                    buffer.append('(');
                    boolean firstParameter = true;
                    int index = node.lambdaInformation.is_content_method_static ? 0 : 1;
                    int start_index = md_content.params.length - md_lambda.params.length;
                    for (int i = 0; i < md_content.params.length; ++i) {
                        if (i >= start_index) {
                            Object parameterName;
                            if (!firstParameter) {
                                buffer.append(", ");
                            }
                            List<TypeAnnotation> iParameterTypeAnnotations = TargetInfo.FormalParameterTarget.extract(parameterTypeAnnotations, i);
                            VarType type = md_content.params[i];
                            String typeName = ExprProcessor.getCastTypeName(type, explicitlyTyped, TypeAnnotationWriteHelper.create(iParameterTypeAnnotations));
                            if (explicitlyTyped) {
                                buffer.append(typeName);
                                buffer.append(' ');
                            }
                            if ((parameterName = methodWrapper.varproc.getVarName(new VarVersion(index, 0))) == null) {
                                parameterName = "param" + index;
                            }
                            parameterName = methodWrapper.methodStruct.getVariableNamer().renameParameter(mt.getAccessFlags(), typeName, (String)parameterName, index);
                            buffer.append((String)parameterName);
                            firstParameter = false;
                        }
                        index += md_content.params[i].getStackSize();
                    }
                    buffer.append(") ->");
                    RootStatement root = wrapper.getMethodWrapper((String)mt.getName(), (String)mt.getDescriptor()).root;
                    if (DecompilerContext.getOption("isl") && !methodWrapper.decompiledWithErrors && root != null) {
                        simpleLambda = ClassWriter.convertToOneLineLambda(wrapper, tracer, buffer, mt, indent);
                    }
                }
                if (!simpleLambda) {
                    buffer.append(" {").appendLineSeparator();
                    tracer.incrementCurrentSourceLine();
                    ClassWriter.methodLambdaToJava(node, wrapper, mt, buffer, indent + 1, !lambdaToAnonymous, tracer);
                    buffer.appendIndent(indent).append("}");
                    ClassWriter.addTracer(cl, mt, tracer);
                }
            }
        }
        finally {
            DecompilerContext.setProperty("CURRENT_CLASS_NODE", outerNode);
        }
        DecompilerContext.getLogger().endWriteClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean convertToOneLineLambda(@NotNull ClassWrapper classWrapper, @NotNull BytecodeMappingTracer tracer, @NotNull TextBuffer buffer, @NotNull StructMethod mt, int indent) {
        RootStatement root = classWrapper.getMethodWrapper((String)mt.getName(), (String)mt.getDescriptor()).root;
        MethodWrapper methodWrapper = classWrapper.getMethodWrapper(mt.getName(), mt.getDescriptor());
        StructClass cl = classWrapper.getClassStruct();
        boolean simpleLambda = false;
        Statement firstStat = root.getFirst();
        if (firstStat.type == Statement.StatementType.BASIC_BLOCK && firstStat.getExprents() != null && firstStat.getExprents().size() == 1) {
            boolean isThrow;
            Exprent firstExpr = firstStat.getExprents().get(0);
            boolean isVarDefinition = firstExpr.type == 2 && ((AssignmentExprent)firstExpr).getLeft().type == 12 && ((VarExprent)((AssignmentExprent)firstExpr).getLeft()).isDefinition();
            boolean bl = isThrow = firstExpr.type == 4 && ((ExitExprent)firstExpr).getExitType() == 1;
            if (!isVarDefinition && !isThrow) {
                simpleLambda = true;
                MethodWrapper outerWrapper = (MethodWrapper)DecompilerContext.getProperty("CURRENT_METHOD_WRAPPER");
                DecompilerContext.setProperty("CURRENT_METHOD_WRAPPER", methodWrapper);
                try {
                    TextBuffer codeBuffer = firstExpr.toJava(indent + 1, tracer);
                    if (firstExpr.type == 4) {
                        codeBuffer.setStart(6);
                    } else {
                        codeBuffer.prepend(" ");
                    }
                    buffer.append(codeBuffer);
                }
                catch (Throwable ex) {
                    DecompilerContext.getLogger().writeMessage("Method " + mt.getName() + " " + mt.getDescriptor() + " couldn't be written.", IFernflowerLogger.Severity.WARN, ex);
                    methodWrapper.decompiledWithErrors = true;
                    if (methodWrapper.decompiledWithErrorsMessage != null) {
                        buffer.append("// $FF: " + methodWrapper.decompiledWithErrorsMessage);
                    } else {
                        buffer.append("// $FF: Couldn't be decompiled");
                    }
                }
                finally {
                    tracer.addMapping(root.getDummyExit().bytecode);
                    ClassWriter.addTracer(cl, mt, tracer);
                    DecompilerContext.setProperty("CURRENT_METHOD_WRAPPER", outerWrapper);
                }
            }
        }
        return simpleLambda;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void classToJava(ClassesProcessor.ClassNode node, TextBuffer buffer, int indent, BytecodeMappingTracer tracer) {
        ClassesProcessor.ClassNode outerNode = (ClassesProcessor.ClassNode)DecompilerContext.getProperty("CURRENT_CLASS_NODE");
        DecompilerContext.setProperty("CURRENT_CLASS_NODE", node);
        int startLine = tracer != null ? tracer.getCurrentSourceLine() : 0;
        BytecodeMappingTracer dummy_tracer = new BytecodeMappingTracer(startLine);
        try {
            boolean hide;
            ClassWriter.invokeProcessors(node);
            ClassWrapper wrapper = node.getWrapper();
            StructClass cl = wrapper.getClassStruct();
            DecompilerContext.getLogger().startWriteClass(cl.qualifiedName);
            int start_class_def = buffer.length();
            this.writeClassDefinition(node, buffer, indent);
            boolean hasContent = false;
            boolean enumFields = false;
            dummy_tracer.incrementCurrentSourceLine(buffer.countLines(start_class_def));
            List<StructRecordComponent> components = cl.getRecordComponents();
            for (StructField fd : cl.getFields()) {
                boolean isEnum;
                hide = fd.isSynthetic() && DecompilerContext.getOption("rsy") || wrapper.getHiddenMembers().contains(InterpreterUtil.makeUniqueKey(fd.getName(), fd.getDescriptor()));
                if (hide || components != null && fd.getAccessFlags() == 18 && components.stream().anyMatch(c -> c.getName().equals(fd.getName()) && c.getDescriptor().equals(fd.getDescriptor()))) continue;
                boolean bl = isEnum = fd.hasModifier(16384) && DecompilerContext.getOption("den");
                if (isEnum) {
                    if (enumFields) {
                        buffer.append(',').appendLineSeparator();
                        dummy_tracer.incrementCurrentSourceLine();
                    }
                    enumFields = true;
                } else if (enumFields) {
                    buffer.append(';');
                    buffer.appendLineSeparator();
                    buffer.appendLineSeparator();
                    dummy_tracer.incrementCurrentSourceLine(2);
                    enumFields = false;
                }
                this.fieldToJava(wrapper, cl, fd, buffer, indent + 1, dummy_tracer);
                hasContent = true;
            }
            if (enumFields) {
                buffer.append(';').appendLineSeparator();
                dummy_tracer.incrementCurrentSourceLine();
            }
            startLine += buffer.countLines(start_class_def);
            for (StructMethod mt : cl.getMethods()) {
                BytecodeMappingTracer method_tracer;
                boolean methodSkipped;
                boolean bl = hide = mt.isSynthetic() && DecompilerContext.getOption("rsy") || mt.hasModifier(64) && DecompilerContext.getOption("rbr") || wrapper.getHiddenMembers().contains(InterpreterUtil.makeUniqueKey(mt.getName(), mt.getDescriptor()));
                if (hide) continue;
                int position = buffer.length();
                int storedLine = startLine++;
                if (hasContent) {
                    buffer.appendLineSeparator();
                }
                boolean bl2 = methodSkipped = !this.methodToJava(node, mt, buffer, indent + 1, method_tracer = new BytecodeMappingTracer(startLine));
                if (!methodSkipped) {
                    hasContent = true;
                    ClassWriter.addTracer(cl, mt, method_tracer);
                    startLine = method_tracer.getCurrentSourceLine();
                    continue;
                }
                buffer.setLength(position);
                startLine = storedLine;
            }
            for (ClassesProcessor.ClassNode inner : node.nested) {
                if (inner.type != 1) continue;
                StructClass innerCl = inner.classStruct;
                boolean isSynthetic = (inner.access & 0x1000) != 0 || innerCl.isSynthetic();
                boolean hide2 = isSynthetic && DecompilerContext.getOption("rsy") || wrapper.getHiddenMembers().contains(innerCl.qualifiedName);
                if (hide2) continue;
                if (hasContent) {
                    buffer.appendLineSeparator();
                    ++startLine;
                }
                BytecodeMappingTracer class_tracer = new BytecodeMappingTracer(startLine);
                this.classToJava(inner, buffer, indent + 1, class_tracer);
                startLine = buffer.countLines();
                hasContent = true;
            }
            buffer.appendIndent(indent).append('}');
            if (node.type != 2) {
                buffer.appendLineSeparator();
            }
        }
        finally {
            DecompilerContext.setProperty("CURRENT_CLASS_NODE", outerNode);
        }
        DecompilerContext.getLogger().endWriteClass();
    }

    private static boolean isSyntheticRecordMethod(StructClass cl, StructMethod mt, TextBuffer code) {
        if (cl.getRecordComponents() != null) {
            String name = mt.getName();
            String descriptor = mt.getDescriptor();
            if ((name.equals("equals") && descriptor.equals("(Ljava/lang/Object;)Z") || name.equals("hashCode") && descriptor.equals("()I") || name.equals("toString") && descriptor.equals("()Ljava/lang/String;")) && code.countLines() == 1) {
                String str = code.toString().trim();
                return str.startsWith("return this." + name + "<invokedynamic>(this");
            }
            boolean hideConstructorAndGetters = DecompilerContext.getOption("ucrc");
            if (!hideConstructorAndGetters) {
                return false;
            }
            for (StructRecordComponent rec : cl.getRecordComponents()) {
                if (!name.equals(rec.getName()) || !descriptor.equals("()" + rec.getDescriptor())) continue;
                if (code.countLines() == 1) {
                    String str = code.toString().trim();
                    AnnotationContainer methodAnnotations = ClassWriter.collectAllAnnotations(mt);
                    AnnotationContainer fieldAnnotations = ClassWriter.collectAllAnnotations(rec);
                    if (!fieldAnnotations.containsAll(methodAnnotations)) continue;
                    return str.equals("return this." + mt.getName() + ";");
                }
                return false;
            }
        }
        return false;
    }

    @NotNull
    private static AnnotationContainer collectAllAnnotations(@Nullable StructMember mt) {
        AnnotationContainer result = new AnnotationContainer(new HashSet<AnnotationExprent>(), new HashSet<AnnotationContainer.TypeAnnotationModel>());
        if (mt == null) {
            return result;
        }
        for (StructGeneralAttribute.Key<?> key : StructGeneralAttribute.ANNOTATION_ATTRIBUTES) {
            StructAnnotationAttribute attribute = (StructAnnotationAttribute)mt.getAttribute(key);
            if (attribute == null) continue;
            for (AnnotationExprent annotation : attribute.getAnnotations()) {
                if (mt.memberAnnCollidesWithTypeAnnotation(annotation)) continue;
                result.memberAnnotation.add(annotation);
            }
        }
        List<TypeAnnotation> annotations = TypeAnnotation.listFrom(mt);
        for (TypeAnnotation annotation : annotations) {
            result.typeAnnotationModel.add(new AnnotationContainer.TypeAnnotationModel(annotation.getAnnotationExpr(), annotation.getPaths()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeClassDefinition(ClassesProcessor.ClassNode node, TextBuffer buffer, int indent) {
        Set qualifiedNested;
        boolean allSubClassesAreNested;
        int[] interfaces;
        boolean isAnnotation;
        if (node.type == 2) {
            buffer.append(" {").appendLineSeparator();
            return;
        }
        ClassWrapper wrapper = node.getWrapper();
        StructClass cl = wrapper.getClassStruct();
        int flags = node.type == 0 ? cl.getAccessFlags() : node.access;
        boolean isDeprecated = cl.hasAttribute(StructGeneralAttribute.ATTRIBUTE_DEPRECATED);
        boolean isSynthetic = (flags & 0x1000) != 0 || cl.hasAttribute(StructGeneralAttribute.ATTRIBUTE_SYNTHETIC);
        boolean isEnum = DecompilerContext.getOption("den") && (flags & 0x4000) != 0;
        boolean isInterface = (flags & 0x200) != 0;
        boolean bl = isAnnotation = (flags & 0x2000) != 0;
        if (isDeprecated) {
            ClassWriter.appendDeprecation(buffer, indent);
        }
        if (this.interceptor != null) {
            String oldName = this.interceptor.getOldName(cl.qualifiedName);
            ClassWriter.appendRenameComment(buffer, oldName, MType.CLASS, indent);
        }
        if (isSynthetic) {
            ClassWriter.appendComment(buffer, "synthetic class", indent);
        }
        ClassWriter.appendAnnotations(buffer, indent, cl);
        buffer.appendIndent(indent);
        if (isEnum) {
            flags &= 0xFFFFFBFF;
            flags &= 0xFFFFFFEF;
        }
        List<StructRecordComponent> components = cl.getRecordComponents();
        List<String> permittedSubclassQualifiedNames = cl.getPermittedSubclasses();
        if (components != null) {
            flags &= 0xFFFFFFEF;
        }
        ClassWriter.appendModifiers(buffer, flags, 3103, isInterface, 1032);
        if (permittedSubclassQualifiedNames != null && !isEnum) {
            buffer.append("sealed ");
        } else if (node.isNonSealed()) {
            buffer.append("non-sealed ");
        }
        if (isEnum) {
            buffer.append("enum ");
        } else if (isInterface) {
            if (isAnnotation) {
                buffer.append('@');
            }
            buffer.append("interface ");
        } else if (components != null) {
            buffer.append("record ");
        } else {
            buffer.append("class ");
        }
        buffer.append(node.simpleName);
        List<TypeAnnotation> typeAnnotations = TypeAnnotation.listFrom(cl);
        GenericClassDescriptor descriptor = cl.getSignature();
        if (descriptor != null && !descriptor.fparameters.isEmpty()) {
            DecompilerContext.setProperty("IN_CLASS_TYPE_PARAMS", "1");
            try {
                ClassWriter.appendTypeParameters(buffer, descriptor.fparameters, descriptor.fbounds, typeAnnotations);
            }
            finally {
                DecompilerContext.setProperty("IN_CLASS_TYPE_PARAMS", "0");
            }
        }
        if (components != null) {
            buffer.append('(');
            for (int i = 0; i < components.size(); ++i) {
                StructRecordComponent cd = components.get(i);
                if (i > 0) {
                    buffer.append(", ");
                }
                boolean varArgComponent = i == components.size() - 1 && ClassWriter.isVarArgRecord(cl);
                ClassWriter.recordComponentToJava(cd, buffer, varArgComponent);
            }
            buffer.append(')');
        }
        buffer.append(' ');
        if (!isEnum && !isInterface && components == null && cl.superClass != null) {
            VarType supertype = new VarType(cl.superClass.getString(), true);
            List<TypeAnnotation> extendsTypeAnnotations = TargetInfo.SupertypeTarget.extractExtends(typeAnnotations);
            if (!VarType.VARTYPE_OBJECT.equals(supertype)) {
                buffer.append("extends ");
                buffer.append(ExprProcessor.getCastTypeName(descriptor == null ? supertype : descriptor.superclass, TypeAnnotationWriteHelper.create(extendsTypeAnnotations)));
                buffer.append(' ');
            }
        }
        if (!isAnnotation && (interfaces = cl.getInterfaces()).length > 0) {
            buffer.append(isInterface ? "extends " : "implements ");
            for (int i = 0; i < interfaces.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                List<TypeAnnotation> superTypeAnnotations = TargetInfo.SupertypeTarget.extract(typeAnnotations, i);
                buffer.append(ExprProcessor.getCastTypeName(descriptor == null ? new VarType(cl.getInterface(i), true) : descriptor.superinterfaces.get(i), TypeAnnotationWriteHelper.create(superTypeAnnotations)));
            }
            buffer.append(' ');
        }
        if (permittedSubclassQualifiedNames != null && !permittedSubclassQualifiedNames.isEmpty() && !(allSubClassesAreNested = (qualifiedNested = node.nested.stream().map(nestedNode -> nestedNode.classStruct.qualifiedName).collect(Collectors.toSet())).containsAll(permittedSubclassQualifiedNames))) {
            buffer.append("permits ");
            for (int i = 0; i < permittedSubclassQualifiedNames.size(); ++i) {
                String qualifiedName = permittedSubclassQualifiedNames.get(i);
                if (i > 0) {
                    buffer.append(", ");
                }
                String nestedName = DecompilerContext.getImportCollector().getNestedName(qualifiedName);
                buffer.append(nestedName);
            }
            buffer.append(' ');
        }
        buffer.append('{').appendLineSeparator();
    }

    private void fieldToJava(ClassWrapper wrapper, StructClass cl, StructField fd, TextBuffer buffer, int indent, BytecodeMappingTracer tracer) {
        StructConstantValueAttribute attr;
        boolean isEnum;
        int start = buffer.length();
        boolean isInterface = cl.hasModifier(512);
        boolean isDeprecated = fd.hasAttribute(StructGeneralAttribute.ATTRIBUTE_DEPRECATED);
        boolean bl = isEnum = fd.hasModifier(16384) && DecompilerContext.getOption("den");
        if (isDeprecated) {
            ClassWriter.appendDeprecation(buffer, indent);
        }
        if (this.interceptor != null) {
            String oldName = this.interceptor.getOldName(cl.qualifiedName + " " + fd.getName() + " " + fd.getDescriptor());
            ClassWriter.appendRenameComment(buffer, oldName, MType.FIELD, indent);
        }
        if (fd.isSynthetic()) {
            ClassWriter.appendComment(buffer, "synthetic field", indent);
        }
        Map.Entry<VarType, GenericFieldDescriptor> fieldTypeData = ClassWriter.getFieldTypeData(fd);
        VarType fieldType = fieldTypeData.getKey();
        ClassWriter.appendAnnotations(buffer, indent, fd);
        buffer.appendIndent(indent);
        if (!isEnum) {
            ClassWriter.appendModifiers(buffer, fd.getAccessFlags(), 223, isInterface, 25);
        }
        GenericFieldDescriptor descriptor = fieldTypeData.getValue();
        List<TypeAnnotation> typeAnnotations = TypeAnnotation.listFrom(fd);
        if (!isEnum) {
            buffer.append(ExprProcessor.getCastTypeName(descriptor == null ? fieldType : descriptor.type, TypeAnnotationWriteHelper.create(typeAnnotations)));
            buffer.append(' ');
        }
        buffer.append(fd.getName());
        tracer.incrementCurrentSourceLine(buffer.countLines(start));
        Exprent initializer = fd.hasModifier(8) ? wrapper.getStaticFieldInitializers().getWithKey(InterpreterUtil.makeUniqueKey(fd.getName(), fd.getDescriptor())) : wrapper.getDynamicFieldInitializers().getWithKey(InterpreterUtil.makeUniqueKey(fd.getName(), fd.getDescriptor()));
        if (initializer != null) {
            if (isEnum && initializer.type == 10) {
                NewExprent expr = (NewExprent)initializer;
                expr.setEnumConst(true);
                buffer.append(expr.toJava(indent, tracer));
            } else {
                buffer.append(" = ");
                if (initializer.type == 3) {
                    ((ConstExprent)initializer).adjustConstType(fieldType);
                }
                ExprProcessor.getCastedExprent(initializer, descriptor == null ? fieldType : descriptor.type, buffer, indent, false, tracer);
            }
        } else if (fd.hasModifier(16) && fd.hasModifier(8) && (attr = fd.getAttribute(StructGeneralAttribute.ATTRIBUTE_CONSTANT_VALUE)) != null) {
            PrimitiveConstant constant = cl.getPool().getPrimitiveConstant(attr.getIndex());
            buffer.append(" = ");
            buffer.append(new ConstExprent(fieldType, constant.value, null, fd).toJava(indent, tracer));
        }
        if (!isEnum) {
            buffer.append(';').appendLineSeparator();
            tracer.incrementCurrentSourceLine();
        }
    }

    private static void writeModuleInfoBody(TextBuffer buffer, StructModuleAttribute moduleAttribute) {
        List<StructModuleAttribute.ProvidesEntry> list;
        List<String> list2;
        List<StructModuleAttribute.OpensEntry> list3;
        List<StructModuleAttribute.ExportsEntry> exportsEntries;
        boolean newLineNeeded = false;
        List<StructModuleAttribute.RequiresEntry> requiresEntries = moduleAttribute.requires;
        if (!requiresEntries.isEmpty()) {
            for (StructModuleAttribute.RequiresEntry requiresEntry : requiresEntries) {
                if (ClassWriter.isGenerated(requiresEntry.flags)) continue;
                buffer.appendIndent(1).append("requires ");
                if ((requiresEntry.flags & 0x40) != 0) {
                    buffer.append("static ");
                }
                if ((requiresEntry.flags & 0x20) != 0) {
                    buffer.append("transitive ");
                }
                buffer.append(requiresEntry.moduleName.replace('/', '.')).append(';').appendLineSeparator();
                newLineNeeded = true;
            }
        }
        if (!(exportsEntries = moduleAttribute.exports).isEmpty()) {
            if (newLineNeeded) {
                buffer.appendLineSeparator();
            }
            for (StructModuleAttribute.ExportsEntry exportsEntry : exportsEntries) {
                if (ClassWriter.isGenerated(exportsEntry.flags)) continue;
                buffer.appendIndent(1).append("exports ").append(exportsEntry.packageName.replace('/', '.'));
                List<String> list4 = exportsEntry.exportToModules;
                if (!list4.isEmpty()) {
                    buffer.append(" to").appendLineSeparator();
                    ClassWriter.appendFQClassNames(buffer, list4);
                }
                buffer.append(';').appendLineSeparator();
                newLineNeeded = true;
            }
        }
        if (!(list3 = moduleAttribute.opens).isEmpty()) {
            if (newLineNeeded) {
                buffer.appendLineSeparator();
            }
            for (StructModuleAttribute.OpensEntry opensEntry : list3) {
                if (ClassWriter.isGenerated(opensEntry.flags)) continue;
                buffer.appendIndent(1).append("opens ").append(opensEntry.packageName.replace('/', '.'));
                List<String> opensToModules = opensEntry.opensToModules;
                if (!opensToModules.isEmpty()) {
                    buffer.append(" to").appendLineSeparator();
                    ClassWriter.appendFQClassNames(buffer, opensToModules);
                }
                buffer.append(';').appendLineSeparator();
                newLineNeeded = true;
            }
        }
        if (!(list2 = moduleAttribute.uses).isEmpty()) {
            if (newLineNeeded) {
                buffer.appendLineSeparator();
            }
            for (String uses : list2) {
                buffer.appendIndent(1).append("uses ").append(ExprProcessor.buildJavaClassName(uses)).append(';').appendLineSeparator();
            }
            newLineNeeded = true;
        }
        if (!(list = moduleAttribute.provides).isEmpty()) {
            if (newLineNeeded) {
                buffer.appendLineSeparator();
            }
            for (StructModuleAttribute.ProvidesEntry provides : list) {
                buffer.appendIndent(1).append("provides ").append(ExprProcessor.buildJavaClassName(provides.interfaceName)).append(" with").appendLineSeparator();
                ClassWriter.appendFQClassNames(buffer, provides.implementationNames.stream().map(ExprProcessor::buildJavaClassName).collect(Collectors.toList()));
                buffer.append(';').appendLineSeparator();
            }
        }
    }

    private static boolean isGenerated(int flags) {
        return (flags & 0x9000) != 0;
    }

    private static void addTracer(StructClass cls, StructMethod method, BytecodeMappingTracer tracer) {
        StructLineNumberTableAttribute table = method.getAttribute(StructGeneralAttribute.ATTRIBUTE_LINE_NUMBER_TABLE);
        tracer.setLineNumberTable(table);
        String key = InterpreterUtil.makeUniqueKey(method.getName(), method.getDescriptor());
        DecompilerContext.getBytecodeSourceMapper().addTracer(cls.qualifiedName, key, tracer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean methodToJava(ClassesProcessor.ClassNode node, StructMethod mt, TextBuffer buffer, int indent, BytecodeMappingTracer tracer) {
        ClassWrapper wrapper = node.getWrapper();
        StructClass cl = wrapper.getClassStruct();
        MethodWrapper methodWrapper = wrapper.getMethodWrapper(mt.getName(), mt.getDescriptor());
        boolean hideMethod = false;
        int start_index_method = buffer.length();
        MethodWrapper outerWrapper = (MethodWrapper)DecompilerContext.getProperty("CURRENT_METHOD_WRAPPER");
        DecompilerContext.setProperty("CURRENT_METHOD_WRAPPER", methodWrapper);
        try {
            boolean isBridge;
            boolean isInterface = cl.hasModifier(512);
            boolean isAnnotation = cl.hasModifier(8192);
            boolean isDeprecated = mt.hasAttribute(StructGeneralAttribute.ATTRIBUTE_DEPRECATED);
            boolean clInit = false;
            boolean dInit = false;
            boolean compact = false;
            MethodDescriptor md = MethodDescriptor.parseDescriptor(mt, node);
            int flags = mt.getAccessFlags();
            if ((flags & 0x100) != 0) {
                flags &= 0xFFFFF7FF;
            }
            if ("<clinit>".equals(mt.getName())) {
                flags &= 8;
            }
            if (isDeprecated) {
                ClassWriter.appendDeprecation(buffer, indent);
            }
            if (this.interceptor != null) {
                String oldName = this.interceptor.getOldName(cl.qualifiedName + " " + mt.getName() + " " + mt.getDescriptor());
                ClassWriter.appendRenameComment(buffer, oldName, MType.METHOD, indent);
            }
            boolean isSynthetic = (flags & 0x1000) != 0 || mt.hasAttribute(StructGeneralAttribute.ATTRIBUTE_SYNTHETIC);
            boolean bl = isBridge = (flags & 0x40) != 0;
            if (isSynthetic) {
                ClassWriter.appendComment(buffer, "synthetic method", indent);
            }
            if (isBridge) {
                ClassWriter.appendComment(buffer, "bridge method", indent);
            }
            GenericMethodDescriptor descriptor = mt.getSignature();
            ClassWriter.appendAnnotations(buffer, indent, mt);
            buffer.appendIndent(indent);
            ClassWriter.appendModifiers(buffer, flags, 3391, isInterface, 1025);
            if (isInterface && !mt.hasModifier(8) && !mt.hasModifier(2) && mt.containsCode()) {
                buffer.append("default ");
            }
            String name = mt.getName();
            boolean init = false;
            if ("<init>".equals(name)) {
                if (node.type == 2) {
                    name = "";
                    dInit = true;
                } else {
                    name = node.simpleName;
                    init = true;
                }
                if (cl.getRecordComponents() != null) {
                    RecordConstructorContext recordConstructorContext = ClassWriter.tryToDeleteRecordConstructor(cl, mt, methodWrapper, md);
                    compact = recordConstructorContext.compact;
                    hideMethod = recordConstructorContext.hideConstructor;
                }
            } else if ("<clinit>".equals(name)) {
                name = "";
                clInit = true;
            }
            boolean throwsExceptions = false;
            int paramCount = 0;
            List<TypeAnnotation> typeAnnotations = TypeAnnotation.listFrom(mt);
            if (!clInit && !dInit) {
                if (descriptor != null && !descriptor.typeParameters.isEmpty()) {
                    ClassWriter.appendTypeParameters(buffer, descriptor.typeParameters, descriptor.typeParameterBounds, typeAnnotations);
                    buffer.append(' ');
                }
                List<TypeAnnotation> emptyTypeAnnotations = TargetInfo.EmptyTarget.extract(typeAnnotations);
                if (init) {
                    emptyTypeAnnotations.forEach(typeAnnotation -> typeAnnotation.writeTo(buffer));
                } else {
                    buffer.append(ExprProcessor.getCastTypeName(descriptor == null ? md.ret : descriptor.returnType, TypeAnnotationWriteHelper.create(emptyTypeAnnotations)));
                    buffer.append(' ');
                }
                buffer.append(ClassWriter.toValidJavaIdentifier(name));
                if (!compact) {
                    buffer.append('(');
                    List<VarVersion> mask = methodWrapper.synthParameters;
                    int lastVisibleParameterIndex = -1;
                    for (int i = 0; i < md.params.length; ++i) {
                        if (mask != null && mask.get(i) != null) continue;
                        lastVisibleParameterIndex = i;
                    }
                    int index = methodWrapper.varproc.getFirstParameterVarIndex();
                    boolean hasDescriptor = descriptor != null;
                    for (int i = methodWrapper.varproc.getFirstParameterPosition(); i < md.params.length; ++i) {
                        if (mask == null || mask.get(i) == null) {
                            String typeName;
                            boolean isVarArg;
                            VarType parameterType;
                            VarType varType = parameterType = hasDescriptor && !descriptor.parameterTypes.isEmpty() ? descriptor.parameterTypes.get(paramCount) : md.params[i];
                            if (paramCount > 0) {
                                buffer.append(", ");
                            }
                            Type paramType = descriptor != null && descriptor.parameterTypes.size() > paramCount ? (Type)descriptor.parameterTypes.get(paramCount) : md.params[i];
                            ClassWriter.appendParameterAnnotations(buffer, mt, paramType, paramCount);
                            VarVersion pair = new VarVersion(index, 0);
                            if (methodWrapper.varproc.isParameterFinal(pair) || methodWrapper.varproc.getVarFinal(pair) == 2) {
                                buffer.append("final ");
                            }
                            List<TypeAnnotation> typeParamAnnotations = TargetInfo.FormalParameterTarget.extract(typeAnnotations, i);
                            boolean bl2 = isVarArg = i == lastVisibleParameterIndex && mt.hasModifier(128) && parameterType.getArrayDim() > 0;
                            if (isVarArg) {
                                parameterType = parameterType.decreaseArrayDim();
                            }
                            if ("<undefinedtype>".equals(typeName = ExprProcessor.getCastTypeName(parameterType, TypeAnnotationWriteHelper.create(typeParamAnnotations))) && DecompilerContext.getOption("uto")) {
                                typeName = ExprProcessor.getCastTypeName(VarType.VARTYPE_OBJECT, TypeAnnotationWriteHelper.create(typeParamAnnotations));
                            }
                            VarType type = methodWrapper.varproc.getVarType(pair);
                            if (parameterType instanceof GenericType && (type == null || type.equals(VarType.VARTYPE_OBJECT))) {
                                methodWrapper.varproc.setVarType(pair, parameterType);
                            }
                            buffer.append(typeName);
                            if (isVarArg) {
                                buffer.append("...");
                            }
                            buffer.append(' ');
                            Object parameterName = methodWrapper.varproc.getVarName(pair);
                            if (parameterName == null) {
                                parameterName = "param" + index;
                            }
                            parameterName = methodWrapper.methodStruct.getVariableNamer().renameParameter(flags, typeName, (String)parameterName, index);
                            buffer.append((String)parameterName);
                            ++paramCount;
                        }
                        index += md.params[i].getStackSize();
                    }
                    buffer.append(')');
                    StructExceptionsAttribute attr = mt.getAttribute(StructGeneralAttribute.ATTRIBUTE_EXCEPTIONS);
                    if (descriptor != null && !descriptor.exceptionTypes.isEmpty() || attr != null) {
                        throwsExceptions = true;
                        buffer.append(" throws ");
                        boolean useDescriptor = hasDescriptor && descriptor != null && !descriptor.exceptionTypes.isEmpty();
                        for (int i = 0; i < attr.getThrowsExceptions().size(); ++i) {
                            if (i > 0) {
                                buffer.append(", ");
                            }
                            TargetInfo.ThrowsTarget.extract(typeAnnotations, i).forEach(typeAnnotation -> typeAnnotation.writeTo(buffer));
                            VarType type = useDescriptor ? descriptor.exceptionTypes.get(i) : new VarType(attr.getExcClassname(i, cl.getPool()), true);
                            buffer.append(ExprProcessor.getCastTypeName(type, Collections.emptyList()));
                        }
                    }
                }
            }
            tracer.incrementCurrentSourceLine(buffer.countLines(start_index_method));
            if ((flags & 0x500) != 0) {
                StructAnnDefaultAttribute attr;
                if (isAnnotation && (attr = mt.getAttribute(StructGeneralAttribute.ATTRIBUTE_ANNOTATION_DEFAULT)) != null) {
                    buffer.append(" default ");
                    buffer.append(attr.getDefaultValue().toJava(0, BytecodeMappingTracer.DUMMY));
                }
                buffer.append(';');
                buffer.appendLineSeparator();
            } else {
                if (!clInit && !dInit) {
                    buffer.append(' ');
                }
                buffer.append('{').appendLineSeparator();
                tracer.incrementCurrentSourceLine();
                RootStatement root = wrapper.getMethodWrapper((String)mt.getName(), (String)mt.getDescriptor()).root;
                if (root != null && !methodWrapper.decompiledWithErrors) {
                    try {
                        BytecodeMappingTracer codeTracer = new BytecodeMappingTracer(tracer.getCurrentSourceLine());
                        TextBuffer code = root.toJava(indent + 1, codeTracer);
                        hideMethod |= code.length() == 0 && (clInit || dInit || ClassWriter.hideConstructor(node, !typeAnnotations.isEmpty(), init, throwsExceptions, paramCount, flags)) || ClassWriter.isSyntheticRecordMethod(cl, mt, code);
                        buffer.append(code);
                        tracer.setCurrentSourceLine(codeTracer.getCurrentSourceLine());
                        tracer.addTracer(codeTracer);
                    }
                    catch (Throwable t) {
                        String message = "Method " + mt.getName() + " " + mt.getDescriptor() + " in class " + node.classStruct.qualifiedName + " couldn't be written.";
                        DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.WARN, t);
                        methodWrapper.decompiledWithErrors = true;
                    }
                }
                if (methodWrapper.decompiledWithErrors) {
                    buffer.appendIndent(indent + 1);
                    if (methodWrapper.decompiledWithErrorsMessage != null) {
                        buffer.append("// $FF: " + methodWrapper.decompiledWithErrorsMessage);
                    } else {
                        buffer.append("// $FF: Couldn't be decompiled");
                    }
                    buffer.appendLineSeparator();
                    tracer.incrementCurrentSourceLine();
                } else if (root != null) {
                    tracer.addMapping(root.getDummyExit().bytecode);
                }
                buffer.appendIndent(indent).append('}').appendLineSeparator();
            }
            tracer.incrementCurrentSourceLine();
        }
        finally {
            DecompilerContext.setProperty("CURRENT_METHOD_WRAPPER", outerWrapper);
        }
        return !hideMethod;
    }

    private static RecordConstructorContext tryToDeleteRecordConstructor(@NotNull StructClass cl, @NotNull StructMethod mt, @NotNull MethodWrapper methodWrapper, @NotNull MethodDescriptor md) {
        GenericMethodDescriptor descriptor = mt.getSignature();
        boolean hideMethod = false;
        AnnotationContainer container = ClassWriter.collectAllAnnotations(mt);
        if (!container.memberAnnotation.isEmpty()) {
            return new RecordConstructorContext(false, false);
        }
        boolean compact = false;
        StringBuilder buf = new StringBuilder("(");
        for (StructRecordComponent rec : cl.getRecordComponents()) {
            buf.append(rec.getDescriptor());
        }
        String desc = buf.append(")V").toString();
        if (desc.equals(mt.getDescriptor())) {
            boolean[] found = new boolean[1];
            boolean hideConstructorAndGetters = DecompilerContext.getOption("ucrc");
            StructMethodParametersAttribute parameters = mt.getAttribute(StructGeneralAttribute.ATTRIBUTE_METHOD_PARAMETERS);
            if (parameters != null) {
                List<TypeAnnotation> typeAnnotations = TypeAnnotation.listFrom(mt);
                List<StructMethodParametersAttribute.Entry> entries = parameters.getEntries();
                boolean bl = compact = hideConstructorAndGetters && methodWrapper.getOrBuildGraph().iterateExprents(exprent -> {
                    if (exprent.type == 2) {
                        AssignmentExprent assignment = (AssignmentExprent)exprent;
                        if (assignment.getLeft() != null && assignment.getRight() != null && assignment.getLeft().type == 5 && assignment.getRight().type == 12) {
                            List<TypeAnnotation> typeParamAnnotations;
                            VarType parameterType;
                            List<AnnotationExprent> paramAnnotations;
                            AnnotationContainer paramContainer;
                            int index = -1;
                            for (StructRecordComponent component : cl.getRecordComponents()) {
                                ++index;
                                if (component.getName() == null || !component.getName().equals(((FieldExprent)assignment.getLeft()).getName())) continue;
                                break;
                            }
                            if (index == -1) {
                                return 1;
                            }
                            if (entries.size() <= index) {
                                return 1;
                            }
                            StructMethodParametersAttribute.Entry entry2 = (StructMethodParametersAttribute.Entry)entries.get(index);
                            if (entry2.myName == null || !entry2.myName.equals(((VarExprent)assignment.getRight()).getName())) {
                                return 1;
                            }
                            AnnotationContainer recordComponentAnnotations = ClassWriter.collectAllAnnotations(cl.getRecordComponents().get(index));
                            if (!recordComponentAnnotations.containsAll(paramContainer = new AnnotationContainer(new HashSet<AnnotationExprent>(paramAnnotations = ClassWriter.collectParameterAnnotations(mt, parameterType = descriptor != null ? descriptor.parameterTypes.get(index) : md.params[index], index)), (typeParamAnnotations = TargetInfo.FormalParameterTarget.extract(typeAnnotations, index)).stream().map(an -> new AnnotationContainer.TypeAnnotationModel(an.getAnnotationExpr(), an.getPaths())).collect(Collectors.toSet())))) {
                                return 1;
                            }
                            found[0] = true;
                            return 0;
                        }
                        if (assignment.getLeft().type == 5) {
                            return 1;
                        }
                        Exprent patt0$temp = assignment.getLeft();
                        if (patt0$temp instanceof VarExprent) {
                            VarExprent varExprent = (VarExprent)patt0$temp;
                            if (entries.stream().anyMatch(entry -> entry.myName != null && entry.myName.equals(varExprent.getName()))) {
                                return 1;
                            }
                        }
                    }
                    return found[0] ? 1 : 0;
                });
            }
            if (compact) {
                methodWrapper.getOrBuildGraph().iterateExprents(exprent -> {
                    if (exprent.type == 2) {
                        AssignmentExprent assignment = (AssignmentExprent)exprent;
                        if (assignment.getLeft().type == 5) {
                            return 2;
                        }
                    }
                    return 0;
                });
                hideMethod = methodWrapper.getOrBuildGraph().iterateExprents(exprent -> 1);
            }
        }
        return new RecordConstructorContext(hideMethod, compact);
    }

    @NotNull
    private static List<AnnotationExprent> collectParameterAnnotations(StructMethod mt, Type type, int param) {
        ArrayList<AnnotationExprent> result = new ArrayList<AnnotationExprent>();
        if (mt == null || type == null) {
            return result;
        }
        for (StructGeneralAttribute.Key<?> key : StructGeneralAttribute.PARAMETER_ANNOTATION_ATTRIBUTES) {
            List<List<AnnotationExprent>> annotations;
            StructAnnotationParameterAttribute attribute = (StructAnnotationParameterAttribute)mt.getAttribute(key);
            if (attribute == null || param >= (annotations = attribute.getParamAnnotations()).size()) continue;
            for (AnnotationExprent annotation : annotations.get(param)) {
                if (mt.paramAnnCollidesWithTypeAnnotation(annotation, param)) continue;
                result.add(annotation);
            }
        }
        return result;
    }

    private static boolean isVarArgRecord(StructClass cl) {
        String canonicalConstructorDescriptor = cl.getRecordComponents().stream().map(StructField::getDescriptor).collect(Collectors.joining("", "(", ")V"));
        StructMethod init = cl.getMethod("<init>", canonicalConstructorDescriptor);
        return init != null && init.hasModifier(128);
    }

    public static void packageInfoToJava(StructClass cl, TextBuffer buffer) {
        ClassWriter.appendAnnotations(buffer, 0, cl);
        int index = cl.qualifiedName.lastIndexOf(47);
        String packageName = cl.qualifiedName.substring(0, index).replace('/', '.');
        buffer.append("package ").append(packageName).append(';').appendLineSeparator().appendLineSeparator();
    }

    public static void moduleInfoToJava(StructClass cl, TextBuffer buffer) {
        ClassWriter.appendAnnotations(buffer, 0, cl);
        StructModuleAttribute moduleAttribute = cl.getAttribute(StructGeneralAttribute.ATTRIBUTE_MODULE);
        if ((moduleAttribute.moduleFlags & 0x20) != 0) {
            buffer.append("open ");
        }
        buffer.append("module ").append(moduleAttribute.moduleName).append(" {").appendLineSeparator();
        ClassWriter.writeModuleInfoBody(buffer, moduleAttribute);
        buffer.append('}').appendLineSeparator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void methodLambdaToJava(ClassesProcessor.ClassNode lambdaNode, ClassWrapper classWrapper, StructMethod mt, TextBuffer buffer, int indent, boolean codeOnly, BytecodeMappingTracer tracer) {
        MethodWrapper methodWrapper = classWrapper.getMethodWrapper(mt.getName(), mt.getDescriptor());
        MethodWrapper outerWrapper = (MethodWrapper)DecompilerContext.getProperty("CURRENT_METHOD_WRAPPER");
        DecompilerContext.setProperty("CURRENT_METHOD_WRAPPER", methodWrapper);
        try {
            String method_name = lambdaNode.lambdaInformation.method_name;
            MethodDescriptor md_content = MethodDescriptor.parseDescriptor(lambdaNode.lambdaInformation.content_method_descriptor);
            MethodDescriptor md_lambda = MethodDescriptor.parseDescriptor(lambdaNode.lambdaInformation.method_descriptor);
            if (!codeOnly) {
                buffer.appendIndent(indent);
                buffer.append("public ");
                buffer.append(method_name);
                buffer.append("(");
                boolean firstParameter = true;
                int index = lambdaNode.lambdaInformation.is_content_method_static ? 0 : 1;
                int start_index = md_content.params.length - md_lambda.params.length;
                for (int i = 0; i < md_content.params.length; ++i) {
                    if (i >= start_index) {
                        String typeName;
                        if (!firstParameter) {
                            buffer.append(", ");
                        }
                        if ("<undefinedtype>".equals(typeName = ExprProcessor.getCastTypeName(md_content.params[i].copy(), Collections.emptyList())) && DecompilerContext.getOption("uto")) {
                            typeName = ExprProcessor.getCastTypeName(VarType.VARTYPE_OBJECT, Collections.emptyList());
                        }
                        buffer.append(typeName);
                        buffer.append(" ");
                        Object parameterName = methodWrapper.varproc.getVarName(new VarVersion(index, 0));
                        if (parameterName == null) {
                            parameterName = "param" + index;
                        }
                        parameterName = methodWrapper.methodStruct.getVariableNamer().renameParameter(mt.getAccessFlags(), typeName, (String)parameterName, index);
                        buffer.append((String)parameterName);
                        firstParameter = false;
                    }
                    index += md_content.params[i].getStackSize();
                }
                buffer.append(") {").appendLineSeparator();
                ++indent;
            }
            RootStatement root = classWrapper.getMethodWrapper((String)mt.getName(), (String)mt.getDescriptor()).root;
            if (!methodWrapper.decompiledWithErrors && root != null) {
                try {
                    buffer.append(root.toJava(indent, tracer));
                }
                catch (Throwable t) {
                    String message = "Method " + mt.getName() + " " + mt.getDescriptor() + " couldn't be written.";
                    DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.WARN, t);
                    methodWrapper.decompiledWithErrors = true;
                }
            }
            if (methodWrapper.decompiledWithErrors) {
                buffer.appendIndent(indent);
                if (methodWrapper.decompiledWithErrorsMessage != null) {
                    buffer.append("// $FF: " + methodWrapper.decompiledWithErrorsMessage);
                } else {
                    buffer.append("// $FF: Couldn't be decompiled");
                }
                buffer.appendLineSeparator();
            }
            if (root != null) {
                tracer.addMapping(root.getDummyExit().bytecode);
            }
            if (!codeOnly) {
                buffer.appendIndent(--indent).append('}').appendLineSeparator();
            }
        }
        finally {
            DecompilerContext.setProperty("CURRENT_METHOD_WRAPPER", outerWrapper);
        }
    }

    private static String toValidJavaIdentifier(String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        boolean changed = false;
        StringBuilder res = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (i == 0 && !Character.isJavaIdentifierStart(c) || i > 0 && !Character.isJavaIdentifierPart(c)) {
                changed = true;
                res.append("_");
                continue;
            }
            res.append(c);
        }
        if (!changed) {
            return name;
        }
        return res.append("/* $FF was: ").append(name).append("*/").toString();
    }

    private static void recordComponentToJava(StructRecordComponent cd, TextBuffer buffer, boolean varArgComponent) {
        Map.Entry<VarType, GenericFieldDescriptor> fieldTypeData = ClassWriter.getFieldTypeData(cd);
        VarType fieldType = fieldTypeData.getKey();
        GenericFieldDescriptor descriptor = fieldTypeData.getValue();
        ClassWriter.appendAnnotations(buffer, -1, cd);
        List<TypeAnnotation> typeAnnotations = TypeAnnotation.listFrom(cd);
        if (descriptor != null) {
            buffer.append(ExprProcessor.getCastTypeName(varArgComponent ? descriptor.type.decreaseArrayDim() : descriptor.type, TypeAnnotationWriteHelper.create(typeAnnotations)));
        } else {
            buffer.append(ExprProcessor.getCastTypeName(varArgComponent ? fieldType.decreaseArrayDim() : fieldType, TypeAnnotationWriteHelper.create(typeAnnotations)));
        }
        if (varArgComponent) {
            buffer.append("...");
        }
        buffer.append(' ');
        buffer.append(cd.getName());
    }

    private static boolean hideConstructor(ClassesProcessor.ClassNode node, boolean hasAnnotation, boolean init, boolean throwsExceptions, int paramCount, int methodAccessFlags) {
        boolean isEnum;
        if (!init || hasAnnotation || throwsExceptions || paramCount > 0 || !DecompilerContext.getOption("hdc")) {
            return false;
        }
        StructClass cl = node.getWrapper().getClassStruct();
        int classAccessFlags = node.type == 0 ? cl.getAccessFlags() : node.access;
        boolean bl = isEnum = cl.hasModifier(16384) && DecompilerContext.getOption("den");
        if (!isEnum && (classAccessFlags & 7) != (methodAccessFlags & 7)) {
            return false;
        }
        int count = 0;
        for (StructMethod mt : cl.getMethods()) {
            if (!"<init>".equals(mt.getName()) || ++count <= 1) continue;
            return false;
        }
        return true;
    }

    private static Map.Entry<VarType, GenericFieldDescriptor> getFieldTypeData(StructField fd) {
        VarType fieldType = new VarType(fd.getDescriptor(), false);
        GenericFieldDescriptor descriptor = fd.getSignature();
        return new AbstractMap.SimpleImmutableEntry<VarType, GenericFieldDescriptor>(fieldType, descriptor);
    }

    private static void appendDeprecation(TextBuffer buffer, int indent) {
        buffer.appendIndent(indent).append("/** @deprecated */").appendLineSeparator();
    }

    private static void appendRenameComment(TextBuffer buffer, String oldName, MType type, int indent) {
        if (oldName == null) {
            return;
        }
        buffer.appendIndent(indent);
        buffer.append("// $FF: renamed from: ");
        switch (type.ordinal()) {
            case 0: {
                buffer.append(ExprProcessor.buildJavaClassName(oldName));
                break;
            }
            case 1: {
                String[] fParts = oldName.split(" ");
                FieldDescriptor fd = FieldDescriptor.parseDescriptor(fParts[2]);
                buffer.append(fParts[1]);
                buffer.append(' ');
                buffer.append(ClassWriter.getTypePrintOut(fd.type));
                break;
            }
            default: {
                String[] mParts = oldName.split(" ");
                MethodDescriptor md = MethodDescriptor.parseDescriptor(mParts[2]);
                buffer.append(mParts[1]);
                buffer.append(" (");
                boolean first = true;
                for (VarType paramType : md.params) {
                    if (!first) {
                        buffer.append(", ");
                    }
                    first = false;
                    buffer.append(ClassWriter.getTypePrintOut(paramType));
                }
                buffer.append(") ");
                buffer.append(ClassWriter.getTypePrintOut(md.ret));
            }
        }
        buffer.appendLineSeparator();
    }

    private static String getTypePrintOut(VarType type) {
        String typeText = ExprProcessor.getCastTypeName(type, false, Collections.emptyList());
        if ("<undefinedtype>".equals(typeText) && DecompilerContext.getOption("uto")) {
            typeText = ExprProcessor.getCastTypeName(VarType.VARTYPE_OBJECT, false, Collections.emptyList());
        }
        return typeText;
    }

    private static void appendComment(TextBuffer buffer, String comment, int indent) {
        buffer.appendIndent(indent).append("// $FF: ").append(comment).appendLineSeparator();
    }

    private static void appendAnnotations(TextBuffer buffer, int indent, StructMember mb) {
        for (StructGeneralAttribute.Key<?> key : StructGeneralAttribute.ANNOTATION_ATTRIBUTES) {
            StructAnnotationAttribute attribute = (StructAnnotationAttribute)mb.getAttribute(key);
            if (attribute == null) continue;
            for (AnnotationExprent annotation : attribute.getAnnotations()) {
                if (mb.memberAnnCollidesWithTypeAnnotation(annotation)) continue;
                String text = annotation.toJava(indent, BytecodeMappingTracer.DUMMY).toString();
                buffer.append(text);
                if (indent < 0) {
                    buffer.append(' ');
                    continue;
                }
                buffer.appendLineSeparator();
            }
        }
    }

    private static void appendParameterAnnotations(TextBuffer buffer, StructMethod mt, @NotNull Type type, int param) {
        List<AnnotationExprent> exprents = ClassWriter.collectParameterAnnotations(mt, type, param);
        for (AnnotationExprent annotation : exprents) {
            String text = annotation.toJava(-1, BytecodeMappingTracer.DUMMY).toString();
            buffer.append(text).append(' ');
        }
    }

    private static void appendModifiers(TextBuffer buffer, int flags, int allowed, boolean isInterface, int excluded) {
        flags &= allowed;
        if (!isInterface) {
            excluded = 0;
        }
        for (int modifier : MODIFIERS.keySet()) {
            if ((flags & modifier) != modifier || (modifier & excluded) != 0) continue;
            buffer.append(MODIFIERS.get(modifier)).append(' ');
        }
    }

    public static String getModifiers(int flags) {
        return MODIFIERS.entrySet().stream().filter(e -> ((Integer)e.getKey() & flags) != 0).map(Map.Entry::getValue).collect(Collectors.joining(" "));
    }

    public static void appendTypeParameters(TextBuffer buffer, List<String> parameters, List<List<VarType>> bounds, List<TypeAnnotation> typeAnnotations) {
        buffer.append('<');
        for (int i = 0; i < parameters.size(); ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            TargetInfo.TypeParameterTarget.extract(typeAnnotations, i).forEach(typeAnnotation -> typeAnnotation.writeTo(buffer));
            buffer.append(parameters.get(i));
            List<VarType> parameterBounds = bounds.get(i);
            List<TypeAnnotation> firstTypeAnnotations = TargetInfo.TypeParameterBoundTarget.extract(typeAnnotations, i, 0);
            if (parameterBounds.size() <= 1 && (parameterBounds.size() != 1 || "java/lang/Object".equals(parameterBounds.getFirst().getValue())) && firstTypeAnnotations.isEmpty()) continue;
            buffer.append(" extends ");
            firstTypeAnnotations.forEach(typeAnnotation -> typeAnnotation.writeTo(buffer));
            buffer.append(ExprProcessor.getCastTypeName(parameterBounds.getFirst(), Collections.emptyList()));
            for (int j = 1; j < parameterBounds.size(); ++j) {
                buffer.append(" & ");
                TargetInfo.TypeParameterBoundTarget.extract(typeAnnotations, i, j).forEach(typeAnnotation -> typeAnnotation.writeTo(buffer));
                buffer.append(ExprProcessor.getCastTypeName(parameterBounds.get(j), Collections.emptyList()));
            }
        }
        buffer.append('>');
    }

    private static void appendFQClassNames(TextBuffer buffer, List<String> names) {
        for (int i = 0; i < names.size(); ++i) {
            String name = names.get(i);
            buffer.appendIndent(2).append(name);
            if (i >= names.size() - 1) continue;
            buffer.append(',').appendLineSeparator();
        }
    }

    static {
        MODIFIERS.put(1, "public");
        MODIFIERS.put(4, "protected");
        MODIFIERS.put(2, "private");
        MODIFIERS.put(1024, "abstract");
        MODIFIERS.put(8, "static");
        MODIFIERS.put(16, "final");
        MODIFIERS.put(2048, "strictfp");
        MODIFIERS.put(128, "transient");
        MODIFIERS.put(64, "volatile");
        MODIFIERS.put(32, "synchronized");
        MODIFIERS.put(256, "native");
    }

    private record AnnotationContainer(Set<AnnotationExprent> memberAnnotation, Set<TypeAnnotationModel> typeAnnotationModel) {
        public boolean containsAll(AnnotationContainer other) {
            return this.memberAnnotation.containsAll(other.memberAnnotation) && this.typeAnnotationModel.containsAll(other.typeAnnotationModel);
        }

        private record TypeAnnotationModel(AnnotationExprent annotation, List<StructTypePathEntry> paths) {
        }
    }

    private static enum MType {
        CLASS,
        FIELD,
        METHOD;

    }

    record RecordConstructorContext(boolean hideConstructor, boolean compact) {
    }
}

