/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main.collectors;

import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.decompiler.code.cfg.ControlFlowGraph;
import org.jetbrains.java.decompiler.util.SFormsFastMapDirect;

public class LimitContainer {
    private final int maxDirectNodeCount;
    @NotNull
    private final AtomicLong directNodeCount = new AtomicLong();
    private final int ssaConstructorSparseExRecordCount;

    public LimitContainer(@NotNull Map<String, Object> properties) {
        this.maxDirectNodeCount = (Integer)properties.getOrDefault("mdnc", -1);
        this.ssaConstructorSparseExRecordCount = (Integer)properties.getOrDefault("mdvnc", -1);
    }

    public void incrementAndCheckDirectNodeCount(@NotNull ControlFlowGraph graph) {
        long newValue = this.directNodeCount.addAndGet(graph.getBlocks().size());
        if (this.maxDirectNodeCount != -1 && newValue >= (long)this.maxDirectNodeCount) {
            throw new LimitExceededDecompilerException(this.maxDirectNodeCount, newValue, "direct nodes");
        }
    }

    public void checkSFormsFastMapDirect(@NotNull Map<String, SFormsFastMapDirect> inVarVersions, @NotNull Map<String, SFormsFastMapDirect> outVarVersions) {
        int newValue = inVarVersions.size() + outVarVersions.size();
        if (this.ssaConstructorSparseExRecordCount != -1 && newValue > this.ssaConstructorSparseExRecordCount) {
            throw new LimitExceededDecompilerException(this.ssaConstructorSparseExRecordCount, newValue, "variable nodes");
        }
    }

    public static class LimitExceededDecompilerException
    extends RuntimeException {
        public LimitExceededDecompilerException(long limit, long actualValue, String type) {
            super("Limits for %s are exceeded. Current value: %s, limit: %s".formatted(type, actualValue, limit));
        }
    }
}

