# EC3 Python Wrapper
<p align="center"><img width="200" src="https://github.com/jbf1212/example-app-ec3-wrapper/blob/main/images/ec3_wrapper_logo.png"</p>

This is a Python wrapper for working with the Building Transparency EC3 API.
Documentation for the EC3 API can be found at [https://buildingtransparency.org/ec3/manage-apps/api-doc/api](https://buildingtransparency.org/ec3/manage-apps/api-doc/api)

This project is still early in development. Further documentation and functionality will continue to evolve as the project progresses.

## Installing

```
pip install ec3-python-wrapper
```

## Documentation

For documentation on how to use the EC3 Python Wrapper visit:
[https://ec3-python-wrapper.readthedocs.io/](https://ec3-python-wrapper.readthedocs.io/)

### Usage Examples

Some Jupyter Notebook examples are provided here:

* Overview of some available functions: [ec3_overview.ipynb](ec3_overview.ipynb)
* Querying and plotting materials: [ec3_materials_plot.ipynb](ec3_materials_plot.ipynb)

A Streamlit example app can be found here:
* EC3 Concrete Carbon Comparison by postal Code: [![Streamlit App](https://static.streamlit.io/badges/streamlit_badge_black_white.svg)](https://jbf1212-example-app-ec3-wrapper-ec3-app-bd2ea4.streamlit.app/)

## Credits

* Obviously none of this would exist without the great efforts of the [Building Transparency](https://buildingtransparency.org/ec3) team and the EC3 database.
* Much of how this library has been structured was modeled off of the amazing work done on the [pyAirtable module](https://github.com/gtalarico/pyairtable).

## License
[MIT](https://opensource.org/licenses/MIT)
