from setuptools import find_packages, setup

with open("README.md", "r") as fh:
    description = fh.read()

setup(
    name="ecv-python-development",
    version="0.0.54",
    author="Warren Ezra Bruce Jaudian",
    author_email="warren.jaudian@ecloudvalley.com",
    packages=find_packages(),
    description="ECV Python Development Package",
    long_description=description,
    long_description_content_type="text/markdown",
    url="https://git-codecommit.ap-southeast-1.amazonaws.com/v1/repos/ecv-python-development",
    license="MIT",
    python_requires=">=3.9",
    install_requires=[
        "pydantic==2.7.1",
        "aws-lambda-powertools",
        "pytz==2022.7",
        "aws_encryption_sdk",
        "pynamodb==6.0.0",
        "pydantic[email]",
        "requests",
        "cerberus",
        "jsonpickle",
        "typing_extensions",
        "mypy-boto3-cognito-idp",
        "mypy-boto3-ssm",
        "mypy-boto3-secretsmanager",
        "mypy-boto3-sqs",
        "mypy-boto3-sns",
        "mypy-boto3-ses",
        "mypy-boto3-lambda",
        "mypy-boto3-events",
        "mypy-boto3-kms",
        "mypy-boto3-s3",
        "mypy-boto3-dynamodb",
        "boto3==1.26.86",
        "botocore==1.29.86",
        "boto3-stubs[cognito-idp]",
        "boto3-stubs[ssm]",
        "boto3-stubs[secretsmanager]",
        "boto3-stubs[sqs]",
        "boto3-stubs[sns]",
        "boto3-stubs[ses]",
        "boto3-stubs[lambda]",
        "boto3-stubs[events]",
        "boto3-stubs[kms]",
        "boto3-stubs[s3]",
        "boto3-stubs[dynamodb]",
    ],
    package_data={
        "ecv_python_development": [
            "ecv_python_development/*",
            "py.typed",
        ],
    },
)
