"""Unicode Properties from Unicode version 13.0.0 (autogen)."""
from __future__ import annotations

unicode_bidi_classes: dict[str, str] = {
    "^al": "\x00-\u0607\u0609-\u060a\u060c\u060e-\u061a\u061d\u064b-\u066c\u0670\u06d6-\u06e4\u06e7-\u06ed\u06f0-\u06f9\u070e\u0711\u0730-\u074c\u07a6-\u07b0\u07b2-\u085f\u086b-\u089f\u08b5\u08c8-\ufb4f\ufbc2-\ufbd2\ufd3e-\ufd4f\ufd90-\ufd91\ufdc8-\ufdef\ufdfd-\ufe6f\ufe75\ufefd-\U00010cff\U00010d24-\U00010f2f\U00010f46-\U00010f50\U00010f5a-\U0001ec70\U0001ecb5-\U0001ed00\U0001ed3e-\U0001edff\U0001ee04\U0001ee20\U0001ee23\U0001ee25-\U0001ee26\U0001ee28\U0001ee33\U0001ee38\U0001ee3a\U0001ee3c-\U0001ee41\U0001ee43-\U0001ee46\U0001ee48\U0001ee4a\U0001ee4c\U0001ee50\U0001ee53\U0001ee55-\U0001ee56\U0001ee58\U0001ee5a\U0001ee5c\U0001ee5e\U0001ee60\U0001ee63\U0001ee65-\U0001ee66\U0001ee6b\U0001ee73\U0001ee78\U0001ee7d\U0001ee7f\U0001ee8a\U0001ee9c-\U0001eea0\U0001eea4\U0001eeaa\U0001eebc-\U0010ffff",
    "^an": "\x00-\u05ff\u0606-\u065f\u066a\u066d-\u06dc\u06de-\u08e1\u08e3-\U00010d2f\U00010d3a-\U00010e5f\U00010e7f-\U0010ffff",
    "^b": "\x00-\x09\x0b-\x0c\x0e-\x1b\x1f-\x84\x86-\u2028\u202a-\U0010ffff",
    "^bn": "\x09-\x0d\x1c-\x5c\x7e\x85\xa0-\xac\xae-\u180d\u180f-\u200a\u200e-\u205f\u2065-\u2069\u2070-\ufefe\uff00-\U0001bc9f\U0001bca4-\U0001d172\U0001d17b-\U000e0000\U000e0002-\U000e001f\U000e0080-\U0010ffff",
    "^cs": "\x00-\x2b\x5c\x2d\x30-\x39\x3b-\x9f\xa1-\u060b\u060d-\u202e\u2030-\u2043\u2045-\ufe4f\ufe51\ufe53-\ufe54\ufe56-\uff0b\uff0d\uff10-\uff19\uff1b-\U0010ffff",
    "^en": "\x00-\x2f\x3a-\xb1\xb4-\xb8\xba-\u06ef\u06fa-\u206f\u2071-\u2073\u207a-\u207f\u208a-\u2487\u249c-\uff0f\uff1a-\U000102e0\U000102fc-\U0001d7cd\U0001d800-\U0001f0ff\U0001f10b-\U0001fbef\U0001fbfa-\U0010ffff",
    "^es": "\x00-\x2a\x2c\x2e-\u2079\u207c-\u2089\u208c-\u2211\u2213-\ufb28\ufb2a-\ufe61\ufe64-\uff0a\uff0c\uff0e-\U0010ffff",
    "^et": "\x00-\x22\x5c\x26-\xa1\xa6-\xaf\xb2-\u058e\u0590-\u0608\u060b-\u0669\u066b-\u09f1\u09f4-\u09fa\u09fc-\u0af0\u0af2-\u0bf8\u0bfa-\u0e3e\u0e40-\u17da\u17dc-\u202f\u2035-\u209f\u20c0-\u212d\u212f-\u2212\u2214-\ua837\ua83a-\ufe5e\ufe60-\ufe68\ufe6b-\uff02\uff06-\uffdf\uffe2-\uffe4\uffe7-\U00011fdc\U00011fe1-\U0001e2fe\U0001e300-\U0010ffff",
    "^fsi": "\x00-\u2067\u2069-\U0010ffff",
    "^l": "\x00-\x40\x5c\x5b-\x60\x7b-\xa9\xab-\xb4\xb6-\xb9\xbb-\xbf\xd7\xf7\u02b9-\u02ba\u02c2-\u02cf\u02d2-\u02df\u02e5-\u02ed\u02ef-\u036f\u0374-\u0375\u0378-\u0379\u037e\u0380-\u0385\u0387\u038b\u038d\u03a2\u03f6\u0483-\u0489\u0530\u0557-\u0558\u058a-\u0902\u093a\u093c\u0941-\u0948\u094d\u0951-\u0957\u0962-\u0963\u0981\u0984\u098d-\u098e\u0991-\u0992\u09a9\u09b1\u09b3-\u09b5\u09ba-\u09bc\u09c1-\u09c6\u09c9-\u09ca\u09cd\u09cf-\u09d6\u09d8-\u09db\u09de\u09e2-\u09e5\u09f2-\u09f3\u09fb\u09fe-\u0a02\u0a04\u0a0b-\u0a0e\u0a11-\u0a12\u0a29\u0a31\u0a34\u0a37\u0a3a-\u0a3d\u0a41-\u0a58\u0a5d\u0a5f-\u0a65\u0a70-\u0a71\u0a75\u0a77-\u0a82\u0a84\u0a8e\u0a92\u0aa9\u0ab1\u0ab4\u0aba-\u0abc\u0ac1-\u0ac8\u0aca\u0acd-\u0acf\u0ad1-\u0adf\u0ae2-\u0ae5\u0af1-\u0af8\u0afa-\u0b01\u0b04\u0b0d-\u0b0e\u0b11-\u0b12\u0b29\u0b31\u0b34\u0b3a-\u0b3c\u0b3f\u0b41-\u0b46\u0b49-\u0b4a\u0b4d-\u0b56\u0b58-\u0b5b\u0b5e\u0b62-\u0b65\u0b78-\u0b82\u0b84\u0b8b-\u0b8d\u0b91\u0b96-\u0b98\u0b9b\u0b9d\u0ba0-\u0ba2\u0ba5-\u0ba7\u0bab-\u0bad\u0bba-\u0bbd\u0bc0\u0bc3-\u0bc5\u0bc9\u0bcd-\u0bcf\u0bd1-\u0bd6\u0bd8-\u0be5\u0bf3-\u0c00\u0c04\u0c0d\u0c11\u0c29\u0c3a-\u0c3c\u0c3e-\u0c40\u0c45-\u0c57\u0c5b-\u0c5f\u0c62-\u0c65\u0c70-\u0c76\u0c78-\u0c7e\u0c81\u0c8d\u0c91\u0ca9\u0cb4\u0cba-\u0cbc\u0cc5\u0cc9\u0ccc-\u0cd4\u0cd7-\u0cdd\u0cdf\u0ce2-\u0ce5\u0cf0\u0cf3-\u0d01\u0d0d\u0d11\u0d3b-\u0d3c\u0d41-\u0d45\u0d49\u0d4d\u0d50-\u0d53\u0d62-\u0d65\u0d80-\u0d81\u0d84\u0d97-\u0d99\u0db2\u0dbc\u0dbe-\u0dbf\u0dc7-\u0dce\u0dd2-\u0dd7\u0de0-\u0de5\u0df0-\u0df1\u0df5-\u0e00\u0e31\u0e34-\u0e3f\u0e47-\u0e4e\u0e5c-\u0e80\u0e83\u0e85\u0e8b\u0ea4\u0ea6\u0eb1\u0eb4-\u0ebc\u0ebe-\u0ebf\u0ec5\u0ec7-\u0ecf\u0eda-\u0edb\u0ee0-\u0eff\u0f18-\u0f19\u0f35\u0f37\u0f39-\u0f3d\u0f48\u0f6d-\u0f7e\u0f80-\u0f84\u0f86-\u0f87\u0f8d-\u0fbd\u0fc6\u0fcd\u0fdb-\u0fff\u102d-\u1030\u1032-\u1037\u1039-\u103a\u103d-\u103e\u1058-\u1059\u105e-\u1060\u1071-\u1074\u1082\u1085-\u1086\u108d\u109d\u10c6\u10c8-\u10cc\u10ce-\u10cf\u1249\u124e-\u124f\u1257\u1259\u125e-\u125f\u1289\u128e-\u128f\u12b1\u12b6-\u12b7\u12bf\u12c1\u12c6-\u12c7\u12d7\u1311\u1316-\u1317\u135b-\u135f\u137d-\u137f\u1390-\u139f\u13f6-\u13f7\u13fe-\u1400\u1680\u169b-\u169f\u16f9-\u16ff\u170d\u1712-\u171f\u1732-\u1734\u1737-\u173f\u1752-\u175f\u176d\u1771-\u177f\u17b4-\u17b5\u17b7-\u17bd\u17c6\u17c9-\u17d3\u17db\u17dd-\u17df\u17ea-\u180f\u181a-\u181f\u1879-\u187f\u1885-\u1886\u18a9\u18ab-\u18af\u18f6-\u18ff\u191f-\u1922\u1927-\u1928\u192c-\u192f\u1932\u1939-\u1945\u196e-\u196f\u1975-\u197f\u19ac-\u19af\u19ca-\u19cf\u19db-\u19ff\u1a17-\u1a18\u1a1b-\u1a1d\u1a56\u1a58-\u1a60\u1a62\u1a65-\u1a6c\u1a73-\u1a7f\u1a8a-\u1a8f\u1a9a-\u1a9f\u1aae-\u1b03\u1b34\u1b36-\u1b3a\u1b3c\u1b42\u1b4c-\u1b4f\u1b6b-\u1b73\u1b7d-\u1b81\u1ba2-\u1ba5\u1ba8-\u1ba9\u1bab-\u1bad\u1be6\u1be8-\u1be9\u1bed\u1bef-\u1bf1\u1bf4-\u1bfb\u1c2c-\u1c33\u1c36-\u1c3a\u1c4a-\u1c4c\u1c89-\u1c8f\u1cbb-\u1cbc\u1cc8-\u1cd2\u1cd4-\u1ce0\u1ce2-\u1ce8\u1ced\u1cf4\u1cf8-\u1cf9\u1cfb-\u1cff\u1dc0-\u1dff\u1f16-\u1f17\u1f1e-\u1f1f\u1f46-\u1f47\u1f4e-\u1f4f\u1f58\u1f5a\u1f5c\u1f5e\u1f7e-\u1f7f\u1fb5\u1fbd\u1fbf-\u1fc1\u1fc5\u1fcd-\u1fcf\u1fd4-\u1fd5\u1fdc-\u1fdf\u1fed-\u1ff1\u1ff5\u1ffd-\u200d\u200f-\u2070\u2072-\u207e\u2080-\u208f\u209d-\u2101\u2103-\u2106\u2108-\u2109\u2114\u2116-\u2118\u211e-\u2123\u2125\u2127\u2129\u212e\u213a-\u213b\u2140-\u2144\u214a-\u214d\u2150-\u215f\u2189-\u2335\u237b-\u2394\u2396-\u249b\u24ea-\u26ab\u26ad-\u27ff\u2900-\u2bff\u2c2f\u2c5f\u2ce5-\u2cea\u2cef-\u2cf1\u2cf4-\u2cff\u2d26\u2d28-\u2d2c\u2d2e-\u2d2f\u2d68-\u2d6e\u2d71-\u2d7f\u2d97-\u2d9f\u2da7\u2daf\u2db7\u2dbf\u2dc7\u2dcf\u2dd7\u2ddf-\u3004\u3008-\u3020\u302a-\u302d\u3030\u3036-\u3037\u303d-\u3040\u3097-\u309c\u30a0\u30fb\u3100-\u3104\u3130\u318f\u31c0-\u31ef\u321d-\u321f\u3250-\u325f\u327c-\u327e\u32b1-\u32bf\u32cc-\u32cf\u3377-\u337a\u33de-\u33df\u33ff\u3401-\u4dbe\u4dc0-\u4dff\u4e01-\u9ffb\u9ffd-\u9fff\ua48d-\ua4cf\ua60d-\ua60f\ua62c-\ua63f\ua66f-\ua67f\ua69e-\ua69f\ua6f0-\ua6f1\ua6f8-\ua721\ua788\ua7c0-\ua7c1\ua7cb-\ua7f4\ua802\ua806\ua80b\ua825-\ua826\ua828-\ua82f\ua838-\ua83f\ua874-\ua87f\ua8c4-\ua8cd\ua8da-\ua8f1\ua8ff\ua926-\ua92d\ua947-\ua951\ua954-\ua95e\ua97d-\ua982\ua9b3\ua9b6-\ua9b9\ua9bc-\ua9bd\ua9ce\ua9da-\ua9dd\ua9e5\ua9ff\uaa29-\uaa2e\uaa31-\uaa32\uaa35-\uaa3f\uaa43\uaa4c\uaa4e-\uaa4f\uaa5a-\uaa5b\uaa7c\uaab0\uaab2-\uaab4\uaab7-\uaab8\uaabe-\uaabf\uaac1\uaac3-\uaada\uaaec-\uaaed\uaaf6-\uab00\uab07-\uab08\uab0f-\uab10\uab17-\uab1f\uab27\uab2f\uab6a-\uab6f\uabe5\uabe8\uabed-\uabef\uabfa-\uabff\uac01-\ud7a2\ud7a4-\ud7af\ud7c7-\ud7ca\ud7fc-\ud7ff\ud801-\udb7e\udb81-\udbfe\udc01-\udffe\ue001-\uf8fe\ufa6e-\ufa6f\ufada-\ufaff\ufb07-\ufb12\ufb18-\uff20\uff3b-\uff40\uff5b-\uff65\uffbf-\uffc1\uffc8-\uffc9\uffd0-\uffd1\uffd8-\uffd9\uffdd-\uffff\U0001000c\U00010027\U0001003b\U0001003e\U0001004e-\U0001004f\U0001005e-\U0001007f\U000100fb-\U000100ff\U00010101\U00010103-\U00010106\U00010134-\U00010136\U00010140-\U0001018c\U0001018f-\U000101cf\U000101fd-\U0001027f\U0001029d-\U0001029f\U000102d1-\U000102ff\U00010324-\U0001032c\U0001034b-\U0001034f\U00010376-\U0001037f\U0001039e\U000103c4-\U000103c7\U000103d6-\U000103ff\U0001049e-\U0001049f\U000104aa-\U000104af\U000104d4-\U000104d7\U000104fc-\U000104ff\U00010528-\U0001052f\U00010564-\U0001056e\U00010570-\U000105ff\U00010737-\U0001073f\U00010756-\U0001075f\U00010768-\U00010fff\U00011001\U00011038-\U00011046\U0001104e-\U00011065\U00011070-\U00011081\U000110b3-\U000110b6\U000110b9-\U000110ba\U000110c2-\U000110cc\U000110ce-\U000110cf\U000110e9-\U000110ef\U000110fa-\U00011102\U00011127-\U0001112b\U0001112d-\U00011135\U00011148-\U0001114f\U00011173\U00011177-\U00011181\U000111b6-\U000111be\U000111c9-\U000111cc\U000111cf\U000111e0\U000111f5-\U000111ff\U00011212\U0001122f-\U00011231\U00011234\U00011236-\U00011237\U0001123e-\U0001127f\U00011287\U00011289\U0001128e\U0001129e\U000112aa-\U000112af\U000112df\U000112e3-\U000112ef\U000112fa-\U00011301\U00011304\U0001130d-\U0001130e\U00011311-\U00011312\U00011329\U00011331\U00011334\U0001133a-\U0001133c\U00011340\U00011345-\U00011346\U00011349-\U0001134a\U0001134e-\U0001134f\U00011351-\U00011356\U00011358-\U0001135c\U00011364-\U000113ff\U00011438-\U0001143f\U00011442-\U00011444\U00011446\U0001145c\U0001145e\U00011462-\U0001147f\U000114b3-\U000114b8\U000114ba\U000114bf-\U000114c0\U000114c2-\U000114c3\U000114c8-\U000114cf\U000114da-\U0001157f\U000115b2-\U000115b7\U000115bc-\U000115bd\U000115bf-\U000115c0\U000115dc-\U000115ff\U00011633-\U0001163a\U0001163d\U0001163f-\U00011640\U00011645-\U0001164f\U0001165a-\U0001167f\U000116ab\U000116ad\U000116b0-\U000116b5\U000116b7\U000116b9-\U000116bf\U000116ca-\U000116ff\U0001171b-\U0001171f\U00011722-\U00011725\U00011727-\U0001172f\U00011740-\U000117ff\U0001182f-\U00011837\U00011839-\U0001183a\U0001183c-\U0001189f\U000118f3-\U000118fe\U00011907-\U00011908\U0001190a-\U0001190b\U00011914\U00011917\U00011936\U00011939-\U0001193c\U0001193e\U00011943\U00011947-\U0001194f\U0001195a-\U0001199f\U000119a8-\U000119a9\U000119d4-\U000119db\U000119e0\U000119e5-\U000119ff\U00011a01-\U00011a06\U00011a09-\U00011a0a\U00011a33-\U00011a38\U00011a3b-\U00011a3e\U00011a47-\U00011a4f\U00011a51-\U00011a56\U00011a59-\U00011a5b\U00011a8a-\U00011a96\U00011a98-\U00011a99\U00011aa3-\U00011abf\U00011af9-\U00011bff\U00011c09\U00011c30-\U00011c3d\U00011c46-\U00011c4f\U00011c6d-\U00011c6f\U00011c90-\U00011ca8\U00011caa-\U00011cb0\U00011cb2-\U00011cb3\U00011cb5-\U00011cff\U00011d07\U00011d0a\U00011d31-\U00011d45\U00011d47-\U00011d4f\U00011d5a-\U00011d5f\U00011d66\U00011d69\U00011d8f-\U00011d92\U00011d95\U00011d97\U00011d99-\U00011d9f\U00011daa-\U00011edf\U00011ef3-\U00011ef4\U00011ef9-\U00011faf\U00011fb1-\U00011fbf\U00011fd5-\U00011ffe\U0001239a-\U000123ff\U0001246f\U00012475-\U0001247f\U00012544-\U00012fff\U0001342f\U00013439-\U000143ff\U00014647-\U000167ff\U00016a39-\U00016a3f\U00016a5f\U00016a6a-\U00016a6d\U00016a70-\U00016acf\U00016aee-\U00016af4\U00016af6-\U00016aff\U00016b30-\U00016b36\U00016b46-\U00016b4f\U00016b5a\U00016b62\U00016b78-\U00016b7c\U00016b90-\U00016e3f\U00016e9b-\U00016eff\U00016f4b-\U00016f4f\U00016f88-\U00016f92\U00016fa0-\U00016fdf\U00016fe2\U00016fe4-\U00016fef\U00016ff2-\U00016fff\U00017001-\U000187f6\U000187f8-\U000187ff\U00018cd6-\U00018cff\U00018d01-\U00018d07\U00018d09-\U0001afff\U0001b11f-\U0001b14f\U0001b153-\U0001b163\U0001b168-\U0001b16f\U0001b2fc-\U0001bbff\U0001bc6b-\U0001bc6f\U0001bc7d-\U0001bc7f\U0001bc89-\U0001bc8f\U0001bc9a-\U0001bc9b\U0001bc9d-\U0001bc9e\U0001bca0-\U0001cfff\U0001d0f6-\U0001d0ff\U0001d127-\U0001d128\U0001d167-\U0001d169\U0001d173-\U0001d182\U0001d185-\U0001d18b\U0001d1aa-\U0001d1ad\U0001d1e9-\U0001d2df\U0001d2f4-\U0001d35f\U0001d379-\U0001d3ff\U0001d455\U0001d49d\U0001d4a0-\U0001d4a1\U0001d4a3-\U0001d4a4\U0001d4a7-\U0001d4a8\U0001d4ad\U0001d4ba\U0001d4bc\U0001d4c4\U0001d506\U0001d50b-\U0001d50c\U0001d515\U0001d51d\U0001d53a\U0001d53f\U0001d545\U0001d547-\U0001d549\U0001d551\U0001d6a6-\U0001d6a7\U0001d6db\U0001d715\U0001d74f\U0001d789\U0001d7c3\U0001d7cc-\U0001d7ff\U0001da00-\U0001da36\U0001da3b-\U0001da6c\U0001da75\U0001da84\U0001da8c-\U0001e0ff\U0001e12d-\U0001e136\U0001e13e-\U0001e13f\U0001e14a-\U0001e14d\U0001e150-\U0001e2bf\U0001e2ec-\U0001e2ef\U0001e2fa-\U0001f10f\U0001f12f\U0001f16a-\U0001f16f\U0001f1ad-\U0001f1e5\U0001f203-\U0001f20f\U0001f23c-\U0001f23f\U0001f249-\U0001f24f\U0001f252-\U0001ffff\U00020001-\U0002a6dc\U0002a6de-\U0002a6ff\U0002a701-\U0002b733\U0002b735-\U0002b73f\U0002b741-\U0002b81c\U0002b81e-\U0002b81f\U0002b821-\U0002cea0\U0002cea2-\U0002ceaf\U0002ceb1-\U0002ebdf\U0002ebe1-\U0002f7ff\U0002fa1e-\U0002ffff\U00030001-\U00031349\U0003134b-\U000effff\U000f0001-\U000ffffc\U000ffffe-\U000fffff\U00100001-\U0010fffc\U0010fffe-\U0010ffff",
    "^lre": "\x00-\u2029\u202b-\U0010ffff",
    "^lri": "\x00-\u2065\u2067-\U0010ffff",
    "^lro": "\x00-\u202c\u202e-\U0010ffff",
    "^nsm": "\x00-\u02ff\u0370-\u0482\u048a-\u0590\u05be\u05c0\u05c3\u05c6\u05c8-\u060f\u061b-\u064a\u0660-\u066f\u0671-\u06d5\u06dd-\u06de\u06e5-\u06e6\u06e9\u06ee-\u0710\u0712-\u072f\u074b-\u07a5\u07b1-\u07ea\u07f4-\u07fc\u07fe-\u0815\u081a\u0824\u0828\u082e-\u0858\u085c-\u08d2\u08e2\u0903-\u0939\u093b\u093d-\u0940\u0949-\u094c\u094e-\u0950\u0958-\u0961\u0964-\u0980\u0982-\u09bb\u09bd-\u09c0\u09c5-\u09cc\u09ce-\u09e1\u09e4-\u09fd\u09ff-\u0a00\u0a03-\u0a3b\u0a3d-\u0a40\u0a43-\u0a46\u0a49-\u0a4a\u0a4e-\u0a50\u0a52-\u0a6f\u0a72-\u0a74\u0a76-\u0a80\u0a83-\u0abb\u0abd-\u0ac0\u0ac6\u0ac9-\u0acc\u0ace-\u0ae1\u0ae4-\u0af9\u0b00\u0b02-\u0b3b\u0b3d-\u0b3e\u0b40\u0b45-\u0b4c\u0b4e-\u0b54\u0b57-\u0b61\u0b64-\u0b81\u0b83-\u0bbf\u0bc1-\u0bcc\u0bce-\u0bff\u0c01-\u0c03\u0c05-\u0c3d\u0c41-\u0c45\u0c49\u0c4e-\u0c54\u0c57-\u0c61\u0c64-\u0c80\u0c82-\u0cbb\u0cbd-\u0ccb\u0cce-\u0ce1\u0ce4-\u0cff\u0d02-\u0d3a\u0d3d-\u0d40\u0d45-\u0d4c\u0d4e-\u0d61\u0d64-\u0d80\u0d82-\u0dc9\u0dcb-\u0dd1\u0dd5\u0dd7-\u0e30\u0e32-\u0e33\u0e3b-\u0e46\u0e4f-\u0eb0\u0eb2-\u0eb3\u0ebd-\u0ec7\u0ece-\u0f17\u0f1a-\u0f34\u0f36\u0f38\u0f3a-\u0f70\u0f7f\u0f85\u0f88-\u0f8c\u0f98\u0fbd-\u0fc5\u0fc7-\u102c\u1031\u1038\u103b-\u103c\u103f-\u1057\u105a-\u105d\u1061-\u1070\u1075-\u1081\u1083-\u1084\u1087-\u108c\u108e-\u109c\u109e-\u135c\u1360-\u1711\u1715-\u1731\u1735-\u1751\u1754-\u1771\u1774-\u17b3\u17b6\u17be-\u17c5\u17c7-\u17c8\u17d4-\u17dc\u17de-\u180a\u180e-\u1884\u1887-\u18a8\u18aa-\u191f\u1923-\u1926\u1929-\u1931\u1933-\u1938\u193c-\u1a16\u1a19-\u1a1a\u1a1c-\u1a55\u1a57\u1a5f\u1a61\u1a63-\u1a64\u1a6d-\u1a72\u1a7d-\u1a7e\u1a80-\u1aaf\u1ac1-\u1aff\u1b04-\u1b33\u1b35\u1b3b\u1b3d-\u1b41\u1b43-\u1b6a\u1b74-\u1b7f\u1b82-\u1ba1\u1ba6-\u1ba7\u1baa\u1bae-\u1be5\u1be7\u1bea-\u1bec\u1bee\u1bf2-\u1c2b\u1c34-\u1c35\u1c38-\u1ccf\u1cd3\u1ce1\u1ce9-\u1cec\u1cee-\u1cf3\u1cf5-\u1cf7\u1cfa-\u1dbf\u1dfa\u1e00-\u20cf\u20f1-\u2cee\u2cf2-\u2d7e\u2d80-\u2ddf\u2e00-\u3029\u302e-\u3098\u309b-\ua66e\ua673\ua67e-\ua69d\ua6a0-\ua6ef\ua6f2-\ua801\ua803-\ua805\ua807-\ua80a\ua80c-\ua824\ua827-\ua82b\ua82d-\ua8c3\ua8c6-\ua8df\ua8f2-\ua8fe\ua900-\ua925\ua92e-\ua946\ua952-\ua97f\ua983-\ua9b2\ua9b4-\ua9b5\ua9ba-\ua9bb\ua9be-\ua9e4\ua9e6-\uaa28\uaa2f-\uaa30\uaa33-\uaa34\uaa37-\uaa42\uaa44-\uaa4b\uaa4d-\uaa7b\uaa7d-\uaaaf\uaab1\uaab5-\uaab6\uaab9-\uaabd\uaac0\uaac2-\uaaeb\uaaee-\uaaf5\uaaf7-\uabe4\uabe6-\uabe7\uabe9-\uabec\uabee-\ufb1d\ufb1f-\ufdff\ufe10-\ufe1f\ufe30-\U000101fc\U000101fe-\U000102df\U000102e1-\U00010375\U0001037b-\U00010a00\U00010a04\U00010a07-\U00010a0b\U00010a10-\U00010a37\U00010a3b-\U00010a3e\U00010a40-\U00010ae4\U00010ae7-\U00010d23\U00010d28-\U00010eaa\U00010ead-\U00010f45\U00010f51-\U00011000\U00011002-\U00011037\U00011047-\U0001107e\U00011082-\U000110b2\U000110b7-\U000110b8\U000110bb-\U000110ff\U00011103-\U00011126\U0001112c\U00011135-\U00011172\U00011174-\U0001117f\U00011182-\U000111b5\U000111bf-\U000111c8\U000111cd-\U000111ce\U000111d0-\U0001122e\U00011232-\U00011233\U00011235\U00011238-\U0001123d\U0001123f-\U000112de\U000112e0-\U000112e2\U000112eb-\U000112ff\U00011302-\U0001133a\U0001133d-\U0001133f\U00011341-\U00011365\U0001136d-\U0001136f\U00011375-\U00011437\U00011440-\U00011441\U00011445\U00011447-\U0001145d\U0001145f-\U000114b2\U000114b9\U000114bb-\U000114be\U000114c1\U000114c4-\U000115b1\U000115b6-\U000115bb\U000115be\U000115c1-\U000115db\U000115de-\U00011632\U0001163b-\U0001163c\U0001163e\U00011641-\U000116aa\U000116ac\U000116ae-\U000116af\U000116b6\U000116b8-\U0001171c\U00011720-\U00011721\U00011726\U0001172c-\U0001182e\U00011838\U0001183b-\U0001193a\U0001193d\U0001193f-\U00011942\U00011944-\U000119d3\U000119d8-\U000119d9\U000119dc-\U000119df\U000119e1-\U00011a00\U00011a07-\U00011a08\U00011a0b-\U00011a32\U00011a39-\U00011a3a\U00011a3f-\U00011a46\U00011a48-\U00011a50\U00011a57-\U00011a58\U00011a5c-\U00011a89\U00011a97\U00011a9a-\U00011c2f\U00011c37\U00011c3e-\U00011c91\U00011ca8-\U00011ca9\U00011cb1\U00011cb4\U00011cb7-\U00011d30\U00011d37-\U00011d39\U00011d3b\U00011d3e\U00011d46\U00011d48-\U00011d8f\U00011d92-\U00011d94\U00011d96\U00011d98-\U00011ef2\U00011ef5-\U00016aef\U00016af5-\U00016b2f\U00016b37-\U00016f4e\U00016f50-\U00016f8e\U00016f93-\U00016fe3\U00016fe5-\U0001bc9c\U0001bc9f-\U0001d166\U0001d16a-\U0001d17a\U0001d183-\U0001d184\U0001d18c-\U0001d1a9\U0001d1ae-\U0001d241\U0001d245-\U0001d9ff\U0001da37-\U0001da3a\U0001da6d-\U0001da74\U0001da76-\U0001da83\U0001da85-\U0001da9a\U0001daa0\U0001dab0-\U0001dfff\U0001e007\U0001e019-\U0001e01a\U0001e022\U0001e025\U0001e02b-\U0001e12f\U0001e137-\U0001e2eb\U0001e2f0-\U0001e8cf\U0001e8d7-\U0001e943\U0001e94b-\U000e00ff\U000e01f0-\U0010ffff",
    "^on": "\x00-\x20\x23-\x25\x2b-\x3a\x41-\x5a\x61-\x7a\x7f-\xa0\xa2-\xa5\xaa\xad\xb0-\xb3\xb5\xb9-\xba\xc0-\xd6\xd8-\xf6\xf8-\u02b8\u02bb-\u02c1\u02d0-\u02d1\u02e0-\u02e4\u02ee\u0300-\u0373\u0376-\u037d\u037f-\u0383\u0386\u0388-\u03f5\u03f7-\u0589\u058b-\u058c\u058f-\u0605\u0608-\u060d\u0610-\u06dd\u06df-\u06e8\u06ea-\u07f5\u07fa-\u0bf2\u0bf9\u0bfb-\u0c77\u0c7f-\u0f39\u0f3e-\u138f\u139a-\u13ff\u1401-\u169a\u169d-\u17ef\u17fa-\u17ff\u180b-\u193f\u1941-\u1943\u1946-\u19dd\u1a00-\u1fbc\u1fbe\u1fc2-\u1fcc\u1fd0-\u1fdc\u1fe0-\u1fec\u1ff0-\u1ffc\u1fff-\u200f\u2028-\u2034\u2044\u205f-\u207b\u207f-\u208b\u208f-\u20ff\u2102\u2107\u210a-\u2113\u2115\u2119-\u211d\u2124\u2126\u2128\u212a-\u2139\u213c-\u213f\u2145-\u2149\u214e-\u214f\u2160-\u2188\u218c-\u218f\u2212-\u2213\u2336-\u237a\u2395\u2427-\u243f\u244b-\u245f\u2488-\u24e9\u26ac\u2800-\u28ff\u2b74-\u2b75\u2b96\u2c00-\u2ce4\u2ceb-\u2cf8\u2d00-\u2dff\u2e53-\u2e7f\u2e9a\u2ef4-\u2eff\u2fd6-\u2fef\u2ffc-\u3000\u3005-\u3007\u3021-\u302f\u3031-\u3035\u3038-\u303c\u3040-\u309a\u309d-\u309f\u30a1-\u30fa\u30fc-\u31bf\u31e4-\u321c\u321f-\u324f\u3260-\u327b\u327f-\u32b0\u32c0-\u32cb\u32d0-\u3376\u337b-\u33dd\u33e0-\u33fe\u3400-\u4dbf\u4e00-\ua48f\ua4c7-\ua60c\ua610-\ua672\ua674-\ua67d\ua680-\ua6ff\ua722-\ua787\ua789-\ua827\ua82c-\ua873\ua878-\uab69\uab6c-\ufd3d\ufd40-\ufdfc\ufdfe-\ufe0f\ufe1a-\ufe2f\ufe50\ufe52-\ufe53\ufe55\ufe5f\ufe62-\ufe63\ufe67\ufe69-\ufe6a\ufe6c-\uff00\uff03-\uff05\uff0b-\uff1a\uff21-\uff3a\uff41-\uff5a\uff66-\uffe1\uffe5-\uffe7\uffef-\ufff8\ufffe-\U00010100\U00010102-\U0001013f\U0001018d-\U0001018f\U0001019d-\U0001019f\U000101a1-\U0001091e\U00010920-\U00010b38\U00010b40-\U00011051\U00011066-\U0001165f\U0001166d-\U00011fd4\U00011fdd-\U00011fe0\U00011ff2-\U00016fe1\U00016fe3-\U0001d1ff\U0001d242-\U0001d244\U0001d246-\U0001d2ff\U0001d357-\U0001d6da\U0001d6dc-\U0001d714\U0001d716-\U0001d74e\U0001d750-\U0001d788\U0001d78a-\U0001d7c2\U0001d7c4-\U0001eeef\U0001eef2-\U0001efff\U0001f02c-\U0001f02f\U0001f094-\U0001f09f\U0001f0af-\U0001f0b0\U0001f0c0\U0001f0d0\U0001f0f6-\U0001f10a\U0001f110-\U0001f12e\U0001f130-\U0001f169\U0001f170-\U0001f1ac\U0001f1ae-\U0001f25f\U0001f266-\U0001f2ff\U0001f6d8-\U0001f6df\U0001f6ed-\U0001f6ef\U0001f6fd-\U0001f6ff\U0001f774-\U0001f77f\U0001f7d9-\U0001f7df\U0001f7ec-\U0001f7ff\U0001f80c-\U0001f80f\U0001f848-\U0001f84f\U0001f85a-\U0001f85f\U0001f888-\U0001f88f\U0001f8ae-\U0001f8af\U0001f8b2-\U0001f8ff\U0001f979\U0001f9cc\U0001fa54-\U0001fa5f\U0001fa6e-\U0001fa6f\U0001fa75-\U0001fa77\U0001fa7b-\U0001fa7f\U0001fa87-\U0001fa8f\U0001faa9-\U0001faaf\U0001fab7-\U0001fabf\U0001fac3-\U0001facf\U0001fad7-\U0001faff\U0001fb93\U0001fbcb-\U0010ffff",
    "^pdf": "\x00-\u202b\u202d-\U0010ffff",
    "^pdi": "\x00-\u2068\u206a-\U0010ffff",
    "^r": "\x00-\u05bd\u05bf\u05c1-\u05c2\u05c4-\u05c5\u05c7-\u05cf\u05eb-\u05ee\u05f5-\u07bf\u07eb-\u07f3\u07f6-\u07f9\u07fb-\u07fd\u0816-\u0819\u081b-\u0823\u0825-\u0827\u0829-\u082f\u083f\u0859-\u085d\u085f-\u200e\u2010-\ufb1c\ufb1e\ufb29\ufb37\ufb3d\ufb3f\ufb42\ufb45\ufb50-\U000107ff\U00010806-\U00010807\U00010809\U00010836\U00010839-\U0001083b\U0001083d-\U0001083e\U00010856\U0001089f-\U000108a6\U000108b0-\U000108df\U000108f3\U000108f6-\U000108fa\U0001091c-\U0001091f\U0001093a-\U0001093e\U00010940-\U0001097f\U000109b8-\U000109bb\U000109d0-\U000109d1\U00010a01-\U00010a0f\U00010a14\U00010a18\U00010a36-\U00010a3f\U00010a49-\U00010a4f\U00010a59-\U00010a5f\U00010aa0-\U00010abf\U00010ae5-\U00010aea\U00010af7-\U00010aff\U00010b36-\U00010b3f\U00010b56-\U00010b57\U00010b73-\U00010b77\U00010b92-\U00010b98\U00010b9d-\U00010ba8\U00010bb0-\U00010bff\U00010c49-\U00010c7f\U00010cb3-\U00010cbf\U00010cf3-\U00010cf9\U00010d00-\U00010e7f\U00010eaa-\U00010eac\U00010eae-\U00010eaf\U00010eb2-\U00010eff\U00010f28-\U00010faf\U00010fcc-\U00010fdf\U00010ff7-\U0001e7ff\U0001e8c5-\U0001e8c6\U0001e8d0-\U0001e8ff\U0001e944-\U0001e94a\U0001e94c-\U0001e94f\U0001e95a-\U0001e95d\U0001e960-\U0010ffff",
    "^rle": "\x00-\u202a\u202c-\U0010ffff",
    "^rli": "\x00-\u2066\u2068-\U0010ffff",
    "^rlo": "\x00-\u202d\u202f-\U0010ffff",
    "^s": "\x00-\x08\x0a\x0c-\x1e\x20-\U0010ffff",
    "^ws": "\x00-\x0b\x0d-\x1f\x21-\u167f\u1681-\u1fff\u200b-\u2027\u2029-\u205e\u2060-\u2fff\u3001-\U0010ffff",
    "al": "\u0608\u060b\u060d\u061b-\u061c\u061e-\u064a\u066d-\u066f\u0671-\u06d5\u06e5-\u06e6\u06ee-\u06ef\u06fa-\u070d\u070f-\u0710\u0712-\u072f\u074d-\u07a5\u07b1\u0860-\u086a\u08a0-\u08b4\u08b6-\u08c7\ufb50-\ufbc1\ufbd3-\ufd3d\ufd50-\ufd8f\ufd92-\ufdc7\ufdf0-\ufdfc\ufe70-\ufe74\ufe76-\ufefc\U00010d00-\U00010d23\U00010f30-\U00010f45\U00010f51-\U00010f59\U0001ec71-\U0001ecb4\U0001ed01-\U0001ed3d\U0001ee00-\U0001ee03\U0001ee05-\U0001ee1f\U0001ee21-\U0001ee22\U0001ee24\U0001ee27\U0001ee29-\U0001ee32\U0001ee34-\U0001ee37\U0001ee39\U0001ee3b\U0001ee42\U0001ee47\U0001ee49\U0001ee4b\U0001ee4d-\U0001ee4f\U0001ee51-\U0001ee52\U0001ee54\U0001ee57\U0001ee59\U0001ee5b\U0001ee5d\U0001ee5f\U0001ee61-\U0001ee62\U0001ee64\U0001ee67-\U0001ee6a\U0001ee6c-\U0001ee72\U0001ee74-\U0001ee77\U0001ee79-\U0001ee7c\U0001ee7e\U0001ee80-\U0001ee89\U0001ee8b-\U0001ee9b\U0001eea1-\U0001eea3\U0001eea5-\U0001eea9\U0001eeab-\U0001eebb",
    "an": "\u0600-\u0605\u0660-\u0669\u066b-\u066c\u06dd\u08e2\U00010d30-\U00010d39\U00010e60-\U00010e7e",
    "b": "\x0a\x0d\x1c-\x1e\x85\u2029",
    "bn": "\x00-\x08\x0e-\x1b\x7f-\x84\x86-\x9f\xad\u180e\u200b-\u200d\u2060-\u2064\u206a-\u206f\ufeff\U0001bca0-\U0001bca3\U0001d173-\U0001d17a\U000e0001\U000e0020-\U000e007f",
    "cs": "\x2c\x2e-\x2f\x3a\xa0\u060c\u202f\u2044\ufe50\ufe52\ufe55\uff0c\uff0e-\uff0f\uff1a",
    "en": "\x30-\x39\xb2-\xb3\xb9\u06f0-\u06f9\u2070\u2074-\u2079\u2080-\u2089\u2488-\u249b\uff10-\uff19\U000102e1-\U000102fb\U0001d7ce-\U0001d7ff\U0001f100-\U0001f10a\U0001fbf0-\U0001fbf9",
    "es": "\x2b\x5c\x2d\u207a-\u207b\u208a-\u208b\u2212\ufb29\ufe62-\ufe63\uff0b\uff0d",
    "et": "\x23-\x25\xa2-\xa5\xb0-\xb1\u058f\u0609-\u060a\u066a\u09f2-\u09f3\u09fb\u0af1\u0bf9\u0e3f\u17db\u2030-\u2034\u20a0-\u20bf\u212e\u2213\ua838-\ua839\ufe5f\ufe69-\ufe6a\uff03-\uff05\uffe0-\uffe1\uffe5-\uffe6\U00011fdd-\U00011fe0\U0001e2ff",
    "fsi": "\u2068",
    "l": "\x41-\x5a\x61-\x7a\xaa\xb5\xba\xc0-\xd6\xd8-\xf6\xf8-\u02b8\u02bb-\u02c1\u02d0-\u02d1\u02e0-\u02e4\u02ee\u0370-\u0373\u0376-\u0377\u037a-\u037d\u037f\u0386\u0388-\u038a\u038c\u038e-\u03a1\u03a3-\u03f5\u03f7-\u0482\u048a-\u052f\u0531-\u0556\u0559-\u0589\u0903-\u0939\u093b\u093d-\u0940\u0949-\u094c\u094e-\u0950\u0958-\u0961\u0964-\u0980\u0982-\u0983\u0985-\u098c\u098f-\u0990\u0993-\u09a8\u09aa-\u09b0\u09b2\u09b6-\u09b9\u09bd-\u09c0\u09c7-\u09c8\u09cb-\u09cc\u09ce\u09d7\u09dc-\u09dd\u09df-\u09e1\u09e6-\u09f1\u09f4-\u09fa\u09fc-\u09fd\u0a03\u0a05-\u0a0a\u0a0f-\u0a10\u0a13-\u0a28\u0a2a-\u0a30\u0a32-\u0a33\u0a35-\u0a36\u0a38-\u0a39\u0a3e-\u0a40\u0a59-\u0a5c\u0a5e\u0a66-\u0a6f\u0a72-\u0a74\u0a76\u0a83\u0a85-\u0a8d\u0a8f-\u0a91\u0a93-\u0aa8\u0aaa-\u0ab0\u0ab2-\u0ab3\u0ab5-\u0ab9\u0abd-\u0ac0\u0ac9\u0acb-\u0acc\u0ad0\u0ae0-\u0ae1\u0ae6-\u0af0\u0af9\u0b02-\u0b03\u0b05-\u0b0c\u0b0f-\u0b10\u0b13-\u0b28\u0b2a-\u0b30\u0b32-\u0b33\u0b35-\u0b39\u0b3d-\u0b3e\u0b40\u0b47-\u0b48\u0b4b-\u0b4c\u0b57\u0b5c-\u0b5d\u0b5f-\u0b61\u0b66-\u0b77\u0b83\u0b85-\u0b8a\u0b8e-\u0b90\u0b92-\u0b95\u0b99-\u0b9a\u0b9c\u0b9e-\u0b9f\u0ba3-\u0ba4\u0ba8-\u0baa\u0bae-\u0bb9\u0bbe-\u0bbf\u0bc1-\u0bc2\u0bc6-\u0bc8\u0bca-\u0bcc\u0bd0\u0bd7\u0be6-\u0bf2\u0c01-\u0c03\u0c05-\u0c0c\u0c0e-\u0c10\u0c12-\u0c28\u0c2a-\u0c39\u0c3d\u0c41-\u0c44\u0c58-\u0c5a\u0c60-\u0c61\u0c66-\u0c6f\u0c77\u0c7f-\u0c80\u0c82-\u0c8c\u0c8e-\u0c90\u0c92-\u0ca8\u0caa-\u0cb3\u0cb5-\u0cb9\u0cbd-\u0cc4\u0cc6-\u0cc8\u0cca-\u0ccb\u0cd5-\u0cd6\u0cde\u0ce0-\u0ce1\u0ce6-\u0cef\u0cf1-\u0cf2\u0d02-\u0d0c\u0d0e-\u0d10\u0d12-\u0d3a\u0d3d-\u0d40\u0d46-\u0d48\u0d4a-\u0d4c\u0d4e-\u0d4f\u0d54-\u0d61\u0d66-\u0d7f\u0d82-\u0d83\u0d85-\u0d96\u0d9a-\u0db1\u0db3-\u0dbb\u0dbd\u0dc0-\u0dc6\u0dcf-\u0dd1\u0dd8-\u0ddf\u0de6-\u0def\u0df2-\u0df4\u0e01-\u0e30\u0e32-\u0e33\u0e40-\u0e46\u0e4f-\u0e5b\u0e81-\u0e82\u0e84\u0e86-\u0e8a\u0e8c-\u0ea3\u0ea5\u0ea7-\u0eb0\u0eb2-\u0eb3\u0ebd\u0ec0-\u0ec4\u0ec6\u0ed0-\u0ed9\u0edc-\u0edf\u0f00-\u0f17\u0f1a-\u0f34\u0f36\u0f38\u0f3e-\u0f47\u0f49-\u0f6c\u0f7f\u0f85\u0f88-\u0f8c\u0fbe-\u0fc5\u0fc7-\u0fcc\u0fce-\u0fda\u1000-\u102c\u1031\u1038\u103b-\u103c\u103f-\u1057\u105a-\u105d\u1061-\u1070\u1075-\u1081\u1083-\u1084\u1087-\u108c\u108e-\u109c\u109e-\u10c5\u10c7\u10cd\u10d0-\u1248\u124a-\u124d\u1250-\u1256\u1258\u125a-\u125d\u1260-\u1288\u128a-\u128d\u1290-\u12b0\u12b2-\u12b5\u12b8-\u12be\u12c0\u12c2-\u12c5\u12c8-\u12d6\u12d8-\u1310\u1312-\u1315\u1318-\u135a\u1360-\u137c\u1380-\u138f\u13a0-\u13f5\u13f8-\u13fd\u1401-\u167f\u1681-\u169a\u16a0-\u16f8\u1700-\u170c\u170e-\u1711\u1720-\u1731\u1735-\u1736\u1740-\u1751\u1760-\u176c\u176e-\u1770\u1780-\u17b3\u17b6\u17be-\u17c5\u17c7-\u17c8\u17d4-\u17da\u17dc\u17e0-\u17e9\u1810-\u1819\u1820-\u1878\u1880-\u1884\u1887-\u18a8\u18aa\u18b0-\u18f5\u1900-\u191e\u1923-\u1926\u1929-\u192b\u1930-\u1931\u1933-\u1938\u1946-\u196d\u1970-\u1974\u1980-\u19ab\u19b0-\u19c9\u19d0-\u19da\u1a00-\u1a16\u1a19-\u1a1a\u1a1e-\u1a55\u1a57\u1a61\u1a63-\u1a64\u1a6d-\u1a72\u1a80-\u1a89\u1a90-\u1a99\u1aa0-\u1aad\u1b04-\u1b33\u1b35\u1b3b\u1b3d-\u1b41\u1b43-\u1b4b\u1b50-\u1b6a\u1b74-\u1b7c\u1b82-\u1ba1\u1ba6-\u1ba7\u1baa\u1bae-\u1be5\u1be7\u1bea-\u1bec\u1bee\u1bf2-\u1bf3\u1bfc-\u1c2b\u1c34-\u1c35\u1c3b-\u1c49\u1c4d-\u1c88\u1c90-\u1cba\u1cbd-\u1cc7\u1cd3\u1ce1\u1ce9-\u1cec\u1cee-\u1cf3\u1cf5-\u1cf7\u1cfa\u1d00-\u1dbf\u1e00-\u1f15\u1f18-\u1f1d\u1f20-\u1f45\u1f48-\u1f4d\u1f50-\u1f57\u1f59\u1f5b\u1f5d\u1f5f-\u1f7d\u1f80-\u1fb4\u1fb6-\u1fbc\u1fbe\u1fc2-\u1fc4\u1fc6-\u1fcc\u1fd0-\u1fd3\u1fd6-\u1fdb\u1fe0-\u1fec\u1ff2-\u1ff4\u1ff6-\u1ffc\u200e\u2071\u207f\u2090-\u209c\u2102\u2107\u210a-\u2113\u2115\u2119-\u211d\u2124\u2126\u2128\u212a-\u212d\u212f-\u2139\u213c-\u213f\u2145-\u2149\u214e-\u214f\u2160-\u2188\u2336-\u237a\u2395\u249c-\u24e9\u26ac\u2800-\u28ff\u2c00-\u2c2e\u2c30-\u2c5e\u2c60-\u2ce4\u2ceb-\u2cee\u2cf2-\u2cf3\u2d00-\u2d25\u2d27\u2d2d\u2d30-\u2d67\u2d6f-\u2d70\u2d80-\u2d96\u2da0-\u2da6\u2da8-\u2dae\u2db0-\u2db6\u2db8-\u2dbe\u2dc0-\u2dc6\u2dc8-\u2dce\u2dd0-\u2dd6\u2dd8-\u2dde\u3005-\u3007\u3021-\u3029\u302e-\u302f\u3031-\u3035\u3038-\u303c\u3041-\u3096\u309d-\u309f\u30a1-\u30fa\u30fc-\u30ff\u3105-\u312f\u3131-\u318e\u3190-\u31bf\u31f0-\u321c\u3220-\u324f\u3260-\u327b\u327f-\u32b0\u32c0-\u32cb\u32d0-\u3376\u337b-\u33dd\u33e0-\u33fe\u3400\u4dbf\u4e00\u9ffc\ua000-\ua48c\ua4d0-\ua60c\ua610-\ua62b\ua640-\ua66e\ua680-\ua69d\ua6a0-\ua6ef\ua6f2-\ua6f7\ua722-\ua787\ua789-\ua7bf\ua7c2-\ua7ca\ua7f5-\ua801\ua803-\ua805\ua807-\ua80a\ua80c-\ua824\ua827\ua830-\ua837\ua840-\ua873\ua880-\ua8c3\ua8ce-\ua8d9\ua8f2-\ua8fe\ua900-\ua925\ua92e-\ua946\ua952-\ua953\ua95f-\ua97c\ua983-\ua9b2\ua9b4-\ua9b5\ua9ba-\ua9bb\ua9be-\ua9cd\ua9cf-\ua9d9\ua9de-\ua9e4\ua9e6-\ua9fe\uaa00-\uaa28\uaa2f-\uaa30\uaa33-\uaa34\uaa40-\uaa42\uaa44-\uaa4b\uaa4d\uaa50-\uaa59\uaa5c-\uaa7b\uaa7d-\uaaaf\uaab1\uaab5-\uaab6\uaab9-\uaabd\uaac0\uaac2\uaadb-\uaaeb\uaaee-\uaaf5\uab01-\uab06\uab09-\uab0e\uab11-\uab16\uab20-\uab26\uab28-\uab2e\uab30-\uab69\uab70-\uabe4\uabe6-\uabe7\uabe9-\uabec\uabf0-\uabf9\uac00\ud7a3\ud7b0-\ud7c6\ud7cb-\ud7fb\ud800\udb7f-\udb80\udbff-\udc00\udfff-\ue000\uf8ff-\ufa6d\ufa70-\ufad9\ufb00-\ufb06\ufb13-\ufb17\uff21-\uff3a\uff41-\uff5a\uff66-\uffbe\uffc2-\uffc7\uffca-\uffcf\uffd2-\uffd7\uffda-\uffdc\U00010000-\U0001000b\U0001000d-\U00010026\U00010028-\U0001003a\U0001003c-\U0001003d\U0001003f-\U0001004d\U00010050-\U0001005d\U00010080-\U000100fa\U00010100\U00010102\U00010107-\U00010133\U00010137-\U0001013f\U0001018d-\U0001018e\U000101d0-\U000101fc\U00010280-\U0001029c\U000102a0-\U000102d0\U00010300-\U00010323\U0001032d-\U0001034a\U00010350-\U00010375\U00010380-\U0001039d\U0001039f-\U000103c3\U000103c8-\U000103d5\U00010400-\U0001049d\U000104a0-\U000104a9\U000104b0-\U000104d3\U000104d8-\U000104fb\U00010500-\U00010527\U00010530-\U00010563\U0001056f\U00010600-\U00010736\U00010740-\U00010755\U00010760-\U00010767\U00011000\U00011002-\U00011037\U00011047-\U0001104d\U00011066-\U0001106f\U00011082-\U000110b2\U000110b7-\U000110b8\U000110bb-\U000110c1\U000110cd\U000110d0-\U000110e8\U000110f0-\U000110f9\U00011103-\U00011126\U0001112c\U00011136-\U00011147\U00011150-\U00011172\U00011174-\U00011176\U00011182-\U000111b5\U000111bf-\U000111c8\U000111cd-\U000111ce\U000111d0-\U000111df\U000111e1-\U000111f4\U00011200-\U00011211\U00011213-\U0001122e\U00011232-\U00011233\U00011235\U00011238-\U0001123d\U00011280-\U00011286\U00011288\U0001128a-\U0001128d\U0001128f-\U0001129d\U0001129f-\U000112a9\U000112b0-\U000112de\U000112e0-\U000112e2\U000112f0-\U000112f9\U00011302-\U00011303\U00011305-\U0001130c\U0001130f-\U00011310\U00011313-\U00011328\U0001132a-\U00011330\U00011332-\U00011333\U00011335-\U00011339\U0001133d-\U0001133f\U00011341-\U00011344\U00011347-\U00011348\U0001134b-\U0001134d\U00011350\U00011357\U0001135d-\U00011363\U00011400-\U00011437\U00011440-\U00011441\U00011445\U00011447-\U0001145b\U0001145d\U0001145f-\U00011461\U00011480-\U000114b2\U000114b9\U000114bb-\U000114be\U000114c1\U000114c4-\U000114c7\U000114d0-\U000114d9\U00011580-\U000115b1\U000115b8-\U000115bb\U000115be\U000115c1-\U000115db\U00011600-\U00011632\U0001163b-\U0001163c\U0001163e\U00011641-\U00011644\U00011650-\U00011659\U00011680-\U000116aa\U000116ac\U000116ae-\U000116af\U000116b6\U000116b8\U000116c0-\U000116c9\U00011700-\U0001171a\U00011720-\U00011721\U00011726\U00011730-\U0001173f\U00011800-\U0001182e\U00011838\U0001183b\U000118a0-\U000118f2\U000118ff-\U00011906\U00011909\U0001190c-\U00011913\U00011915-\U00011916\U00011918-\U00011935\U00011937-\U00011938\U0001193d\U0001193f-\U00011942\U00011944-\U00011946\U00011950-\U00011959\U000119a0-\U000119a7\U000119aa-\U000119d3\U000119dc-\U000119df\U000119e1-\U000119e4\U00011a00\U00011a07-\U00011a08\U00011a0b-\U00011a32\U00011a39-\U00011a3a\U00011a3f-\U00011a46\U00011a50\U00011a57-\U00011a58\U00011a5c-\U00011a89\U00011a97\U00011a9a-\U00011aa2\U00011ac0-\U00011af8\U00011c00-\U00011c08\U00011c0a-\U00011c2f\U00011c3e-\U00011c45\U00011c50-\U00011c6c\U00011c70-\U00011c8f\U00011ca9\U00011cb1\U00011cb4\U00011d00-\U00011d06\U00011d08-\U00011d09\U00011d0b-\U00011d30\U00011d46\U00011d50-\U00011d59\U00011d60-\U00011d65\U00011d67-\U00011d68\U00011d6a-\U00011d8e\U00011d93-\U00011d94\U00011d96\U00011d98\U00011da0-\U00011da9\U00011ee0-\U00011ef2\U00011ef5-\U00011ef8\U00011fb0\U00011fc0-\U00011fd4\U00011fff-\U00012399\U00012400-\U0001246e\U00012470-\U00012474\U00012480-\U00012543\U00013000-\U0001342e\U00013430-\U00013438\U00014400-\U00014646\U00016800-\U00016a38\U00016a40-\U00016a5e\U00016a60-\U00016a69\U00016a6e-\U00016a6f\U00016ad0-\U00016aed\U00016af5\U00016b00-\U00016b2f\U00016b37-\U00016b45\U00016b50-\U00016b59\U00016b5b-\U00016b61\U00016b63-\U00016b77\U00016b7d-\U00016b8f\U00016e40-\U00016e9a\U00016f00-\U00016f4a\U00016f50-\U00016f87\U00016f93-\U00016f9f\U00016fe0-\U00016fe1\U00016fe3\U00016ff0-\U00016ff1\U00017000\U000187f7\U00018800-\U00018cd5\U00018d00\U00018d08\U0001b000-\U0001b11e\U0001b150-\U0001b152\U0001b164-\U0001b167\U0001b170-\U0001b2fb\U0001bc00-\U0001bc6a\U0001bc70-\U0001bc7c\U0001bc80-\U0001bc88\U0001bc90-\U0001bc99\U0001bc9c\U0001bc9f\U0001d000-\U0001d0f5\U0001d100-\U0001d126\U0001d129-\U0001d166\U0001d16a-\U0001d172\U0001d183-\U0001d184\U0001d18c-\U0001d1a9\U0001d1ae-\U0001d1e8\U0001d2e0-\U0001d2f3\U0001d360-\U0001d378\U0001d400-\U0001d454\U0001d456-\U0001d49c\U0001d49e-\U0001d49f\U0001d4a2\U0001d4a5-\U0001d4a6\U0001d4a9-\U0001d4ac\U0001d4ae-\U0001d4b9\U0001d4bb\U0001d4bd-\U0001d4c3\U0001d4c5-\U0001d505\U0001d507-\U0001d50a\U0001d50d-\U0001d514\U0001d516-\U0001d51c\U0001d51e-\U0001d539\U0001d53b-\U0001d53e\U0001d540-\U0001d544\U0001d546\U0001d54a-\U0001d550\U0001d552-\U0001d6a5\U0001d6a8-\U0001d6da\U0001d6dc-\U0001d714\U0001d716-\U0001d74e\U0001d750-\U0001d788\U0001d78a-\U0001d7c2\U0001d7c4-\U0001d7cb\U0001d800-\U0001d9ff\U0001da37-\U0001da3a\U0001da6d-\U0001da74\U0001da76-\U0001da83\U0001da85-\U0001da8b\U0001e100-\U0001e12c\U0001e137-\U0001e13d\U0001e140-\U0001e149\U0001e14e-\U0001e14f\U0001e2c0-\U0001e2eb\U0001e2f0-\U0001e2f9\U0001f110-\U0001f12e\U0001f130-\U0001f169\U0001f170-\U0001f1ac\U0001f1e6-\U0001f202\U0001f210-\U0001f23b\U0001f240-\U0001f248\U0001f250-\U0001f251\U00020000\U0002a6dd\U0002a700\U0002b734\U0002b740\U0002b81d\U0002b820\U0002cea1\U0002ceb0\U0002ebe0\U0002f800-\U0002fa1d\U00030000\U0003134a\U000f0000\U000ffffd\U00100000\U0010fffd",
    "lre": "\u202a",
    "lri": "\u2066",
    "lro": "\u202d",
    "nsm": "\u0300-\u036f\u0483-\u0489\u0591-\u05bd\u05bf\u05c1-\u05c2\u05c4-\u05c5\u05c7\u0610-\u061a\u064b-\u065f\u0670\u06d6-\u06dc\u06df-\u06e4\u06e7-\u06e8\u06ea-\u06ed\u0711\u0730-\u074a\u07a6-\u07b0\u07eb-\u07f3\u07fd\u0816-\u0819\u081b-\u0823\u0825-\u0827\u0829-\u082d\u0859-\u085b\u08d3-\u08e1\u08e3-\u0902\u093a\u093c\u0941-\u0948\u094d\u0951-\u0957\u0962-\u0963\u0981\u09bc\u09c1-\u09c4\u09cd\u09e2-\u09e3\u09fe\u0a01-\u0a02\u0a3c\u0a41-\u0a42\u0a47-\u0a48\u0a4b-\u0a4d\u0a51\u0a70-\u0a71\u0a75\u0a81-\u0a82\u0abc\u0ac1-\u0ac5\u0ac7-\u0ac8\u0acd\u0ae2-\u0ae3\u0afa-\u0aff\u0b01\u0b3c\u0b3f\u0b41-\u0b44\u0b4d\u0b55-\u0b56\u0b62-\u0b63\u0b82\u0bc0\u0bcd\u0c00\u0c04\u0c3e-\u0c40\u0c46-\u0c48\u0c4a-\u0c4d\u0c55-\u0c56\u0c62-\u0c63\u0c81\u0cbc\u0ccc-\u0ccd\u0ce2-\u0ce3\u0d00-\u0d01\u0d3b-\u0d3c\u0d41-\u0d44\u0d4d\u0d62-\u0d63\u0d81\u0dca\u0dd2-\u0dd4\u0dd6\u0e31\u0e34-\u0e3a\u0e47-\u0e4e\u0eb1\u0eb4-\u0ebc\u0ec8-\u0ecd\u0f18-\u0f19\u0f35\u0f37\u0f39\u0f71-\u0f7e\u0f80-\u0f84\u0f86-\u0f87\u0f8d-\u0f97\u0f99-\u0fbc\u0fc6\u102d-\u1030\u1032-\u1037\u1039-\u103a\u103d-\u103e\u1058-\u1059\u105e-\u1060\u1071-\u1074\u1082\u1085-\u1086\u108d\u109d\u135d-\u135f\u1712-\u1714\u1732-\u1734\u1752-\u1753\u1772-\u1773\u17b4-\u17b5\u17b7-\u17bd\u17c6\u17c9-\u17d3\u17dd\u180b-\u180d\u1885-\u1886\u18a9\u1920-\u1922\u1927-\u1928\u1932\u1939-\u193b\u1a17-\u1a18\u1a1b\u1a56\u1a58-\u1a5e\u1a60\u1a62\u1a65-\u1a6c\u1a73-\u1a7c\u1a7f\u1ab0-\u1ac0\u1b00-\u1b03\u1b34\u1b36-\u1b3a\u1b3c\u1b42\u1b6b-\u1b73\u1b80-\u1b81\u1ba2-\u1ba5\u1ba8-\u1ba9\u1bab-\u1bad\u1be6\u1be8-\u1be9\u1bed\u1bef-\u1bf1\u1c2c-\u1c33\u1c36-\u1c37\u1cd0-\u1cd2\u1cd4-\u1ce0\u1ce2-\u1ce8\u1ced\u1cf4\u1cf8-\u1cf9\u1dc0-\u1df9\u1dfb-\u1dff\u20d0-\u20f0\u2cef-\u2cf1\u2d7f\u2de0-\u2dff\u302a-\u302d\u3099-\u309a\ua66f-\ua672\ua674-\ua67d\ua69e-\ua69f\ua6f0-\ua6f1\ua802\ua806\ua80b\ua825-\ua826\ua82c\ua8c4-\ua8c5\ua8e0-\ua8f1\ua8ff\ua926-\ua92d\ua947-\ua951\ua980-\ua982\ua9b3\ua9b6-\ua9b9\ua9bc-\ua9bd\ua9e5\uaa29-\uaa2e\uaa31-\uaa32\uaa35-\uaa36\uaa43\uaa4c\uaa7c\uaab0\uaab2-\uaab4\uaab7-\uaab8\uaabe-\uaabf\uaac1\uaaec-\uaaed\uaaf6\uabe5\uabe8\uabed\ufb1e\ufe00-\ufe0f\ufe20-\ufe2f\U000101fd\U000102e0\U00010376-\U0001037a\U00010a01-\U00010a03\U00010a05-\U00010a06\U00010a0c-\U00010a0f\U00010a38-\U00010a3a\U00010a3f\U00010ae5-\U00010ae6\U00010d24-\U00010d27\U00010eab-\U00010eac\U00010f46-\U00010f50\U00011001\U00011038-\U00011046\U0001107f-\U00011081\U000110b3-\U000110b6\U000110b9-\U000110ba\U00011100-\U00011102\U00011127-\U0001112b\U0001112d-\U00011134\U00011173\U00011180-\U00011181\U000111b6-\U000111be\U000111c9-\U000111cc\U000111cf\U0001122f-\U00011231\U00011234\U00011236-\U00011237\U0001123e\U000112df\U000112e3-\U000112ea\U00011300-\U00011301\U0001133b-\U0001133c\U00011340\U00011366-\U0001136c\U00011370-\U00011374\U00011438-\U0001143f\U00011442-\U00011444\U00011446\U0001145e\U000114b3-\U000114b8\U000114ba\U000114bf-\U000114c0\U000114c2-\U000114c3\U000115b2-\U000115b5\U000115bc-\U000115bd\U000115bf-\U000115c0\U000115dc-\U000115dd\U00011633-\U0001163a\U0001163d\U0001163f-\U00011640\U000116ab\U000116ad\U000116b0-\U000116b5\U000116b7\U0001171d-\U0001171f\U00011722-\U00011725\U00011727-\U0001172b\U0001182f-\U00011837\U00011839-\U0001183a\U0001193b-\U0001193c\U0001193e\U00011943\U000119d4-\U000119d7\U000119da-\U000119db\U000119e0\U00011a01-\U00011a06\U00011a09-\U00011a0a\U00011a33-\U00011a38\U00011a3b-\U00011a3e\U00011a47\U00011a51-\U00011a56\U00011a59-\U00011a5b\U00011a8a-\U00011a96\U00011a98-\U00011a99\U00011c30-\U00011c36\U00011c38-\U00011c3d\U00011c92-\U00011ca7\U00011caa-\U00011cb0\U00011cb2-\U00011cb3\U00011cb5-\U00011cb6\U00011d31-\U00011d36\U00011d3a\U00011d3c-\U00011d3d\U00011d3f-\U00011d45\U00011d47\U00011d90-\U00011d91\U00011d95\U00011d97\U00011ef3-\U00011ef4\U00016af0-\U00016af4\U00016b30-\U00016b36\U00016f4f\U00016f8f-\U00016f92\U00016fe4\U0001bc9d-\U0001bc9e\U0001d167-\U0001d169\U0001d17b-\U0001d182\U0001d185-\U0001d18b\U0001d1aa-\U0001d1ad\U0001d242-\U0001d244\U0001da00-\U0001da36\U0001da3b-\U0001da6c\U0001da75\U0001da84\U0001da9b-\U0001da9f\U0001daa1-\U0001daaf\U0001e000-\U0001e006\U0001e008-\U0001e018\U0001e01b-\U0001e021\U0001e023-\U0001e024\U0001e026-\U0001e02a\U0001e130-\U0001e136\U0001e2ec-\U0001e2ef\U0001e8d0-\U0001e8d6\U0001e944-\U0001e94a\U000e0100-\U000e01ef",
    "on": "\x21-\x22\x5c\x26-\x2a\x3b-\x40\x5c\x5b-\x60\x7b-\x5c\x7e\xa1\xa6-\xa9\xab-\xac\xae-\xaf\xb4\xb6-\xb8\xbb-\xbf\xd7\xf7\u02b9-\u02ba\u02c2-\u02cf\u02d2-\u02df\u02e5-\u02ed\u02ef-\u02ff\u0374-\u0375\u037e\u0384-\u0385\u0387\u03f6\u058a\u058d-\u058e\u0606-\u0607\u060e-\u060f\u06de\u06e9\u07f6-\u07f9\u0bf3-\u0bf8\u0bfa\u0c78-\u0c7e\u0f3a-\u0f3d\u1390-\u1399\u1400\u169b-\u169c\u17f0-\u17f9\u1800-\u180a\u1940\u1944-\u1945\u19de-\u19ff\u1fbd\u1fbf-\u1fc1\u1fcd-\u1fcf\u1fdd-\u1fdf\u1fed-\u1fef\u1ffd-\u1ffe\u2010-\u2027\u2035-\u2043\u2045-\u205e\u207c-\u207e\u208c-\u208e\u2100-\u2101\u2103-\u2106\u2108-\u2109\u2114\u2116-\u2118\u211e-\u2123\u2125\u2127\u2129\u213a-\u213b\u2140-\u2144\u214a-\u214d\u2150-\u215f\u2189-\u218b\u2190-\u2211\u2214-\u2335\u237b-\u2394\u2396-\u2426\u2440-\u244a\u2460-\u2487\u24ea-\u26ab\u26ad-\u27ff\u2900-\u2b73\u2b76-\u2b95\u2b97-\u2bff\u2ce5-\u2cea\u2cf9-\u2cff\u2e00-\u2e52\u2e80-\u2e99\u2e9b-\u2ef3\u2f00-\u2fd5\u2ff0-\u2ffb\u3001-\u3004\u3008-\u3020\u3030\u3036-\u3037\u303d-\u303f\u309b-\u309c\u30a0\u30fb\u31c0-\u31e3\u321d-\u321e\u3250-\u325f\u327c-\u327e\u32b1-\u32bf\u32cc-\u32cf\u3377-\u337a\u33de-\u33df\u33ff\u4dc0-\u4dff\ua490-\ua4c6\ua60d-\ua60f\ua673\ua67e-\ua67f\ua700-\ua721\ua788\ua828-\ua82b\ua874-\ua877\uab6a-\uab6b\ufd3e-\ufd3f\ufdfd\ufe10-\ufe19\ufe30-\ufe4f\ufe51\ufe54\ufe56-\ufe5e\ufe60-\ufe61\ufe64-\ufe66\ufe68\ufe6b\uff01-\uff02\uff06-\uff0a\uff1b-\uff20\uff3b-\uff40\uff5b-\uff65\uffe2-\uffe4\uffe8-\uffee\ufff9-\ufffd\U00010101\U00010140-\U0001018c\U00010190-\U0001019c\U000101a0\U0001091f\U00010b39-\U00010b3f\U00011052-\U00011065\U00011660-\U0001166c\U00011fd5-\U00011fdc\U00011fe1-\U00011ff1\U00016fe2\U0001d200-\U0001d241\U0001d245\U0001d300-\U0001d356\U0001d6db\U0001d715\U0001d74f\U0001d789\U0001d7c3\U0001eef0-\U0001eef1\U0001f000-\U0001f02b\U0001f030-\U0001f093\U0001f0a0-\U0001f0ae\U0001f0b1-\U0001f0bf\U0001f0c1-\U0001f0cf\U0001f0d1-\U0001f0f5\U0001f10b-\U0001f10f\U0001f12f\U0001f16a-\U0001f16f\U0001f1ad\U0001f260-\U0001f265\U0001f300-\U0001f6d7\U0001f6e0-\U0001f6ec\U0001f6f0-\U0001f6fc\U0001f700-\U0001f773\U0001f780-\U0001f7d8\U0001f7e0-\U0001f7eb\U0001f800-\U0001f80b\U0001f810-\U0001f847\U0001f850-\U0001f859\U0001f860-\U0001f887\U0001f890-\U0001f8ad\U0001f8b0-\U0001f8b1\U0001f900-\U0001f978\U0001f97a-\U0001f9cb\U0001f9cd-\U0001fa53\U0001fa60-\U0001fa6d\U0001fa70-\U0001fa74\U0001fa78-\U0001fa7a\U0001fa80-\U0001fa86\U0001fa90-\U0001faa8\U0001fab0-\U0001fab6\U0001fac0-\U0001fac2\U0001fad0-\U0001fad6\U0001fb00-\U0001fb92\U0001fb94-\U0001fbca",
    "pdf": "\u202c",
    "pdi": "\u2069",
    "r": "\u05be\u05c0\u05c3\u05c6\u05d0-\u05ea\u05ef-\u05f4\u07c0-\u07ea\u07f4-\u07f5\u07fa\u07fe-\u0815\u081a\u0824\u0828\u0830-\u083e\u0840-\u0858\u085e\u200f\ufb1d\ufb1f-\ufb28\ufb2a-\ufb36\ufb38-\ufb3c\ufb3e\ufb40-\ufb41\ufb43-\ufb44\ufb46-\ufb4f\U00010800-\U00010805\U00010808\U0001080a-\U00010835\U00010837-\U00010838\U0001083c\U0001083f-\U00010855\U00010857-\U0001089e\U000108a7-\U000108af\U000108e0-\U000108f2\U000108f4-\U000108f5\U000108fb-\U0001091b\U00010920-\U00010939\U0001093f\U00010980-\U000109b7\U000109bc-\U000109cf\U000109d2-\U00010a00\U00010a10-\U00010a13\U00010a15-\U00010a17\U00010a19-\U00010a35\U00010a40-\U00010a48\U00010a50-\U00010a58\U00010a60-\U00010a9f\U00010ac0-\U00010ae4\U00010aeb-\U00010af6\U00010b00-\U00010b35\U00010b40-\U00010b55\U00010b58-\U00010b72\U00010b78-\U00010b91\U00010b99-\U00010b9c\U00010ba9-\U00010baf\U00010c00-\U00010c48\U00010c80-\U00010cb2\U00010cc0-\U00010cf2\U00010cfa-\U00010cff\U00010e80-\U00010ea9\U00010ead\U00010eb0-\U00010eb1\U00010f00-\U00010f27\U00010fb0-\U00010fcb\U00010fe0-\U00010ff6\U0001e800-\U0001e8c4\U0001e8c7-\U0001e8cf\U0001e900-\U0001e943\U0001e94b\U0001e950-\U0001e959\U0001e95e-\U0001e95f",
    "rle": "\u202b",
    "rli": "\u2067",
    "rlo": "\u202e",
    "s": "\x09\x0b\x1f",
    "ws": "\x0c\x20\u1680\u2000-\u200a\u2028\u205f\u3000"
}
ascii_bidi_classes: dict[str, str] = {
    "^al": "\x00-\U0010ffff",
    "^an": "\x00-\U0010ffff",
    "^b": "\x00-\x09\x0b-\x0c\x0e-\x1b\x1f-\U0010ffff",
    "^bn": "\x09-\x0d\x1c-\x5c\x7e\x80-\U0010ffff",
    "^cs": "\x00-\x2b\x5c\x2d\x30-\x39\x3b-\U0010ffff",
    "^en": "\x00-\x2f\x3a-\U0010ffff",
    "^es": "\x00-\x2a\x2c\x2e-\U0010ffff",
    "^et": "\x00-\x22\x5c\x26-\U0010ffff",
    "^fsi": "\x00-\U0010ffff",
    "^l": "\x00-\x40\x5c\x5b-\x60\x7b-\U0010ffff",
    "^lre": "\x00-\U0010ffff",
    "^lri": "\x00-\U0010ffff",
    "^lro": "\x00-\U0010ffff",
    "^nsm": "\x00-\U0010ffff",
    "^on": "\x00-\x20\x23-\x25\x2b-\x3a\x41-\x5a\x61-\x7a\x7f-\U0010ffff",
    "^pdf": "\x00-\U0010ffff",
    "^pdi": "\x00-\U0010ffff",
    "^r": "\x00-\U0010ffff",
    "^rle": "\x00-\U0010ffff",
    "^rli": "\x00-\U0010ffff",
    "^rlo": "\x00-\U0010ffff",
    "^s": "\x00-\x08\x0a\x0c-\x1e\x20-\U0010ffff",
    "^ws": "\x00-\x0b\x0d-\x1f\x21-\U0010ffff",
    "al": "",
    "an": "",
    "b": "\x0a\x0d\x1c-\x1e",
    "bn": "\x00-\x08\x0e-\x1b\x7f",
    "cs": "\x2c\x2e-\x2f\x3a",
    "en": "\x30-\x39",
    "es": "\x2b\x5c\x2d",
    "et": "\x23-\x25",
    "fsi": "",
    "l": "\x41-\x5a\x61-\x7a",
    "lre": "",
    "lri": "",
    "lro": "",
    "nsm": "",
    "on": "\x21-\x22\x5c\x26-\x2a\x3b-\x40\x5c\x5b-\x60\x7b-\x5c\x7e",
    "pdf": "",
    "pdi": "",
    "r": "",
    "rle": "",
    "rli": "",
    "rlo": "",
    "s": "\x09\x0b\x1f",
    "ws": "\x0c\x20"
}
