"""Unicode Properties from Unicode version 13.0.0 (autogen)."""
from __future__ import annotations

unicode_joining_type: dict[str, str] = {
    "^c": "\x00-\u063f\u0641-\u07f9\u07fb-\u1809\u180b-\u200c\u200e-\U0010ffff",
    "^d": "\x00-\u061f\u0621-\u0625\u0627\u0629\u062f-\u0632\u0640\u0648\u064b-\u066d\u0670-\u0677\u0688-\u0699\u06c0\u06c3-\u06cb\u06cd\u06cf\u06d2-\u06f9\u06fd-\u06fe\u0700-\u0711\u0715-\u0719\u071e\u0728\u072a\u072c\u072f-\u074d\u0759-\u075b\u076b-\u076c\u0771\u0773-\u0774\u0778-\u0779\u0780-\u07c9\u07eb-\u0840\u0846-\u0847\u0849\u0854\u0856-\u085f\u0861\u0866-\u0867\u0869-\u089f\u08aa-\u08ae\u08b1-\u08b2\u08b5\u08b9\u08c8-\u1806\u1808-\u181f\u1879-\u1886\u18a9\u18ab-\ua83f\ua872-\U00010abf\U00010ac5-\U00010ad2\U00010ad7\U00010add\U00010ae1-\U00010aea\U00010aef-\U00010b7f\U00010b81\U00010b83-\U00010b85\U00010b89\U00010b8c\U00010b8e-\U00010b8f\U00010b91-\U00010bac\U00010baf-\U00010d00\U00010d22\U00010d24-\U00010f2f\U00010f33\U00010f45-\U00010f50\U00010f54-\U00010faf\U00010fb1\U00010fb4-\U00010fb7\U00010fb9-\U00010fba\U00010fbd\U00010fc0\U00010fc2-\U00010fc3\U00010fc5-\U00010fc9\U00010fcb-\U0001e8ff\U0001e944-\U0010ffff",
    "^l": "\x00-\ua871\ua873-\U00010acc\U00010ace-\U00010ad6\U00010ad8-\U00010cff\U00010d01-\U00010fca\U00010fcc-\U0010ffff",
    "^r": "\x00-\u0621\u0626\u0628\u062a-\u062e\u0633-\u0647\u0649-\u0670\u0674\u0678-\u0687\u069a-\u06bf\u06c1-\u06c2\u06cc\u06ce\u06d0-\u06d1\u06d4\u06d6-\u06ed\u06f0-\u070f\u0711-\u0714\u071a-\u071d\u071f-\u0727\u0729\u072b\u072d-\u072e\u0730-\u074c\u074e-\u0758\u075c-\u076a\u076d-\u0770\u0772\u0775-\u0777\u077a-\u083f\u0841-\u0845\u0848\u084a-\u0853\u0855\u0859-\u0866\u0868\u086b-\u08a9\u08ad\u08af-\u08b0\u08b3-\u08b8\u08ba-\U00010ac4\U00010ac6\U00010ac8\U00010acb-\U00010acd\U00010ad3-\U00010adc\U00010ade-\U00010ae0\U00010ae2-\U00010ae3\U00010ae5-\U00010aee\U00010af0-\U00010b80\U00010b82\U00010b86-\U00010b88\U00010b8a-\U00010b8b\U00010b8d\U00010b90\U00010b92-\U00010ba8\U00010bad-\U00010d21\U00010d23-\U00010f32\U00010f34-\U00010f53\U00010f55-\U00010fb3\U00010fb7-\U00010fb8\U00010fbb-\U00010fbc\U00010fbe-\U00010fc1\U00010fc4-\U00010fc8\U00010fca-\U0010ffff",
    "^t": "\x00-\xac\xae-\u02ff\u0370-\u0482\u048a-\u0590\u05be\u05c0\u05c3\u05c6\u05c8-\u060f\u061b\u061d-\u064a\u0660-\u066f\u0671-\u06d5\u06dd-\u06de\u06e5-\u06e6\u06e9\u06ee-\u070e\u0710\u0712-\u072f\u074b-\u07a5\u07b1-\u07ea\u07f4-\u07fc\u07fe-\u0815\u081a\u0824\u0828\u082e-\u0858\u085c-\u08d2\u08e2\u0903-\u0939\u093b\u093d-\u0940\u0949-\u094c\u094e-\u0950\u0958-\u0961\u0964-\u0980\u0982-\u09bb\u09bd-\u09c0\u09c5-\u09cc\u09ce-\u09e1\u09e4-\u09fd\u09ff-\u0a00\u0a03-\u0a3b\u0a3d-\u0a40\u0a43-\u0a46\u0a49-\u0a4a\u0a4e-\u0a50\u0a52-\u0a6f\u0a72-\u0a74\u0a76-\u0a80\u0a83-\u0abb\u0abd-\u0ac0\u0ac6\u0ac9-\u0acc\u0ace-\u0ae1\u0ae4-\u0af9\u0b00\u0b02-\u0b3b\u0b3d-\u0b3e\u0b40\u0b45-\u0b4c\u0b4e-\u0b54\u0b57-\u0b61\u0b64-\u0b81\u0b83-\u0bbf\u0bc1-\u0bcc\u0bce-\u0bff\u0c01-\u0c03\u0c05-\u0c3d\u0c41-\u0c45\u0c49\u0c4e-\u0c54\u0c57-\u0c61\u0c64-\u0c80\u0c82-\u0cbb\u0cbd-\u0cbe\u0cc0-\u0cc5\u0cc7-\u0ccb\u0cce-\u0ce1\u0ce4-\u0cff\u0d02-\u0d3a\u0d3d-\u0d40\u0d45-\u0d4c\u0d4e-\u0d61\u0d64-\u0d80\u0d82-\u0dc9\u0dcb-\u0dd1\u0dd5\u0dd7-\u0e30\u0e32-\u0e33\u0e3b-\u0e46\u0e4f-\u0eb0\u0eb2-\u0eb3\u0ebd-\u0ec7\u0ece-\u0f17\u0f1a-\u0f34\u0f36\u0f38\u0f3a-\u0f70\u0f7f\u0f85\u0f88-\u0f8c\u0f98\u0fbd-\u0fc5\u0fc7-\u102c\u1031\u1038\u103b-\u103c\u103f-\u1057\u105a-\u105d\u1061-\u1070\u1075-\u1081\u1083-\u1084\u1087-\u108c\u108e-\u109c\u109e-\u135c\u1360-\u1711\u1715-\u1731\u1735-\u1751\u1754-\u1771\u1774-\u17b3\u17b6\u17be-\u17c5\u17c7-\u17c8\u17d4-\u17dc\u17de-\u180a\u180e-\u1884\u1887-\u18a8\u18aa-\u191f\u1923-\u1926\u1929-\u1931\u1933-\u1938\u193c-\u1a16\u1a19-\u1a1a\u1a1c-\u1a55\u1a57\u1a5f\u1a61\u1a63-\u1a64\u1a6d-\u1a72\u1a7d-\u1a7e\u1a80-\u1aaf\u1ac1-\u1aff\u1b04-\u1b33\u1b35\u1b3b\u1b3d-\u1b41\u1b43-\u1b6a\u1b74-\u1b7f\u1b82-\u1ba1\u1ba6-\u1ba7\u1baa\u1bae-\u1be5\u1be7\u1bea-\u1bec\u1bee\u1bf2-\u1c2b\u1c34-\u1c35\u1c38-\u1ccf\u1cd3\u1ce1\u1ce9-\u1cec\u1cee-\u1cf3\u1cf5-\u1cf7\u1cfa-\u1dbf\u1dfa\u1e00-\u200a\u200c-\u200d\u2010-\u2029\u202f-\u205f\u2065-\u2069\u2070-\u20cf\u20f1-\u2cee\u2cf2-\u2d7e\u2d80-\u2ddf\u2e00-\u3029\u302e-\u3098\u309b-\ua66e\ua673\ua67e-\ua69d\ua6a0-\ua6ef\ua6f2-\ua801\ua803-\ua805\ua807-\ua80a\ua80c-\ua824\ua827-\ua82b\ua82d-\ua8c3\ua8c6-\ua8df\ua8f2-\ua8fe\ua900-\ua925\ua92e-\ua946\ua952-\ua97f\ua983-\ua9b2\ua9b4-\ua9b5\ua9ba-\ua9bb\ua9be-\ua9e4\ua9e6-\uaa28\uaa2f-\uaa30\uaa33-\uaa34\uaa37-\uaa42\uaa44-\uaa4b\uaa4d-\uaa7b\uaa7d-\uaaaf\uaab1\uaab5-\uaab6\uaab9-\uaabd\uaac0\uaac2-\uaaeb\uaaee-\uaaf5\uaaf7-\uabe4\uabe6-\uabe7\uabe9-\uabec\uabee-\ufb1d\ufb1f-\ufdff\ufe10-\ufe1f\ufe30-\ufefe\uff00-\ufff8\ufffc-\U000101fc\U000101fe-\U000102df\U000102e1-\U00010375\U0001037b-\U00010a00\U00010a04\U00010a07-\U00010a0b\U00010a10-\U00010a37\U00010a3b-\U00010a3e\U00010a40-\U00010ae4\U00010ae7-\U00010d23\U00010d28-\U00010eaa\U00010ead-\U00010f45\U00010f51-\U00011000\U00011002-\U00011037\U00011047-\U0001107e\U00011082-\U000110b2\U000110b7-\U000110b8\U000110bb-\U000110ff\U00011103-\U00011126\U0001112c\U00011135-\U00011172\U00011174-\U0001117f\U00011182-\U000111b5\U000111bf-\U000111c8\U000111cd-\U000111ce\U000111d0-\U0001122e\U00011232-\U00011233\U00011235\U00011238-\U0001123d\U0001123f-\U000112de\U000112e0-\U000112e2\U000112eb-\U000112ff\U00011302-\U0001133a\U0001133d-\U0001133f\U00011341-\U00011365\U0001136d-\U0001136f\U00011375-\U00011437\U00011440-\U00011441\U00011445\U00011447-\U0001145d\U0001145f-\U000114b2\U000114b9\U000114bb-\U000114be\U000114c1\U000114c4-\U000115b1\U000115b6-\U000115bb\U000115be\U000115c1-\U000115db\U000115de-\U00011632\U0001163b-\U0001163c\U0001163e\U00011641-\U000116aa\U000116ac\U000116ae-\U000116af\U000116b6\U000116b8-\U0001171c\U00011720-\U00011721\U00011726\U0001172c-\U0001182e\U00011838\U0001183b-\U0001193a\U0001193d\U0001193f-\U00011942\U00011944-\U000119d3\U000119d8-\U000119d9\U000119dc-\U000119df\U000119e1-\U00011a00\U00011a0b-\U00011a32\U00011a39-\U00011a3a\U00011a3f-\U00011a46\U00011a48-\U00011a50\U00011a57-\U00011a58\U00011a5c-\U00011a89\U00011a97\U00011a9a-\U00011c2f\U00011c37\U00011c3e\U00011c40-\U00011c91\U00011ca8-\U00011ca9\U00011cb1\U00011cb4\U00011cb7-\U00011d30\U00011d37-\U00011d39\U00011d3b\U00011d3e\U00011d46\U00011d48-\U00011d8f\U00011d92-\U00011d94\U00011d96\U00011d98-\U00011ef2\U00011ef5-\U0001342f\U00013439-\U00016aef\U00016af5-\U00016b2f\U00016b37-\U00016f4e\U00016f50-\U00016f8e\U00016f93-\U00016fe3\U00016fe5-\U0001bc9c\U0001bc9f\U0001bca4-\U0001d166\U0001d16a-\U0001d172\U0001d183-\U0001d184\U0001d18c-\U0001d1a9\U0001d1ae-\U0001d241\U0001d245-\U0001d9ff\U0001da37-\U0001da3a\U0001da6d-\U0001da74\U0001da76-\U0001da83\U0001da85-\U0001da9a\U0001daa0\U0001dab0-\U0001dfff\U0001e007\U0001e019-\U0001e01a\U0001e022\U0001e025\U0001e02b-\U0001e12f\U0001e137-\U0001e2eb\U0001e2f0-\U0001e8cf\U0001e8d7-\U0001e943\U0001e94c-\U000e0000\U000e0002-\U000e001f\U000e0080-\U000e00ff\U000e01f0-\U0010ffff",
    "^u": "\xad\u0300-\u036f\u0483-\u0489\u0591-\u05bd\u05bf\u05c1-\u05c2\u05c4-\u05c5\u05c7\u0610-\u061a\u061c\u0620\u0622-\u065f\u066e-\u0673\u0675-\u06d3\u06d5-\u06dc\u06df-\u06e4\u06e7-\u06e8\u06ea-\u06ef\u06fa-\u06fc\u06ff\u070f-\u074a\u074d-\u077f\u07a6-\u07b0\u07ca-\u07f3\u07fa\u07fd\u0816-\u0819\u081b-\u0823\u0825-\u0827\u0829-\u082d\u0840-\u085b\u0860\u0862-\u0865\u0867-\u086a\u08a0-\u08ac\u08ae-\u08b4\u08b6-\u08c7\u08d3-\u08e1\u08e3-\u0902\u093a\u093c\u0941-\u0948\u094d\u0951-\u0957\u0962-\u0963\u0981\u09bc\u09c1-\u09c4\u09cd\u09e2-\u09e3\u09fe\u0a01-\u0a02\u0a3c\u0a41-\u0a42\u0a47-\u0a48\u0a4b-\u0a4d\u0a51\u0a70-\u0a71\u0a75\u0a81-\u0a82\u0abc\u0ac1-\u0ac5\u0ac7-\u0ac8\u0acd\u0ae2-\u0ae3\u0afa-\u0aff\u0b01\u0b3c\u0b3f\u0b41-\u0b44\u0b4d\u0b55-\u0b56\u0b62-\u0b63\u0b82\u0bc0\u0bcd\u0c00\u0c04\u0c3e-\u0c40\u0c46-\u0c48\u0c4a-\u0c4d\u0c55-\u0c56\u0c62-\u0c63\u0c81\u0cbc\u0cbf\u0cc6\u0ccc-\u0ccd\u0ce2-\u0ce3\u0d00-\u0d01\u0d3b-\u0d3c\u0d41-\u0d44\u0d4d\u0d62-\u0d63\u0d81\u0dca\u0dd2-\u0dd4\u0dd6\u0e31\u0e34-\u0e3a\u0e47-\u0e4e\u0eb1\u0eb4-\u0ebc\u0ec8-\u0ecd\u0f18-\u0f19\u0f35\u0f37\u0f39\u0f71-\u0f7e\u0f80-\u0f84\u0f86-\u0f87\u0f8d-\u0f97\u0f99-\u0fbc\u0fc6\u102d-\u1030\u1032-\u1037\u1039-\u103a\u103d-\u103e\u1058-\u1059\u105e-\u1060\u1071-\u1074\u1082\u1085-\u1086\u108d\u109d\u135d-\u135f\u1712-\u1714\u1732-\u1734\u1752-\u1753\u1772-\u1773\u17b4-\u17b5\u17b7-\u17bd\u17c6\u17c9-\u17d3\u17dd\u1807\u180a-\u180d\u1820-\u1878\u1885-\u18aa\u1920-\u1922\u1927-\u1928\u1932\u1939-\u193b\u1a17-\u1a18\u1a1b\u1a56\u1a58-\u1a5e\u1a60\u1a62\u1a65-\u1a6c\u1a73-\u1a7c\u1a7f\u1ab0-\u1ac0\u1b00-\u1b03\u1b34\u1b36-\u1b3a\u1b3c\u1b42\u1b6b-\u1b73\u1b80-\u1b81\u1ba2-\u1ba5\u1ba8-\u1ba9\u1bab-\u1bad\u1be6\u1be8-\u1be9\u1bed\u1bef-\u1bf1\u1c2c-\u1c33\u1c36-\u1c37\u1cd0-\u1cd2\u1cd4-\u1ce0\u1ce2-\u1ce8\u1ced\u1cf4\u1cf8-\u1cf9\u1dc0-\u1df9\u1dfb-\u1dff\u200b\u200d-\u200f\u202a-\u202e\u2060-\u2064\u206a-\u206f\u20d0-\u20f0\u2cef-\u2cf1\u2d7f\u2de0-\u2dff\u302a-\u302d\u3099-\u309a\ua66f-\ua672\ua674-\ua67d\ua69e-\ua69f\ua6f0-\ua6f1\ua802\ua806\ua80b\ua825-\ua826\ua82c\ua840-\ua872\ua8c4-\ua8c5\ua8e0-\ua8f1\ua8ff\ua926-\ua92d\ua947-\ua951\ua980-\ua982\ua9b3\ua9b6-\ua9b9\ua9bc-\ua9bd\ua9e5\uaa29-\uaa2e\uaa31-\uaa32\uaa35-\uaa36\uaa43\uaa4c\uaa7c\uaab0\uaab2-\uaab4\uaab7-\uaab8\uaabe-\uaabf\uaac1\uaaec-\uaaed\uaaf6\uabe5\uabe8\uabed\ufb1e\ufe00-\ufe0f\ufe20-\ufe2f\ufeff\ufff9-\ufffb\U000101fd\U000102e0\U00010376-\U0001037a\U00010a01-\U00010a03\U00010a05-\U00010a06\U00010a0c-\U00010a0f\U00010a38-\U00010a3a\U00010a3f\U00010ac0-\U00010ac5\U00010ac7\U00010ac9-\U00010aca\U00010acd-\U00010ae1\U00010ae4-\U00010ae6\U00010aeb-\U00010aef\U00010b80-\U00010b91\U00010ba9-\U00010bae\U00010d00-\U00010d27\U00010eab-\U00010eac\U00010f30-\U00010f44\U00010f46-\U00010f54\U00010fb0\U00010fb2-\U00010fb6\U00010fb8-\U00010fbf\U00010fc1-\U00010fc4\U00010fc9-\U00010fcb\U00011001\U00011038-\U00011046\U0001107f-\U00011081\U000110b3-\U000110b6\U000110b9-\U000110ba\U00011100-\U00011102\U00011127-\U0001112b\U0001112d-\U00011134\U00011173\U00011180-\U00011181\U000111b6-\U000111be\U000111c9-\U000111cc\U000111cf\U0001122f-\U00011231\U00011234\U00011236-\U00011237\U0001123e\U000112df\U000112e3-\U000112ea\U00011300-\U00011301\U0001133b-\U0001133c\U00011340\U00011366-\U0001136c\U00011370-\U00011374\U00011438-\U0001143f\U00011442-\U00011444\U00011446\U0001145e\U000114b3-\U000114b8\U000114ba\U000114bf-\U000114c0\U000114c2-\U000114c3\U000115b2-\U000115b5\U000115bc-\U000115bd\U000115bf-\U000115c0\U000115dc-\U000115dd\U00011633-\U0001163a\U0001163d\U0001163f-\U00011640\U000116ab\U000116ad\U000116b0-\U000116b5\U000116b7\U0001171d-\U0001171f\U00011722-\U00011725\U00011727-\U0001172b\U0001182f-\U00011837\U00011839-\U0001183a\U0001193b-\U0001193c\U0001193e\U00011943\U000119d4-\U000119d7\U000119da-\U000119db\U000119e0\U00011a01-\U00011a0a\U00011a33-\U00011a38\U00011a3b-\U00011a3e\U00011a47\U00011a51-\U00011a56\U00011a59-\U00011a5b\U00011a8a-\U00011a96\U00011a98-\U00011a99\U00011c30-\U00011c36\U00011c38-\U00011c3d\U00011c3f\U00011c92-\U00011ca7\U00011caa-\U00011cb0\U00011cb2-\U00011cb3\U00011cb5-\U00011cb6\U00011d31-\U00011d36\U00011d3a\U00011d3c-\U00011d3d\U00011d3f-\U00011d45\U00011d47\U00011d90-\U00011d91\U00011d95\U00011d97\U00011ef3-\U00011ef4\U00013430-\U00013438\U00016af0-\U00016af4\U00016b30-\U00016b36\U00016f4f\U00016f8f-\U00016f92\U00016fe4\U0001bc9d-\U0001bc9e\U0001bca0-\U0001bca3\U0001d167-\U0001d169\U0001d173-\U0001d182\U0001d185-\U0001d18b\U0001d1aa-\U0001d1ad\U0001d242-\U0001d244\U0001da00-\U0001da36\U0001da3b-\U0001da6c\U0001da75\U0001da84\U0001da9b-\U0001da9f\U0001daa1-\U0001daaf\U0001e000-\U0001e006\U0001e008-\U0001e018\U0001e01b-\U0001e021\U0001e023-\U0001e024\U0001e026-\U0001e02a\U0001e130-\U0001e136\U0001e2ec-\U0001e2ef\U0001e8d0-\U0001e8d6\U0001e900-\U0001e94b\U000e0001\U000e0020-\U000e007f\U000e0100-\U000e01ef",
    "c": "\u0640\u07fa\u180a\u200d",
    "d": "\u0620\u0626\u0628\u062a-\u062e\u0633-\u063f\u0641-\u0647\u0649-\u064a\u066e-\u066f\u0678-\u0687\u069a-\u06bf\u06c1-\u06c2\u06cc\u06ce\u06d0-\u06d1\u06fa-\u06fc\u06ff\u0712-\u0714\u071a-\u071d\u071f-\u0727\u0729\u072b\u072d-\u072e\u074e-\u0758\u075c-\u076a\u076d-\u0770\u0772\u0775-\u0777\u077a-\u077f\u07ca-\u07ea\u0841-\u0845\u0848\u084a-\u0853\u0855\u0860\u0862-\u0865\u0868\u08a0-\u08a9\u08af-\u08b0\u08b3-\u08b4\u08b6-\u08b8\u08ba-\u08c7\u1807\u1820-\u1878\u1887-\u18a8\u18aa\ua840-\ua871\U00010ac0-\U00010ac4\U00010ad3-\U00010ad6\U00010ad8-\U00010adc\U00010ade-\U00010ae0\U00010aeb-\U00010aee\U00010b80\U00010b82\U00010b86-\U00010b88\U00010b8a-\U00010b8b\U00010b8d\U00010b90\U00010bad-\U00010bae\U00010d01-\U00010d21\U00010d23\U00010f30-\U00010f32\U00010f34-\U00010f44\U00010f51-\U00010f53\U00010fb0\U00010fb2-\U00010fb3\U00010fb8\U00010fbb-\U00010fbc\U00010fbe-\U00010fbf\U00010fc1\U00010fc4\U00010fca\U0001e900-\U0001e943",
    "l": "\ua872\U00010acd\U00010ad7\U00010d00\U00010fcb",
    "r": "\u0622-\u0625\u0627\u0629\u062f-\u0632\u0648\u0671-\u0673\u0675-\u0677\u0688-\u0699\u06c0\u06c3-\u06cb\u06cd\u06cf\u06d2-\u06d3\u06d5\u06ee-\u06ef\u0710\u0715-\u0719\u071e\u0728\u072a\u072c\u072f\u074d\u0759-\u075b\u076b-\u076c\u0771\u0773-\u0774\u0778-\u0779\u0840\u0846-\u0847\u0849\u0854\u0856-\u0858\u0867\u0869-\u086a\u08aa-\u08ac\u08ae\u08b1-\u08b2\u08b9\U00010ac5\U00010ac7\U00010ac9-\U00010aca\U00010ace-\U00010ad2\U00010add\U00010ae1\U00010ae4\U00010aef\U00010b81\U00010b83-\U00010b85\U00010b89\U00010b8c\U00010b8e-\U00010b8f\U00010b91\U00010ba9-\U00010bac\U00010d22\U00010f33\U00010f54\U00010fb4-\U00010fb6\U00010fb9-\U00010fba\U00010fbd\U00010fc2-\U00010fc3\U00010fc9",
    "t": "\xad\u0300-\u036f\u0483-\u0489\u0591-\u05bd\u05bf\u05c1-\u05c2\u05c4-\u05c5\u05c7\u0610-\u061a\u061c\u064b-\u065f\u0670\u06d6-\u06dc\u06df-\u06e4\u06e7-\u06e8\u06ea-\u06ed\u070f\u0711\u0730-\u074a\u07a6-\u07b0\u07eb-\u07f3\u07fd\u0816-\u0819\u081b-\u0823\u0825-\u0827\u0829-\u082d\u0859-\u085b\u08d3-\u08e1\u08e3-\u0902\u093a\u093c\u0941-\u0948\u094d\u0951-\u0957\u0962-\u0963\u0981\u09bc\u09c1-\u09c4\u09cd\u09e2-\u09e3\u09fe\u0a01-\u0a02\u0a3c\u0a41-\u0a42\u0a47-\u0a48\u0a4b-\u0a4d\u0a51\u0a70-\u0a71\u0a75\u0a81-\u0a82\u0abc\u0ac1-\u0ac5\u0ac7-\u0ac8\u0acd\u0ae2-\u0ae3\u0afa-\u0aff\u0b01\u0b3c\u0b3f\u0b41-\u0b44\u0b4d\u0b55-\u0b56\u0b62-\u0b63\u0b82\u0bc0\u0bcd\u0c00\u0c04\u0c3e-\u0c40\u0c46-\u0c48\u0c4a-\u0c4d\u0c55-\u0c56\u0c62-\u0c63\u0c81\u0cbc\u0cbf\u0cc6\u0ccc-\u0ccd\u0ce2-\u0ce3\u0d00-\u0d01\u0d3b-\u0d3c\u0d41-\u0d44\u0d4d\u0d62-\u0d63\u0d81\u0dca\u0dd2-\u0dd4\u0dd6\u0e31\u0e34-\u0e3a\u0e47-\u0e4e\u0eb1\u0eb4-\u0ebc\u0ec8-\u0ecd\u0f18-\u0f19\u0f35\u0f37\u0f39\u0f71-\u0f7e\u0f80-\u0f84\u0f86-\u0f87\u0f8d-\u0f97\u0f99-\u0fbc\u0fc6\u102d-\u1030\u1032-\u1037\u1039-\u103a\u103d-\u103e\u1058-\u1059\u105e-\u1060\u1071-\u1074\u1082\u1085-\u1086\u108d\u109d\u135d-\u135f\u1712-\u1714\u1732-\u1734\u1752-\u1753\u1772-\u1773\u17b4-\u17b5\u17b7-\u17bd\u17c6\u17c9-\u17d3\u17dd\u180b-\u180d\u1885-\u1886\u18a9\u1920-\u1922\u1927-\u1928\u1932\u1939-\u193b\u1a17-\u1a18\u1a1b\u1a56\u1a58-\u1a5e\u1a60\u1a62\u1a65-\u1a6c\u1a73-\u1a7c\u1a7f\u1ab0-\u1ac0\u1b00-\u1b03\u1b34\u1b36-\u1b3a\u1b3c\u1b42\u1b6b-\u1b73\u1b80-\u1b81\u1ba2-\u1ba5\u1ba8-\u1ba9\u1bab-\u1bad\u1be6\u1be8-\u1be9\u1bed\u1bef-\u1bf1\u1c2c-\u1c33\u1c36-\u1c37\u1cd0-\u1cd2\u1cd4-\u1ce0\u1ce2-\u1ce8\u1ced\u1cf4\u1cf8-\u1cf9\u1dc0-\u1df9\u1dfb-\u1dff\u200b\u200e-\u200f\u202a-\u202e\u2060-\u2064\u206a-\u206f\u20d0-\u20f0\u2cef-\u2cf1\u2d7f\u2de0-\u2dff\u302a-\u302d\u3099-\u309a\ua66f-\ua672\ua674-\ua67d\ua69e-\ua69f\ua6f0-\ua6f1\ua802\ua806\ua80b\ua825-\ua826\ua82c\ua8c4-\ua8c5\ua8e0-\ua8f1\ua8ff\ua926-\ua92d\ua947-\ua951\ua980-\ua982\ua9b3\ua9b6-\ua9b9\ua9bc-\ua9bd\ua9e5\uaa29-\uaa2e\uaa31-\uaa32\uaa35-\uaa36\uaa43\uaa4c\uaa7c\uaab0\uaab2-\uaab4\uaab7-\uaab8\uaabe-\uaabf\uaac1\uaaec-\uaaed\uaaf6\uabe5\uabe8\uabed\ufb1e\ufe00-\ufe0f\ufe20-\ufe2f\ufeff\ufff9-\ufffb\U000101fd\U000102e0\U00010376-\U0001037a\U00010a01-\U00010a03\U00010a05-\U00010a06\U00010a0c-\U00010a0f\U00010a38-\U00010a3a\U00010a3f\U00010ae5-\U00010ae6\U00010d24-\U00010d27\U00010eab-\U00010eac\U00010f46-\U00010f50\U00011001\U00011038-\U00011046\U0001107f-\U00011081\U000110b3-\U000110b6\U000110b9-\U000110ba\U00011100-\U00011102\U00011127-\U0001112b\U0001112d-\U00011134\U00011173\U00011180-\U00011181\U000111b6-\U000111be\U000111c9-\U000111cc\U000111cf\U0001122f-\U00011231\U00011234\U00011236-\U00011237\U0001123e\U000112df\U000112e3-\U000112ea\U00011300-\U00011301\U0001133b-\U0001133c\U00011340\U00011366-\U0001136c\U00011370-\U00011374\U00011438-\U0001143f\U00011442-\U00011444\U00011446\U0001145e\U000114b3-\U000114b8\U000114ba\U000114bf-\U000114c0\U000114c2-\U000114c3\U000115b2-\U000115b5\U000115bc-\U000115bd\U000115bf-\U000115c0\U000115dc-\U000115dd\U00011633-\U0001163a\U0001163d\U0001163f-\U00011640\U000116ab\U000116ad\U000116b0-\U000116b5\U000116b7\U0001171d-\U0001171f\U00011722-\U00011725\U00011727-\U0001172b\U0001182f-\U00011837\U00011839-\U0001183a\U0001193b-\U0001193c\U0001193e\U00011943\U000119d4-\U000119d7\U000119da-\U000119db\U000119e0\U00011a01-\U00011a0a\U00011a33-\U00011a38\U00011a3b-\U00011a3e\U00011a47\U00011a51-\U00011a56\U00011a59-\U00011a5b\U00011a8a-\U00011a96\U00011a98-\U00011a99\U00011c30-\U00011c36\U00011c38-\U00011c3d\U00011c3f\U00011c92-\U00011ca7\U00011caa-\U00011cb0\U00011cb2-\U00011cb3\U00011cb5-\U00011cb6\U00011d31-\U00011d36\U00011d3a\U00011d3c-\U00011d3d\U00011d3f-\U00011d45\U00011d47\U00011d90-\U00011d91\U00011d95\U00011d97\U00011ef3-\U00011ef4\U00013430-\U00013438\U00016af0-\U00016af4\U00016b30-\U00016b36\U00016f4f\U00016f8f-\U00016f92\U00016fe4\U0001bc9d-\U0001bc9e\U0001bca0-\U0001bca3\U0001d167-\U0001d169\U0001d173-\U0001d182\U0001d185-\U0001d18b\U0001d1aa-\U0001d1ad\U0001d242-\U0001d244\U0001da00-\U0001da36\U0001da3b-\U0001da6c\U0001da75\U0001da84\U0001da9b-\U0001da9f\U0001daa1-\U0001daaf\U0001e000-\U0001e006\U0001e008-\U0001e018\U0001e01b-\U0001e021\U0001e023-\U0001e024\U0001e026-\U0001e02a\U0001e130-\U0001e136\U0001e2ec-\U0001e2ef\U0001e8d0-\U0001e8d6\U0001e944-\U0001e94b\U000e0001\U000e0020-\U000e007f\U000e0100-\U000e01ef",
    "u": "\x00-\xac\xae-\u02ff\u0370-\u0482\u048a-\u0590\u05be\u05c0\u05c3\u05c6\u05c8-\u060f\u061b\u061d-\u061f\u0621\u0660-\u066d\u0674\u06d4\u06dd-\u06de\u06e5-\u06e6\u06e9\u06f0-\u06f9\u06fd-\u06fe\u0700-\u070e\u074b-\u074c\u0780-\u07a5\u07b1-\u07c9\u07f4-\u07f9\u07fb-\u07fc\u07fe-\u0815\u081a\u0824\u0828\u082e-\u083f\u085c-\u085f\u0861\u0866\u086b-\u089f\u08ad\u08b5\u08c8-\u08d2\u08e2\u0903-\u0939\u093b\u093d-\u0940\u0949-\u094c\u094e-\u0950\u0958-\u0961\u0964-\u0980\u0982-\u09bb\u09bd-\u09c0\u09c5-\u09cc\u09ce-\u09e1\u09e4-\u09fd\u09ff-\u0a00\u0a03-\u0a3b\u0a3d-\u0a40\u0a43-\u0a46\u0a49-\u0a4a\u0a4e-\u0a50\u0a52-\u0a6f\u0a72-\u0a74\u0a76-\u0a80\u0a83-\u0abb\u0abd-\u0ac0\u0ac6\u0ac9-\u0acc\u0ace-\u0ae1\u0ae4-\u0af9\u0b00\u0b02-\u0b3b\u0b3d-\u0b3e\u0b40\u0b45-\u0b4c\u0b4e-\u0b54\u0b57-\u0b61\u0b64-\u0b81\u0b83-\u0bbf\u0bc1-\u0bcc\u0bce-\u0bff\u0c01-\u0c03\u0c05-\u0c3d\u0c41-\u0c45\u0c49\u0c4e-\u0c54\u0c57-\u0c61\u0c64-\u0c80\u0c82-\u0cbb\u0cbd-\u0cbe\u0cc0-\u0cc5\u0cc7-\u0ccb\u0cce-\u0ce1\u0ce4-\u0cff\u0d02-\u0d3a\u0d3d-\u0d40\u0d45-\u0d4c\u0d4e-\u0d61\u0d64-\u0d80\u0d82-\u0dc9\u0dcb-\u0dd1\u0dd5\u0dd7-\u0e30\u0e32-\u0e33\u0e3b-\u0e46\u0e4f-\u0eb0\u0eb2-\u0eb3\u0ebd-\u0ec7\u0ece-\u0f17\u0f1a-\u0f34\u0f36\u0f38\u0f3a-\u0f70\u0f7f\u0f85\u0f88-\u0f8c\u0f98\u0fbd-\u0fc5\u0fc7-\u102c\u1031\u1038\u103b-\u103c\u103f-\u1057\u105a-\u105d\u1061-\u1070\u1075-\u1081\u1083-\u1084\u1087-\u108c\u108e-\u109c\u109e-\u135c\u1360-\u1711\u1715-\u1731\u1735-\u1751\u1754-\u1771\u1774-\u17b3\u17b6\u17be-\u17c5\u17c7-\u17c8\u17d4-\u17dc\u17de-\u1806\u1808-\u1809\u180e-\u181f\u1879-\u1884\u18ab-\u191f\u1923-\u1926\u1929-\u1931\u1933-\u1938\u193c-\u1a16\u1a19-\u1a1a\u1a1c-\u1a55\u1a57\u1a5f\u1a61\u1a63-\u1a64\u1a6d-\u1a72\u1a7d-\u1a7e\u1a80-\u1aaf\u1ac1-\u1aff\u1b04-\u1b33\u1b35\u1b3b\u1b3d-\u1b41\u1b43-\u1b6a\u1b74-\u1b7f\u1b82-\u1ba1\u1ba6-\u1ba7\u1baa\u1bae-\u1be5\u1be7\u1bea-\u1bec\u1bee\u1bf2-\u1c2b\u1c34-\u1c35\u1c38-\u1ccf\u1cd3\u1ce1\u1ce9-\u1cec\u1cee-\u1cf3\u1cf5-\u1cf7\u1cfa-\u1dbf\u1dfa\u1e00-\u200a\u200c\u2010-\u2029\u202f-\u205f\u2065-\u2069\u2070-\u20cf\u20f1-\u2cee\u2cf2-\u2d7e\u2d80-\u2ddf\u2e00-\u3029\u302e-\u3098\u309b-\ua66e\ua673\ua67e-\ua69d\ua6a0-\ua6ef\ua6f2-\ua801\ua803-\ua805\ua807-\ua80a\ua80c-\ua824\ua827-\ua82b\ua82d-\ua83f\ua873-\ua8c3\ua8c6-\ua8df\ua8f2-\ua8fe\ua900-\ua925\ua92e-\ua946\ua952-\ua97f\ua983-\ua9b2\ua9b4-\ua9b5\ua9ba-\ua9bb\ua9be-\ua9e4\ua9e6-\uaa28\uaa2f-\uaa30\uaa33-\uaa34\uaa37-\uaa42\uaa44-\uaa4b\uaa4d-\uaa7b\uaa7d-\uaaaf\uaab1\uaab5-\uaab6\uaab9-\uaabd\uaac0\uaac2-\uaaeb\uaaee-\uaaf5\uaaf7-\uabe4\uabe6-\uabe7\uabe9-\uabec\uabee-\ufb1d\ufb1f-\ufdff\ufe10-\ufe1f\ufe30-\ufefe\uff00-\ufff8\ufffc-\U000101fc\U000101fe-\U000102df\U000102e1-\U00010375\U0001037b-\U00010a00\U00010a04\U00010a07-\U00010a0b\U00010a10-\U00010a37\U00010a3b-\U00010a3e\U00010a40-\U00010abf\U00010ac6\U00010ac8\U00010acb-\U00010acc\U00010ae2-\U00010ae3\U00010ae7-\U00010aea\U00010af0-\U00010b7f\U00010b92-\U00010ba8\U00010baf-\U00010cff\U00010d28-\U00010eaa\U00010ead-\U00010f2f\U00010f45\U00010f55-\U00010faf\U00010fb1\U00010fb7\U00010fc0\U00010fc5-\U00010fc8\U00010fcc-\U00011000\U00011002-\U00011037\U00011047-\U0001107e\U00011082-\U000110b2\U000110b7-\U000110b8\U000110bb-\U000110ff\U00011103-\U00011126\U0001112c\U00011135-\U00011172\U00011174-\U0001117f\U00011182-\U000111b5\U000111bf-\U000111c8\U000111cd-\U000111ce\U000111d0-\U0001122e\U00011232-\U00011233\U00011235\U00011238-\U0001123d\U0001123f-\U000112de\U000112e0-\U000112e2\U000112eb-\U000112ff\U00011302-\U0001133a\U0001133d-\U0001133f\U00011341-\U00011365\U0001136d-\U0001136f\U00011375-\U00011437\U00011440-\U00011441\U00011445\U00011447-\U0001145d\U0001145f-\U000114b2\U000114b9\U000114bb-\U000114be\U000114c1\U000114c4-\U000115b1\U000115b6-\U000115bb\U000115be\U000115c1-\U000115db\U000115de-\U00011632\U0001163b-\U0001163c\U0001163e\U00011641-\U000116aa\U000116ac\U000116ae-\U000116af\U000116b6\U000116b8-\U0001171c\U00011720-\U00011721\U00011726\U0001172c-\U0001182e\U00011838\U0001183b-\U0001193a\U0001193d\U0001193f-\U00011942\U00011944-\U000119d3\U000119d8-\U000119d9\U000119dc-\U000119df\U000119e1-\U00011a00\U00011a0b-\U00011a32\U00011a39-\U00011a3a\U00011a3f-\U00011a46\U00011a48-\U00011a50\U00011a57-\U00011a58\U00011a5c-\U00011a89\U00011a97\U00011a9a-\U00011c2f\U00011c37\U00011c3e\U00011c40-\U00011c91\U00011ca8-\U00011ca9\U00011cb1\U00011cb4\U00011cb7-\U00011d30\U00011d37-\U00011d39\U00011d3b\U00011d3e\U00011d46\U00011d48-\U00011d8f\U00011d92-\U00011d94\U00011d96\U00011d98-\U00011ef2\U00011ef5-\U0001342f\U00013439-\U00016aef\U00016af5-\U00016b2f\U00016b37-\U00016f4e\U00016f50-\U00016f8e\U00016f93-\U00016fe3\U00016fe5-\U0001bc9c\U0001bc9f\U0001bca4-\U0001d166\U0001d16a-\U0001d172\U0001d183-\U0001d184\U0001d18c-\U0001d1a9\U0001d1ae-\U0001d241\U0001d245-\U0001d9ff\U0001da37-\U0001da3a\U0001da6d-\U0001da74\U0001da76-\U0001da83\U0001da85-\U0001da9a\U0001daa0\U0001dab0-\U0001dfff\U0001e007\U0001e019-\U0001e01a\U0001e022\U0001e025\U0001e02b-\U0001e12f\U0001e137-\U0001e2eb\U0001e2f0-\U0001e8cf\U0001e8d7-\U0001e8ff\U0001e94c-\U000e0000\U000e0002-\U000e001f\U000e0080-\U000e00ff\U000e01f0-\U0010ffff"
}
ascii_joining_type: dict[str, str] = {
    "^c": "\x00-\U0010ffff",
    "^d": "\x00-\U0010ffff",
    "^l": "\x00-\U0010ffff",
    "^r": "\x00-\U0010ffff",
    "^t": "\x00-\U0010ffff",
    "^u": "",
    "c": "",
    "d": "",
    "l": "",
    "r": "",
    "t": "",
    "u": "\x00-\U0010ffff"
}
