def list_feeds(self, deviceId=None, deviceId__in=None, type=None, include=None):
    """Auto-generated method for 'listFeeds'

    This endpoint allows developers to list and retrieve information about the feeds that are generated by a device.  
It is important to note that after using the pageSize parameter, the "totalSize" in the response represents the  total number of available feeds, not the number of feeds resulting from the query string.


    HTTP Method: GET
    Endpoint: /feeds

    Parameters:
        - deviceId (query): The device generating the feed.
        - deviceId__in (query): The device ID's of the devices for which to return the feeds.
        - type (query): The stream type of the device used to generate the feed.
        - include (query): No description provided
        - unknown (None): No description provided

    Responses:
        - 200: OK
        - 400: No description provided
        - 401: No description provided
        - 403: No description provided
        - 404: No description provided
        - 500: No description provided
    """
    endpoint = "/feeds"
    params = {}
    if deviceId is not None:
        params['deviceId'] = deviceId
    if deviceId__in is not None:
        if isinstance(deviceId__in, list):
            params['deviceId__in'] = ','.join(map(str, deviceId__in))
        else:
            params['deviceId__in'] = str(deviceId__in)
    if type is not None:
        params['type'] = type
    if include is not None:
        if isinstance(include, list):
            params['include'] = ','.join(map(str, include))
        else:
            params['include'] = str(include)
    data = None
    return self._api_call(
        endpoint=endpoint,
        method='GET',
        params=params,
        data=data,
    )
