def list_feeds(self, deviceId=None, deviceId__in=None, type=None, include=None, pageToken=None, pageSize=None):
    """Auto-generated method for 'listFeeds'

    This endpoint allows developers to list and retrieve information about the feeds that are generated by a device.  
It is important to note that after using the pageSize parameter, the "totalSize" in the response represents the  total number of available feeds, not the number of feeds resulting from the query string.


    HTTP Method: GET
    Endpoint: /feeds

    Parameters:
        - deviceId (query): The device generating the feed.
        - deviceId__in (query): The device ID's of the devices for which to return the feeds.
        - type (query): The stream type of the device used to generate the feed.
        - include (query): No description provided
        - pageToken (query): Token string value that references a page for pagination. This value is received when retrieving the first page in the `nextPageToken` and `prevPageToken` fields.

        - pageSize (query): The number of entries to return per page. The maximum range of valid page sizes is documented with minimum and  maximum values, but the range might be further limited dynamically based on the requested information, account, and system status. Values outside of the (dynamic) allowed range will not result in an error, but will be clamped to the nearest limit. Thus, logic to detect the last page should not be based on comparing the requested size with the received size, but on the existence of a `nextPageToken` value.


    Responses:
        - 200: OK
        - 400: The supplied object is invalid. Error detail will contain the validation error.
        - 401: You are not authenticated. Please authenticate and try again.
        - 403: You have no permission to access the specified resource.
        - 404: Referenced resource could not be found.
        - 500: Something went wrong in the server. Please try again.
    """
    endpoint = "/feeds"
    params = {}
    if deviceId is not None:
        params['deviceId'] = deviceId
    if deviceId__in is not None:
        if isinstance(deviceId__in, list):
            params['deviceId__in'] = ','.join(map(str, deviceId__in))
        else:
            params['deviceId__in'] = str(deviceId__in)
    if type is not None:
        params['type'] = type
    if include is not None:
        if isinstance(include, list):
            params['include'] = ','.join(map(str, include))
        else:
            params['include'] = str(include)
    if pageToken is not None:
        params['pageToken'] = pageToken
    if pageSize is not None:
        params['pageSize'] = pageSize
    data = None
    return self._api_call(
        endpoint=endpoint,
        method='GET',
        params=params,
        data=data,
    )
