"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dataclasses import dataclass, field
from datetime import datetime
from egain_api_python.errors import EgainError
from egain_api_python.types import BaseModel
import httpx
from typing import Optional


class ServiceUnavailableErrorData(BaseModel):
    status: Optional[str] = None
    r"""**Health Status**

    The overall health status of the service. When unhealthy:
    - Service may not process requests correctly
    - Performance may be significantly degraded
    - Some features may be unavailable
    - Immediate attention is required

    """

    timestamp: Optional[datetime] = None
    r"""**Health Check Timestamp**

    The exact date and time when this health check was performed. This helps with:
    - Incident timeline analysis
    - Problem duration tracking
    - Recovery time measurement
    - Historical incident analysis

    """

    version: Optional[str] = None
    r"""**API Version**

    The current version of the Import Content API. This information is useful for:
    - Support team identification
    - Known issue correlation
    - Version-specific troubleshooting
    - Upgrade planning

    """


@dataclass(frozen=True)
class ServiceUnavailableError(EgainError):
    r"""## Service is Unhealthy

    The Import Content service is experiencing critical issues and may not be able to process requests properly.

    **Health Status Details:**
    - **Overall Status**: Service is unhealthy and may not function correctly

    **Response Information:**
    - **Status**: Current health state (unhealthy)
    - **Timestamp**: When health check was performed
    - **Version**: Current API version
    - **Issues**: List of detected health problems

    """

    data: ServiceUnavailableErrorData = field(hash=False)

    def __init__(
        self,
        data: ServiceUnavailableErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
