"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dataclasses import dataclass, field
from egain_api_python.errors import EgainError
from egain_api_python.models import wserrorcommon as models_wserrorcommon
from egain_api_python.types import BaseModel
import httpx
import pydantic
from typing import List, Optional
from typing_extensions import Annotated


class WSErrorCommonData(BaseModel):
    code: str
    r"""A string that follows the pattern *{integer}-{integer}*.

    The first *{integer}* is the http status code.  This code as a whole is unique.
    * For example, error codes \"400-101\" and \"404-101\" are distinctly different.

    """

    developer_message: Annotated[str, pydantic.Field(alias="developerMessage")]
    r"""A summary of the error."""

    details: Optional[List[models_wserrorcommon.WSErrorCommonDetail]] = None

    user_message: Annotated[Optional[str], pydantic.Field(alias="userMessage")] = None
    r"""UI friendly messages are only supported by some APIs.
    * The client must explicitly request UI friendly messages by passing the *X-egain-error-message=yes* header.

    """


@dataclass(frozen=True)
class WSErrorCommon(EgainError):
    r"""Bad Request"""

    data: WSErrorCommonData = field(hash=False)

    def __init__(
        self,
        data: WSErrorCommonData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
