"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .languagecode_parameter import LanguageCodeParameter
from .resourcetype_parameter import ResourceTypeParameter
from egain_api_python.types import BaseModel
from egain_api_python.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
import pydantic
from typing import Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class AiSearchRequestTypedDict(TypedDict):
    q: str
    r"""The search query string. The string must be escaped as required by the URL syntax rules."""
    portal_id: str
    r"""The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""
    dollar_filter_user_profile_id: NotRequired[str]
    r"""The ID of the user profile.

    """
    language: NotRequired[LanguageCodeParameter]
    r"""The language that describes the details of a resource. Resources available in different languages may differ from each other. <br><br> If lang is not passed, then the portal's default language is used."""
    dollar_filter_tags: NotRequired[Dict[str, List[str]]]
    r"""An object where each key is a **Category Tag ID** (numeric string),
    and each value is an array of **Tag IDs** for that category.

    """
    dollar_filter_topic_ids: NotRequired[List[str]]
    r"""An array of topic IDs. It is used to restrict search results to specific topics."""
    dollar_filter_exclude_topic_ids: NotRequired[List[str]]
    r"""An array of topic IDs that will be excluded from the search. It includes articles that belong to the topic."""
    resource_type: NotRequired[ResourceTypeParameter]
    r"""Type of resource to be fetched."""
    article_custom_additional_attributes: NotRequired[str]
    r"""One or more comma-separated names for article custom attributes defined by the user to be returned."""
    topic_custom_additional_attributes: NotRequired[str]
    r"""One or more comma-separated names for topic custom attributes defined by the user to be returned."""
    pagenum: NotRequired[int]
    r"""Pagination parameter that specifies the page number of results to be returned. Used in conjunction with $pagesize."""
    pagesize: NotRequired[int]
    r"""Pagination parameter that specifies the number of results per page. Used in conjunction with $pagenum."""


class AiSearchRequest(BaseModel):
    q: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]
    r"""The search query string. The string must be escaped as required by the URL syntax rules."""

    portal_id: Annotated[
        str,
        pydantic.Field(alias="portalID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""

    dollar_filter_user_profile_id: Annotated[
        Optional[str],
        pydantic.Field(alias="$filter[userProfileID]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The ID of the user profile.

    """

    language: Annotated[
        Optional[LanguageCodeParameter],
        pydantic.Field(alias="$lang"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The language that describes the details of a resource. Resources available in different languages may differ from each other. <br><br> If lang is not passed, then the portal's default language is used."""

    dollar_filter_tags: Annotated[
        Optional[Dict[str, List[str]]],
        pydantic.Field(alias="$filter[tags]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""An object where each key is a **Category Tag ID** (numeric string),
    and each value is an array of **Tag IDs** for that category.

    """

    dollar_filter_topic_ids: Annotated[
        Optional[List[str]],
        pydantic.Field(alias="$filter[topicIds]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""An array of topic IDs. It is used to restrict search results to specific topics."""

    dollar_filter_exclude_topic_ids: Annotated[
        Optional[List[str]],
        pydantic.Field(alias="$filter[excludeTopicIds]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""An array of topic IDs that will be excluded from the search. It includes articles that belong to the topic."""

    resource_type: Annotated[
        Optional[ResourceTypeParameter],
        pydantic.Field(alias="resourceType"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Type of resource to be fetched."""

    article_custom_additional_attributes: Annotated[
        Optional[str],
        pydantic.Field(alias="articleCustomAdditionalAttributes"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""One or more comma-separated names for article custom attributes defined by the user to be returned."""

    topic_custom_additional_attributes: Annotated[
        Optional[str],
        pydantic.Field(alias="topicCustomAdditionalAttributes"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""One or more comma-separated names for topic custom attributes defined by the user to be returned."""

    pagenum: Annotated[
        Optional[int],
        pydantic.Field(alias="$pagenum"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 1
    r"""Pagination parameter that specifies the page number of results to be returned. Used in conjunction with $pagesize."""

    pagesize: Annotated[
        Optional[int],
        pydantic.Field(alias="$pagesize"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 10
    r"""Pagination parameter that specifies the number of results per page. Used in conjunction with $pagenum."""
