"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from egain_api_python.types import BaseModel
import pydantic
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


ArticleTypeTypeName = Literal[
    "General",
    "Guided Help",
    "Data Link",
    "Topic Home",
    "Suggestion",
    "Virtual Assistant Action",
    "Rich Message",
]
r"""Indicates the article category name."""


class ArticleTypeTypedDict(TypedDict):
    r"""The type of the Article and its attributes."""

    article_category_id: NotRequired[int]
    r"""Specifies the article category ID."""
    type_name: NotRequired[ArticleTypeTypeName]
    r"""Indicates the article category name."""
    use_structured_authoring: NotRequired[bool]
    r"""Indicates whether to use Structured Authoring for the Article Type."""
    article_type_id: NotRequired[str]
    r"""The ID of the Article Type."""


class ArticleType(BaseModel):
    r"""The type of the Article and its attributes."""

    article_category_id: Annotated[
        Optional[int], pydantic.Field(alias="articleCategoryId")
    ] = None
    r"""Specifies the article category ID."""

    type_name: Annotated[
        Optional[ArticleTypeTypeName], pydantic.Field(alias="typeName")
    ] = None
    r"""Indicates the article category name."""

    use_structured_authoring: Annotated[
        Optional[bool], pydantic.Field(alias="useStructuredAuthoring")
    ] = None
    r"""Indicates whether to use Structured Authoring for the Article Type."""

    article_type_id: Annotated[Optional[str], pydantic.Field(alias="articleTypeId")] = (
        None
    )
    r"""The ID of the Article Type."""
