"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from egain_api_python.types import BaseModel
from typing import Optional
from typing_extensions import NotRequired, TypedDict


GET_HEALTH_OP_SERVERS = [
    # Production Server
    "https://${API_DOMAIN}/knowledge/contentmgr/v4",
]


class GetHealthResponseTypedDict(TypedDict):
    r"""## Service is Healthy

    The Import Content service is operating normally with all components functioning as expected.

    **Health Status Details:**
    - **Overall Status**: Service is healthy and ready to process requests

    **Response Information:**
    - **Status**: Current health state (healthy, degraded, unhealthy)
    - **Timestamp**: When health check was performed
    - **Version**: Current API version

    """

    status: NotRequired[str]
    r"""**Health Status**

    The overall health status of the service. Possible values:
    - **healthy**: Service is operating normally
    - **degraded**: Service is functional but with performance issues
    - **unhealthy**: Service is experiencing critical issues
    - **maintenance**: Service is under planned maintenance

    """
    timestamp: NotRequired[datetime]
    r"""**Health Check Timestamp**

    The exact date and time when this health check was performed. This is useful for:
    - Tracking health check frequency
    - Correlating with other system events
    - Monitoring health check response times
    - Historical health trend analysis

    """
    version: NotRequired[str]
    r"""**API Version**

    The current version of the Import Content API. This helps with:
    - Version compatibility checking
    - Feature availability verification
    - Upgrade planning and coordination
    - Support and troubleshooting

    """
    uptime: NotRequired[str]
    r"""**Service Uptime**

    The total time the service has been running since the last restart. This metric is useful for:
    - Service stability monitoring
    - Maintenance scheduling
    - Performance trend analysis
    - Reliability assessment

    """


class GetHealthResponse(BaseModel):
    r"""## Service is Healthy

    The Import Content service is operating normally with all components functioning as expected.

    **Health Status Details:**
    - **Overall Status**: Service is healthy and ready to process requests

    **Response Information:**
    - **Status**: Current health state (healthy, degraded, unhealthy)
    - **Timestamp**: When health check was performed
    - **Version**: Current API version

    """

    status: Optional[str] = None
    r"""**Health Status**

    The overall health status of the service. Possible values:
    - **healthy**: Service is operating normally
    - **degraded**: Service is functional but with performance issues
    - **unhealthy**: Service is experiencing critical issues
    - **maintenance**: Service is under planned maintenance

    """

    timestamp: Optional[datetime] = None
    r"""**Health Check Timestamp**

    The exact date and time when this health check was performed. This is useful for:
    - Tracking health check frequency
    - Correlating with other system events
    - Monitoring health check response times
    - Historical health trend analysis

    """

    version: Optional[str] = None
    r"""**API Version**

    The current version of the Import Content API. This helps with:
    - Version compatibility checking
    - Feature availability verification
    - Upgrade planning and coordination
    - Support and troubleshooting

    """

    uptime: Optional[str] = None
    r"""**Service Uptime**

    The total time the service has been running since the last restart. This metric is useful for:
    - Service stability monitoring
    - Maintenance scheduling
    - Performance trend analysis
    - Reliability assessment

    """
